/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.metadata.converter;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.carbondata.common.exceptions.DeprecatedFeatureException;
import org.apache.carbondata.core.metadata.converter.SchemaConverter;
import org.apache.carbondata.core.metadata.datatype.DataType;
import org.apache.carbondata.core.metadata.datatype.DataTypes;
import org.apache.carbondata.core.metadata.schema.SchemaEvolution;
import org.apache.carbondata.core.metadata.schema.SchemaEvolutionEntry;
import org.apache.carbondata.core.metadata.schema.partition.PartitionType;
import org.apache.carbondata.core.metadata.schema.table.CarbonTable;
import org.apache.carbondata.core.util.CarbonUtil;
import org.apache.carbondata.format.BucketingInfo;
import org.apache.carbondata.format.ColumnSchema;
import org.apache.carbondata.format.Encoding;
import org.apache.carbondata.format.ParentColumnTableRelation;
import org.apache.carbondata.format.PartitionInfo;
import org.apache.carbondata.format.RelationIdentifier;
import org.apache.carbondata.format.TableInfo;
import org.apache.carbondata.format.TableSchema;

public class ThriftWrapperSchemaConverterImpl
implements SchemaConverter {
    @Override
    public org.apache.carbondata.format.SchemaEvolutionEntry fromWrapperToExternalSchemaEvolutionEntry(SchemaEvolutionEntry wrapperSchemaEvolutionEntry) {
        org.apache.carbondata.format.SchemaEvolutionEntry thriftSchemaEvolutionEntry = new org.apache.carbondata.format.SchemaEvolutionEntry(wrapperSchemaEvolutionEntry.getTimeStamp());
        if (null != wrapperSchemaEvolutionEntry.getAdded()) {
            ArrayList<ColumnSchema> thriftAddedColumns = new ArrayList<ColumnSchema>();
            for (org.apache.carbondata.core.metadata.schema.table.column.ColumnSchema wrapperColumnSchema : wrapperSchemaEvolutionEntry.getAdded()) {
                thriftAddedColumns.add(this.fromWrapperToExternalColumnSchema(wrapperColumnSchema));
            }
            thriftSchemaEvolutionEntry.setAdded(thriftAddedColumns);
        }
        if (null != wrapperSchemaEvolutionEntry.getRemoved()) {
            ArrayList<ColumnSchema> thriftRemovedColumns = new ArrayList<ColumnSchema>();
            for (org.apache.carbondata.core.metadata.schema.table.column.ColumnSchema wrapperColumnSchema : wrapperSchemaEvolutionEntry.getRemoved()) {
                thriftRemovedColumns.add(this.fromWrapperToExternalColumnSchema(wrapperColumnSchema));
            }
            thriftSchemaEvolutionEntry.setRemoved(thriftRemovedColumns);
        }
        return thriftSchemaEvolutionEntry;
    }

    @Override
    public org.apache.carbondata.format.SchemaEvolution fromWrapperToExternalSchemaEvolution(SchemaEvolution wrapperSchemaEvolution) {
        ArrayList<org.apache.carbondata.format.SchemaEvolutionEntry> thriftSchemaEvolEntryList = new ArrayList<org.apache.carbondata.format.SchemaEvolutionEntry>();
        for (SchemaEvolutionEntry schemaEvolutionEntry : wrapperSchemaEvolution.getSchemaEvolutionEntryList()) {
            thriftSchemaEvolEntryList.add(this.fromWrapperToExternalSchemaEvolutionEntry(schemaEvolutionEntry));
        }
        return new org.apache.carbondata.format.SchemaEvolution(thriftSchemaEvolEntryList);
    }

    private Encoding fromWrapperToExternalEncoding(org.apache.carbondata.core.metadata.encoder.Encoding encoder) {
        if (null == encoder) {
            return null;
        }
        switch (encoder) {
            case DICTIONARY: {
                return Encoding.DICTIONARY;
            }
            case DELTA: {
                return Encoding.DELTA;
            }
            case RLE: {
                return Encoding.RLE;
            }
            case INVERTED_INDEX: {
                return Encoding.INVERTED_INDEX;
            }
            case DIRECT_COMPRESS_VARCHAR: {
                return Encoding.DIRECT_COMPRESS_VARCHAR;
            }
            case BIT_PACKED: {
                return Encoding.BIT_PACKED;
            }
            case DIRECT_DICTIONARY: {
                return Encoding.DIRECT_DICTIONARY;
            }
            case INT_LENGTH_COMPLEX_CHILD_BYTE_ARRAY: {
                return Encoding.INT_LENGTH_COMPLEX_CHILD_BYTE_ARRAY;
            }
        }
        return Encoding.DICTIONARY;
    }

    private org.apache.carbondata.format.DataType fromWrapperToExternalDataType(DataType dataType) {
        if (null == dataType) {
            return null;
        }
        if (dataType.getId() == DataTypes.BOOLEAN.getId()) {
            return org.apache.carbondata.format.DataType.BOOLEAN;
        }
        if (dataType.getId() == DataTypes.STRING.getId()) {
            return org.apache.carbondata.format.DataType.STRING;
        }
        if (dataType.getId() == DataTypes.INT.getId()) {
            return org.apache.carbondata.format.DataType.INT;
        }
        if (dataType.getId() == DataTypes.SHORT.getId()) {
            return org.apache.carbondata.format.DataType.SHORT;
        }
        if (dataType.getId() == DataTypes.LONG.getId()) {
            return org.apache.carbondata.format.DataType.LONG;
        }
        if (dataType.getId() == DataTypes.DOUBLE.getId()) {
            return org.apache.carbondata.format.DataType.DOUBLE;
        }
        if (DataTypes.isDecimal(dataType)) {
            return org.apache.carbondata.format.DataType.DECIMAL;
        }
        if (dataType.getId() == DataTypes.DATE.getId()) {
            return org.apache.carbondata.format.DataType.DATE;
        }
        if (dataType.getId() == DataTypes.TIMESTAMP.getId()) {
            return org.apache.carbondata.format.DataType.TIMESTAMP;
        }
        if (dataType.getId() == DataTypes.BINARY.getId()) {
            return org.apache.carbondata.format.DataType.BINARY;
        }
        if (DataTypes.isArrayType(dataType)) {
            return org.apache.carbondata.format.DataType.ARRAY;
        }
        if (DataTypes.isStructType(dataType)) {
            return org.apache.carbondata.format.DataType.STRUCT;
        }
        if (DataTypes.isMapType(dataType)) {
            return org.apache.carbondata.format.DataType.MAP;
        }
        if (dataType.getId() == DataTypes.VARCHAR.getId()) {
            return org.apache.carbondata.format.DataType.VARCHAR;
        }
        if (dataType.getId() == DataTypes.FLOAT.getId()) {
            return org.apache.carbondata.format.DataType.FLOAT;
        }
        if (dataType.getId() == DataTypes.BYTE.getId()) {
            return org.apache.carbondata.format.DataType.BYTE;
        }
        return org.apache.carbondata.format.DataType.STRING;
    }

    @Override
    public ColumnSchema fromWrapperToExternalColumnSchema(org.apache.carbondata.core.metadata.schema.table.column.ColumnSchema wrapperColumnSchema) {
        ArrayList<Encoding> encoders = new ArrayList<Encoding>();
        for (org.apache.carbondata.core.metadata.encoder.Encoding encoder : wrapperColumnSchema.getEncodingList()) {
            encoders.add(this.fromWrapperToExternalEncoding(encoder));
        }
        ColumnSchema thriftColumnSchema = new ColumnSchema(this.fromWrapperToExternalDataType(wrapperColumnSchema.getDataType()), wrapperColumnSchema.getColumnName(), wrapperColumnSchema.getColumnUniqueId(), true, encoders, wrapperColumnSchema.isDimensionColumn());
        thriftColumnSchema.setColumn_group_id(-1);
        if (DataTypes.isDecimal(wrapperColumnSchema.getDataType())) {
            thriftColumnSchema.setScale(wrapperColumnSchema.getScale());
            thriftColumnSchema.setPrecision(wrapperColumnSchema.getPrecision());
        } else {
            thriftColumnSchema.setScale(-1);
            thriftColumnSchema.setPrecision(-1);
        }
        thriftColumnSchema.setNum_child(wrapperColumnSchema.getNumberOfChild());
        thriftColumnSchema.setDefault_value(wrapperColumnSchema.getDefaultValue());
        thriftColumnSchema.setColumnProperties(wrapperColumnSchema.getColumnProperties());
        thriftColumnSchema.setInvisible(wrapperColumnSchema.isInvisible());
        thriftColumnSchema.setColumnReferenceId(wrapperColumnSchema.getColumnReferenceId());
        thriftColumnSchema.setSchemaOrdinal(wrapperColumnSchema.getSchemaOrdinal());
        thriftColumnSchema.setSpatialColumn(wrapperColumnSchema.isSpatialColumn());
        if (wrapperColumnSchema.isSortColumn()) {
            Map<String, String> properties = wrapperColumnSchema.getColumnProperties();
            if (null == properties) {
                properties = new HashMap<String, String>();
                thriftColumnSchema.setColumnProperties(properties);
            }
            properties.put("sort_columns", "true");
        }
        if (null != wrapperColumnSchema.getAggFunction() && !wrapperColumnSchema.getAggFunction().isEmpty()) {
            thriftColumnSchema.setAggregate_function(wrapperColumnSchema.getAggFunction());
        } else if (null != wrapperColumnSchema.getTimeSeriesFunction() && !wrapperColumnSchema.getTimeSeriesFunction().isEmpty()) {
            thriftColumnSchema.setAggregate_function(wrapperColumnSchema.getTimeSeriesFunction());
        } else {
            thriftColumnSchema.setAggregate_function("");
        }
        List<org.apache.carbondata.core.metadata.schema.table.column.ParentColumnTableRelation> parentColumnTableRelations = wrapperColumnSchema.getParentColumnTableRelations();
        if (null != parentColumnTableRelations) {
            thriftColumnSchema.setParentColumnTableRelations(this.wrapperToThriftRelationList(parentColumnTableRelations));
        }
        return thriftColumnSchema;
    }

    private org.apache.carbondata.format.PartitionType fromWrapperToExternalPartitionType(PartitionType wrapperPartitionType) {
        if (null == wrapperPartitionType) {
            return null;
        }
        switch (wrapperPartitionType) {
            case HASH: 
            case LIST: 
            case RANGE: 
            case RANGE_INTERVAL: {
                DeprecatedFeatureException.customPartitionNotSupported();
                return null;
            }
        }
        return org.apache.carbondata.format.PartitionType.NATIVE_HIVE;
    }

    private PartitionInfo fromWrapperToExternalPartitionInfo(org.apache.carbondata.core.metadata.schema.PartitionInfo wrapperPartitionInfo) {
        ArrayList<ColumnSchema> thriftColumnSchema = new ArrayList<ColumnSchema>();
        for (org.apache.carbondata.core.metadata.schema.table.column.ColumnSchema wrapperColumnSchema : wrapperPartitionInfo.getColumnSchemaList()) {
            thriftColumnSchema.add(this.fromWrapperToExternalColumnSchema(wrapperColumnSchema));
        }
        return new PartitionInfo(thriftColumnSchema, this.fromWrapperToExternalPartitionType(wrapperPartitionInfo.getPartitionType()));
    }

    @Override
    public TableSchema fromWrapperToExternalTableSchema(org.apache.carbondata.core.metadata.schema.table.TableSchema wrapperTableSchema) {
        ArrayList<ColumnSchema> thriftColumnSchema = new ArrayList<ColumnSchema>();
        for (org.apache.carbondata.core.metadata.schema.table.column.ColumnSchema wrapperColumnSchema : wrapperTableSchema.getListOfColumns()) {
            thriftColumnSchema.add(this.fromWrapperToExternalColumnSchema(wrapperColumnSchema));
        }
        org.apache.carbondata.format.SchemaEvolution schemaEvolution = this.fromWrapperToExternalSchemaEvolution(wrapperTableSchema.getSchemaEvolution());
        TableSchema externalTableSchema = new TableSchema(wrapperTableSchema.getTableId(), thriftColumnSchema, schemaEvolution);
        externalTableSchema.setTableProperties(wrapperTableSchema.getTableProperties());
        if (wrapperTableSchema.getBucketingInfo() != null) {
            externalTableSchema.setBucketingInfo(this.fromWrapperToExternalBucketingInfo(wrapperTableSchema.getBucketingInfo()));
        }
        if (wrapperTableSchema.getPartitionInfo() != null) {
            externalTableSchema.setPartitionInfo(this.fromWrapperToExternalPartitionInfo(wrapperTableSchema.getPartitionInfo()));
        }
        return externalTableSchema;
    }

    private BucketingInfo fromWrapperToExternalBucketingInfo(org.apache.carbondata.core.metadata.schema.BucketingInfo bucketingInfo) {
        ArrayList<ColumnSchema> thriftColumnSchema = new ArrayList<ColumnSchema>();
        for (org.apache.carbondata.core.metadata.schema.table.column.ColumnSchema wrapperColumnSchema : bucketingInfo.getListOfColumns()) {
            thriftColumnSchema.add(this.fromWrapperToExternalColumnSchema(wrapperColumnSchema));
        }
        return new BucketingInfo(thriftColumnSchema, bucketingInfo.getNumOfRanges());
    }

    @Override
    public TableInfo fromWrapperToExternalTableInfo(org.apache.carbondata.core.metadata.schema.table.TableInfo wrapperTableInfo, String dbName, String tableName) {
        TableSchema thriftFactTable = this.fromWrapperToExternalTableSchema(wrapperTableInfo.getFactTable());
        return new TableInfo(thriftFactTable, new ArrayList());
    }

    private List<RelationIdentifier> fromWrapperToExternalRI(List<org.apache.carbondata.core.metadata.schema.table.RelationIdentifier> relationIdentifiersList) {
        ArrayList<RelationIdentifier> thriftRelationIdentifierList = new ArrayList<RelationIdentifier>();
        for (org.apache.carbondata.core.metadata.schema.table.RelationIdentifier relationIdentifier : relationIdentifiersList) {
            RelationIdentifier thriftRelationIdentifier = new RelationIdentifier();
            thriftRelationIdentifier.setDatabaseName(relationIdentifier.getDatabaseName());
            thriftRelationIdentifier.setTableName(relationIdentifier.getTableName());
            thriftRelationIdentifier.setTableId(relationIdentifier.getTableId());
            thriftRelationIdentifierList.add(thriftRelationIdentifier);
        }
        return thriftRelationIdentifierList;
    }

    private List<ParentColumnTableRelation> wrapperToThriftRelationList(List<org.apache.carbondata.core.metadata.schema.table.column.ParentColumnTableRelation> wrapperColumnRelations) {
        ArrayList<ParentColumnTableRelation> thriftColumnRelationList = new ArrayList<ParentColumnTableRelation>();
        for (org.apache.carbondata.core.metadata.schema.table.column.ParentColumnTableRelation wrapperColumnRelation : wrapperColumnRelations) {
            ParentColumnTableRelation thriftColumnTableRelation = new ParentColumnTableRelation();
            thriftColumnTableRelation.setColumnId(wrapperColumnRelation.getColumnId());
            thriftColumnTableRelation.setColumnName(wrapperColumnRelation.getColumnName());
            RelationIdentifier thriftRelationIdentifier = new RelationIdentifier();
            thriftRelationIdentifier.setDatabaseName(wrapperColumnRelation.getRelationIdentifier().getDatabaseName());
            thriftRelationIdentifier.setTableName(wrapperColumnRelation.getRelationIdentifier().getTableName());
            thriftRelationIdentifier.setTableId(wrapperColumnRelation.getRelationIdentifier().getTableId());
            thriftColumnTableRelation.setRelationIdentifier(thriftRelationIdentifier);
            thriftColumnRelationList.add(thriftColumnTableRelation);
        }
        return thriftColumnRelationList;
    }

    @Override
    public SchemaEvolutionEntry fromExternalToWrapperSchemaEvolutionEntry(org.apache.carbondata.format.SchemaEvolutionEntry externalSchemaEvolutionEntry) {
        SchemaEvolutionEntry wrapperSchemaEvolutionEntry = new SchemaEvolutionEntry();
        wrapperSchemaEvolutionEntry.setTimeStamp(externalSchemaEvolutionEntry.getTime_stamp());
        ArrayList<org.apache.carbondata.core.metadata.schema.table.column.ColumnSchema> wrapperAddedColumns = new ArrayList<org.apache.carbondata.core.metadata.schema.table.column.ColumnSchema>();
        if (null != externalSchemaEvolutionEntry.getAdded()) {
            for (ColumnSchema externalColumnSchema : externalSchemaEvolutionEntry.getAdded()) {
                wrapperAddedColumns.add(this.fromExternalToWrapperColumnSchema(externalColumnSchema));
            }
        }
        ArrayList<org.apache.carbondata.core.metadata.schema.table.column.ColumnSchema> wrapperRemovedColumns = new ArrayList<org.apache.carbondata.core.metadata.schema.table.column.ColumnSchema>();
        if (null != externalSchemaEvolutionEntry.getRemoved()) {
            for (ColumnSchema externalColumnSchema : externalSchemaEvolutionEntry.getRemoved()) {
                wrapperRemovedColumns.add(this.fromExternalToWrapperColumnSchema(externalColumnSchema));
            }
        }
        wrapperSchemaEvolutionEntry.setAdded(wrapperAddedColumns);
        wrapperSchemaEvolutionEntry.setRemoved(wrapperRemovedColumns);
        return wrapperSchemaEvolutionEntry;
    }

    @Override
    public SchemaEvolution fromExternalToWrapperSchemaEvolution(org.apache.carbondata.format.SchemaEvolution externalSchemaEvolution) {
        ArrayList<SchemaEvolutionEntry> wrapperSchemaEvolEntryList = new ArrayList<SchemaEvolutionEntry>();
        for (org.apache.carbondata.format.SchemaEvolutionEntry schemaEvolutionEntry : externalSchemaEvolution.getSchema_evolution_history()) {
            wrapperSchemaEvolEntryList.add(this.fromExternalToWrapperSchemaEvolutionEntry(schemaEvolutionEntry));
        }
        SchemaEvolution wrapperSchemaEvolution = new SchemaEvolution();
        wrapperSchemaEvolution.setSchemaEvolutionEntryList(wrapperSchemaEvolEntryList);
        return wrapperSchemaEvolution;
    }

    private org.apache.carbondata.core.metadata.encoder.Encoding fromExternalToWrapperEncoding(Encoding encoder) {
        if (null == encoder) {
            return null;
        }
        switch (encoder) {
            case DICTIONARY: {
                return org.apache.carbondata.core.metadata.encoder.Encoding.DICTIONARY;
            }
            case DELTA: {
                return org.apache.carbondata.core.metadata.encoder.Encoding.DELTA;
            }
            case RLE: {
                return org.apache.carbondata.core.metadata.encoder.Encoding.RLE;
            }
            case INVERTED_INDEX: {
                return org.apache.carbondata.core.metadata.encoder.Encoding.INVERTED_INDEX;
            }
            case DIRECT_COMPRESS_VARCHAR: {
                return org.apache.carbondata.core.metadata.encoder.Encoding.DIRECT_COMPRESS_VARCHAR;
            }
            case BIT_PACKED: {
                return org.apache.carbondata.core.metadata.encoder.Encoding.BIT_PACKED;
            }
            case INT_LENGTH_COMPLEX_CHILD_BYTE_ARRAY: {
                return org.apache.carbondata.core.metadata.encoder.Encoding.INT_LENGTH_COMPLEX_CHILD_BYTE_ARRAY;
            }
            case DIRECT_DICTIONARY: {
                return org.apache.carbondata.core.metadata.encoder.Encoding.DIRECT_DICTIONARY;
            }
        }
        return org.apache.carbondata.core.metadata.encoder.Encoding.DICTIONARY;
    }

    private DataType fromExternalToWrapperDataType(org.apache.carbondata.format.DataType dataType, int precision, int scale) {
        if (null == dataType) {
            return null;
        }
        switch (dataType) {
            case BOOLEAN: {
                return DataTypes.BOOLEAN;
            }
            case STRING: {
                return DataTypes.STRING;
            }
            case INT: {
                return DataTypes.INT;
            }
            case SHORT: {
                return DataTypes.SHORT;
            }
            case LONG: {
                return DataTypes.LONG;
            }
            case DOUBLE: {
                return DataTypes.DOUBLE;
            }
            case DECIMAL: {
                return DataTypes.createDecimalType(precision, scale);
            }
            case TIMESTAMP: {
                return DataTypes.TIMESTAMP;
            }
            case DATE: {
                return DataTypes.DATE;
            }
            case BINARY: {
                return DataTypes.BINARY;
            }
            case ARRAY: {
                return DataTypes.createDefaultArrayType();
            }
            case STRUCT: {
                return DataTypes.createDefaultStructType();
            }
            case MAP: {
                return DataTypes.createDefaultMapType();
            }
            case VARCHAR: {
                return DataTypes.VARCHAR;
            }
            case FLOAT: {
                return DataTypes.FLOAT;
            }
            case BYTE: {
                return DataTypes.BYTE;
            }
        }
        return DataTypes.STRING;
    }

    @Override
    public org.apache.carbondata.core.metadata.schema.table.column.ColumnSchema fromExternalToWrapperColumnSchema(ColumnSchema externalColumnSchema) {
        org.apache.carbondata.core.metadata.schema.table.column.ColumnSchema wrapperColumnSchema = new org.apache.carbondata.core.metadata.schema.table.column.ColumnSchema();
        wrapperColumnSchema.setColumnUniqueId(externalColumnSchema.getColumn_id());
        wrapperColumnSchema.setColumnName(externalColumnSchema.getColumn_name());
        wrapperColumnSchema.setDataType(this.fromExternalToWrapperDataType(externalColumnSchema.data_type, externalColumnSchema.precision, externalColumnSchema.scale));
        wrapperColumnSchema.setDimensionColumn(externalColumnSchema.isDimension());
        ArrayList<org.apache.carbondata.core.metadata.encoder.Encoding> encoders = new ArrayList<org.apache.carbondata.core.metadata.encoder.Encoding>();
        for (Encoding encoder : externalColumnSchema.getEncoders()) {
            encoders.add(this.fromExternalToWrapperEncoding(encoder));
        }
        wrapperColumnSchema.setEncodingList(encoders);
        wrapperColumnSchema.setNumberOfChild(externalColumnSchema.getNum_child());
        wrapperColumnSchema.setPrecision(externalColumnSchema.getPrecision());
        wrapperColumnSchema.setScale(externalColumnSchema.getScale());
        wrapperColumnSchema.setDefaultValue(externalColumnSchema.getDefault_value());
        wrapperColumnSchema.setInvisible(externalColumnSchema.isInvisible());
        wrapperColumnSchema.setColumnReferenceId(externalColumnSchema.getColumnReferenceId());
        wrapperColumnSchema.setSchemaOrdinal(externalColumnSchema.getSchemaOrdinal());
        wrapperColumnSchema.setSpatialColumn(externalColumnSchema.isSpatialColumn());
        wrapperColumnSchema.setSortColumn(false);
        Map properties = externalColumnSchema.getColumnProperties();
        if (properties != null) {
            String sortColumns = (String)properties.get("sort_columns");
            if (sortColumns != null) {
                wrapperColumnSchema.setSortColumn(true);
            }
            wrapperColumnSchema.setColumnProperties(externalColumnSchema.getColumnProperties());
        }
        wrapperColumnSchema.setFunction(externalColumnSchema.getAggregate_function());
        List parentColumnTableRelation = externalColumnSchema.getParentColumnTableRelations();
        if (null != parentColumnTableRelation) {
            wrapperColumnSchema.setParentColumnTableRelations(this.fromExternalToWrapperParentTableColumnRelations(parentColumnTableRelation));
        }
        return wrapperColumnSchema;
    }

    private PartitionType fromExternalToWrapperPartitionType(org.apache.carbondata.format.PartitionType externalPartitionType) {
        if (null == externalPartitionType) {
            return null;
        }
        switch (externalPartitionType) {
            case HASH: 
            case LIST: 
            case RANGE: 
            case RANGE_INTERVAL: {
                DeprecatedFeatureException.customPartitionNotSupported();
                return null;
            }
        }
        return PartitionType.NATIVE_HIVE;
    }

    private org.apache.carbondata.core.metadata.schema.PartitionInfo fromExternalToWrapperPartitionInfo(PartitionInfo externalPartitionInfo) {
        ArrayList<org.apache.carbondata.core.metadata.schema.table.column.ColumnSchema> wrapperColumnSchema = new ArrayList<org.apache.carbondata.core.metadata.schema.table.column.ColumnSchema>();
        for (ColumnSchema columnSchema : externalPartitionInfo.getPartition_columns()) {
            wrapperColumnSchema.add(this.fromExternalToWrapperColumnSchema(columnSchema));
        }
        return new org.apache.carbondata.core.metadata.schema.PartitionInfo(wrapperColumnSchema, this.fromExternalToWrapperPartitionType(externalPartitionInfo.getPartition_type()));
    }

    @Override
    public org.apache.carbondata.core.metadata.schema.table.TableSchema fromExternalToWrapperTableSchema(TableSchema externalTableSchema, String tableName) {
        org.apache.carbondata.core.metadata.schema.table.TableSchema wrapperTableSchema = new org.apache.carbondata.core.metadata.schema.table.TableSchema();
        wrapperTableSchema.setTableId(externalTableSchema.getTable_id());
        wrapperTableSchema.setTableName(tableName);
        wrapperTableSchema.setTableProperties(externalTableSchema.getTableProperties());
        ArrayList<org.apache.carbondata.core.metadata.schema.table.column.ColumnSchema> listOfColumns = new ArrayList<org.apache.carbondata.core.metadata.schema.table.column.ColumnSchema>();
        for (ColumnSchema externalColumnSchema : externalTableSchema.getTable_columns()) {
            listOfColumns.add(this.fromExternalToWrapperColumnSchema(externalColumnSchema));
        }
        if (null != externalTableSchema.tableProperties) {
            CarbonUtil.setLocalDictColumnsToWrapperSchema(listOfColumns, externalTableSchema.tableProperties, (String)externalTableSchema.tableProperties.get("local_dictionary_enable"));
        }
        wrapperTableSchema.setListOfColumns(listOfColumns);
        wrapperTableSchema.setSchemaEvolution(this.fromExternalToWrapperSchemaEvolution(externalTableSchema.getSchema_evolution()));
        if (externalTableSchema.isSetBucketingInfo()) {
            wrapperTableSchema.setBucketingInfo(this.fromExternalToWrapperBucketingInfo(externalTableSchema.bucketingInfo));
        }
        if (externalTableSchema.getPartitionInfo() != null) {
            wrapperTableSchema.setPartitionInfo(this.fromExternalToWrapperPartitionInfo(externalTableSchema.getPartitionInfo()));
        }
        return wrapperTableSchema;
    }

    private org.apache.carbondata.core.metadata.schema.BucketingInfo fromExternalToWrapperBucketingInfo(BucketingInfo externalBucketInfo) {
        ArrayList<org.apache.carbondata.core.metadata.schema.table.column.ColumnSchema> listOfColumns = new ArrayList<org.apache.carbondata.core.metadata.schema.table.column.ColumnSchema>();
        for (ColumnSchema externalColumnSchema : externalBucketInfo.table_columns) {
            listOfColumns.add(this.fromExternalToWrapperColumnSchema(externalColumnSchema));
        }
        return new org.apache.carbondata.core.metadata.schema.BucketingInfo(listOfColumns, externalBucketInfo.number_of_buckets);
    }

    @Override
    public org.apache.carbondata.core.metadata.schema.table.TableInfo fromExternalToWrapperTableInfo(TableInfo externalTableInfo, String dbName, String tableName, String tablePath) {
        org.apache.carbondata.core.metadata.schema.table.TableInfo wrapperTableInfo = new org.apache.carbondata.core.metadata.schema.table.TableInfo();
        List schemaEvolutionList = externalTableInfo.getFact_table().getSchema_evolution().getSchema_evolution_history();
        wrapperTableInfo.setLastUpdatedTime(((org.apache.carbondata.format.SchemaEvolutionEntry)schemaEvolutionList.get(schemaEvolutionList.size() - 1)).getTime_stamp());
        wrapperTableInfo.setDatabaseName(dbName);
        wrapperTableInfo.setTableUniqueName(CarbonTable.buildUniqueName(dbName, tableName));
        wrapperTableInfo.setFactTable(this.fromExternalToWrapperTableSchema(externalTableInfo.getFact_table(), tableName));
        wrapperTableInfo.setTablePath(tablePath);
        return wrapperTableInfo;
    }

    private List<org.apache.carbondata.core.metadata.schema.table.column.ParentColumnTableRelation> fromExternalToWrapperParentTableColumnRelations(List<ParentColumnTableRelation> thirftParentColumnRelation) {
        ArrayList<org.apache.carbondata.core.metadata.schema.table.column.ParentColumnTableRelation> parentColumnTableRelationList = new ArrayList<org.apache.carbondata.core.metadata.schema.table.column.ParentColumnTableRelation>();
        for (ParentColumnTableRelation carbonTableRelation : thirftParentColumnRelation) {
            org.apache.carbondata.core.metadata.schema.table.RelationIdentifier relationIdentifier = new org.apache.carbondata.core.metadata.schema.table.RelationIdentifier(carbonTableRelation.getRelationIdentifier().getDatabaseName(), carbonTableRelation.getRelationIdentifier().getTableName(), carbonTableRelation.getRelationIdentifier().getTableId());
            org.apache.carbondata.core.metadata.schema.table.column.ParentColumnTableRelation parentColumnTableRelation = new org.apache.carbondata.core.metadata.schema.table.column.ParentColumnTableRelation(relationIdentifier, carbonTableRelation.getColumnId(), carbonTableRelation.getColumnName());
            parentColumnTableRelationList.add(parentColumnTableRelation);
        }
        return parentColumnTableRelationList;
    }
}

