/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.metadata.datatype;

import org.apache.carbondata.core.metadata.datatype.DataType;

public class ArrayType
extends DataType {
    private DataType elementType;
    private String elementName;

    ArrayType(DataType elementType) {
        super(11, 9, "ARRAY", -1);
        this.elementType = elementType;
    }

    public ArrayType(DataType elementType, String elementName) {
        super(11, 9, "ARRAY", -1);
        this.elementType = elementType;
        this.elementName = elementName;
    }

    @Override
    public boolean isComplexType() {
        return true;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ArrayType other = (ArrayType)obj;
        if (!this.getName().equalsIgnoreCase(other.getName())) {
            return false;
        }
        return this.getElementType().equals(other.getElementType());
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.getName().hashCode();
        result = 31 * result + this.getElementType().hashCode();
        return result;
    }

    public DataType getElementType() {
        return this.elementType;
    }

    public String getElementName() {
        return this.elementName;
    }
}

