/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.metadata.datatype;

import java.io.Serializable;
import org.apache.carbondata.core.metadata.datatype.DataTypes;

public class DataType
implements Serializable {
    private static final long serialVersionUID = 19371726L;
    private int id;
    private int precedenceOrder;
    private String name;
    private int sizeInBytes;
    public static final char DOUBLE_MEASURE_CHAR = 'n';
    public static final char STRING_CHAR = 's';
    public static final char VARCHAR_CHAR = 'v';
    public static final char TIMESTAMP_CHAR = 't';
    public static final char DATE_CHAR = 'x';
    public static final char BYTE_ARRAY_CHAR = 'y';
    public static final char BYTE_VALUE_MEASURE_CHAR = 'c';
    public static final char BIG_DECIMAL_MEASURE_CHAR = 'b';
    public static final char BIG_INT_MEASURE_CHAR = 'd';

    DataType(int id, int precedenceOrder, String name, int sizeInBytes) {
        this.id = id;
        this.precedenceOrder = precedenceOrder;
        this.name = name;
        this.sizeInBytes = sizeInBytes;
    }

    public int getPrecedenceOrder() {
        return this.precedenceOrder;
    }

    public String getName() {
        return this.name;
    }

    public int getSizeInBytes() {
        return this.sizeInBytes;
    }

    public int getSizeBits() {
        return (int)(Math.log(this.getSizeInBytes()) / Math.log(2.0));
    }

    public int getId() {
        return this.id;
    }

    public boolean isComplexType() {
        return false;
    }

    public String toString() {
        return this.getName();
    }

    public static char convertType(DataType dataType) {
        if (dataType == DataTypes.BYTE || dataType == DataTypes.BOOLEAN || dataType == DataTypes.SHORT || dataType == DataTypes.SHORT_INT || dataType == DataTypes.INT || dataType == DataTypes.LONG) {
            return 'd';
        }
        if (dataType == DataTypes.DOUBLE || dataType == DataTypes.FLOAT) {
            return 'n';
        }
        if (DataTypes.isDecimal(dataType)) {
            return 'b';
        }
        if (dataType == DataTypes.STRING) {
            return 's';
        }
        if (dataType == DataTypes.VARCHAR) {
            return 'v';
        }
        if (dataType == DataTypes.TIMESTAMP) {
            return 't';
        }
        if (dataType == DataTypes.DATE) {
            return 'x';
        }
        if (dataType == DataTypes.BYTE_ARRAY || dataType == DataTypes.BINARY) {
            return 'y';
        }
        throw new RuntimeException("Unexpected type: " + dataType);
    }

    public static DataType getDataType(char type) {
        switch (type) {
            case 'd': {
                return DataTypes.LONG;
            }
            case 'n': {
                return DataTypes.DOUBLE;
            }
            case 'b': {
                return DataTypes.createDefaultDecimalType();
            }
        }
        throw new RuntimeException("Unexpected type: " + type);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.getName().hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        return this.getName().equalsIgnoreCase(((DataType)obj).getName());
    }
}

