/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.metadata.datatype;

import java.util.ArrayList;
import java.util.List;
import org.apache.carbondata.core.metadata.datatype.ArrayType;
import org.apache.carbondata.core.metadata.datatype.BinaryType;
import org.apache.carbondata.core.metadata.datatype.BooleanType;
import org.apache.carbondata.core.metadata.datatype.ByteArrayType;
import org.apache.carbondata.core.metadata.datatype.ByteType;
import org.apache.carbondata.core.metadata.datatype.DataType;
import org.apache.carbondata.core.metadata.datatype.DateType;
import org.apache.carbondata.core.metadata.datatype.DecimalType;
import org.apache.carbondata.core.metadata.datatype.DoubleType;
import org.apache.carbondata.core.metadata.datatype.FloatType;
import org.apache.carbondata.core.metadata.datatype.IntType;
import org.apache.carbondata.core.metadata.datatype.LongType;
import org.apache.carbondata.core.metadata.datatype.MapType;
import org.apache.carbondata.core.metadata.datatype.NullType;
import org.apache.carbondata.core.metadata.datatype.ShortIntType;
import org.apache.carbondata.core.metadata.datatype.ShortType;
import org.apache.carbondata.core.metadata.datatype.StringType;
import org.apache.carbondata.core.metadata.datatype.StructField;
import org.apache.carbondata.core.metadata.datatype.StructType;
import org.apache.carbondata.core.metadata.datatype.TimestampType;
import org.apache.carbondata.core.metadata.datatype.VarcharType;

public class DataTypes {
    public static final DataType STRING = StringType.STRING;
    public static final DataType DATE = DateType.DATE;
    public static final DataType TIMESTAMP = TimestampType.TIMESTAMP;
    public static final DataType BOOLEAN = BooleanType.BOOLEAN;
    public static final DataType SHORT = ShortType.SHORT;
    public static final DataType INT = IntType.INT;
    public static final DataType FLOAT = FloatType.FLOAT;
    public static final DataType LONG = LongType.LONG;
    public static final DataType DOUBLE = DoubleType.DOUBLE;
    public static final DataType NULL = NullType.NULL;
    public static final DataType BYTE = ByteType.BYTE;
    public static final DataType BINARY = BinaryType.BINARY;
    public static final DataType BYTE_ARRAY = ByteArrayType.BYTE_ARRAY;
    public static final DataType SHORT_INT = ShortIntType.SHORT_INT;
    public static final DataType VARCHAR = VarcharType.VARCHAR;
    static final int STRING_TYPE_ID = 0;
    static final int DATE_TYPE_ID = 1;
    static final int TIMESTAMP_TYPE_ID = 2;
    static final int BOOLEAN_TYPE_ID = 3;
    static final int SHORT_TYPE_ID = 4;
    static final int INT_TYPE_ID = 5;
    static final int FLOAT_TYPE_ID = 6;
    static final int LONG_TYPE_ID = 7;
    static final int DOUBLE_TYPE_ID = 8;
    static final int NULL_TYPE_ID = 9;
    static final int BYTE_TYPE_ID = 14;
    static final int BYTE_ARRAY_TYPE_ID = 15;
    static final int SHORT_INT_TYPE_ID = 16;
    static final int LEGACY_LONG_TYPE_ID = 17;
    public static final int DECIMAL_TYPE_ID = 10;
    public static final int ARRAY_TYPE_ID = 11;
    public static final int STRUCT_TYPE_ID = 12;
    public static final int MAP_TYPE_ID = 13;
    public static final int VARCHAR_TYPE_ID = 18;
    public static final int BINARY_TYPE_ID = 19;

    public static DataType valueOf(int id) {
        if (id == STRING.getId()) {
            return STRING;
        }
        if (id == DATE.getId()) {
            return DATE;
        }
        if (id == TIMESTAMP.getId()) {
            return TIMESTAMP;
        }
        if (id == BOOLEAN.getId()) {
            return BOOLEAN;
        }
        if (id == BYTE.getId()) {
            return BYTE;
        }
        if (id == SHORT.getId()) {
            return SHORT;
        }
        if (id == SHORT_INT.getId()) {
            return SHORT_INT;
        }
        if (id == INT.getId()) {
            return INT;
        }
        if (id == LONG.getId()) {
            return LONG;
        }
        if (id == FLOAT.getId()) {
            return FLOAT;
        }
        if (id == DOUBLE.getId()) {
            return DOUBLE;
        }
        if (id == NULL.getId()) {
            return NULL;
        }
        if (id == 10) {
            return DataTypes.createDefaultDecimalType();
        }
        if (id == BINARY.getId()) {
            return BINARY;
        }
        if (id == 11) {
            return DataTypes.createDefaultArrayType();
        }
        if (id == 12) {
            return DataTypes.createDefaultStructType();
        }
        if (id == 13) {
            return DataTypes.createDefaultMapType();
        }
        if (id == BYTE_ARRAY.getId()) {
            return BYTE_ARRAY;
        }
        if (id == VARCHAR.getId()) {
            return VARCHAR;
        }
        throw new RuntimeException("create DataType with invalid id: " + id);
    }

    public static DecimalType createDecimalType(int precision, int scale) {
        return new DecimalType(precision, scale);
    }

    public static DecimalType createDefaultDecimalType() {
        return new DecimalType(10, 2);
    }

    public static boolean isDecimal(DataType dataType) {
        return dataType.getId() == 10;
    }

    public static ArrayType createArrayType(DataType elementType) {
        return new ArrayType(elementType);
    }

    public static ArrayType createArrayType(DataType elementType, String elementName) {
        return new ArrayType(elementType, elementName);
    }

    public static ArrayType createDefaultArrayType() {
        return new ArrayType(STRING);
    }

    public static boolean isArrayType(DataType dataType) {
        return dataType.getId() == 11;
    }

    public static StructType createStructType(List<StructField> fields) {
        return new StructType(fields);
    }

    public static StructType createDefaultStructType() {
        return new StructType(new ArrayList<StructField>());
    }

    public static boolean isStructType(DataType dataType) {
        return dataType.getId() == 12;
    }

    public static MapType createMapType(DataType keyType, DataType valueType) {
        return new MapType(keyType, valueType);
    }

    public static MapType createDefaultMapType() {
        return new MapType(STRING, STRING);
    }

    public static boolean isMapType(DataType dataType) {
        return dataType.getId() == 13;
    }
}

