/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.metadata.datatype;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.BitSet;
import org.apache.carbondata.core.metadata.datatype.DataType;
import org.apache.carbondata.core.metadata.datatype.DataTypes;
import org.apache.carbondata.core.scan.result.vector.CarbonColumnVector;
import org.apache.carbondata.core.scan.result.vector.ColumnVectorInfo;
import org.apache.carbondata.core.scan.result.vector.impl.directread.ColumnarVectorWrapperDirectFactory;
import org.apache.carbondata.core.util.ByteUtil;
import org.apache.carbondata.core.util.DataTypeUtil;

public final class DecimalConverterFactory {
    public static final DecimalConverterFactory INSTANCE = new DecimalConverterFactory();
    private int[] minBytesForPrecision = this.minBytesForPrecision();

    private DecimalConverterFactory() {
    }

    private int computeMinBytesForPrecision(int precision) {
        int numBytes = 1;
        while (Math.pow(2.0, 8 * numBytes - 1) < Math.pow(10.0, precision)) {
            ++numBytes;
        }
        return numBytes;
    }

    private int[] minBytesForPrecision() {
        int[] data = new int[39];
        for (int i = 0; i < data.length; ++i) {
            data[i] = this.computeMinBytesForPrecision(i);
        }
        return data;
    }

    private static CarbonColumnVector getCarbonColumnVector(ColumnVectorInfo vectorInfo, BitSet nullBitSet) {
        CarbonColumnVector vector = vectorInfo.vector;
        BitSet deletedRows = vectorInfo.deletedRows;
        vector = ColumnarVectorWrapperDirectFactory.getDirectVectorWrapperFactory(vector, vectorInfo.invertedIndex, nullBitSet, deletedRows, true, false);
        return vector;
    }

    public DecimalConverter getDecimalConverter(int precision, int scale) {
        if (precision < 0) {
            return new LVBytesDecimalConverter();
        }
        if (precision <= 9) {
            return new DecimalIntConverter(scale);
        }
        if (precision <= 18) {
            return new DecimalLongConverter(scale);
        }
        return new DecimalUnscaledConverter(precision, scale);
    }

    public static class LVBytesDecimalConverter
    implements DecimalConverter {
        public static LVBytesDecimalConverter INSTANCE = new LVBytesDecimalConverter();

        @Override
        public Object convert(BigDecimal decimal) {
            return DataTypeUtil.bigDecimalToByte(decimal);
        }

        @Override
        public BigDecimal getDecimal(Object valueToBeConverted) {
            return DataTypeUtil.byteToBigDecimal((byte[])valueToBeConverted);
        }

        @Override
        public void fillVector(Object valuesToBeConverted, int size, ColumnVectorInfo vectorInfo, BitSet nullBitSet, DataType pageType) {
            CarbonColumnVector vector = DecimalConverterFactory.getCarbonColumnVector(vectorInfo, nullBitSet);
            int precision = vectorInfo.measure.getMeasure().getPrecision();
            int newMeasureScale = vectorInfo.measure.getMeasure().getScale();
            if (valuesToBeConverted instanceof byte[][]) {
                byte[][] data = (byte[][])valuesToBeConverted;
                for (int i = 0; i < size; ++i) {
                    if (nullBitSet.get(i)) {
                        vector.putNull(i);
                        continue;
                    }
                    BigDecimal value = DataTypeUtil.byteToBigDecimal(data[i]);
                    if (value.scale() < newMeasureScale) {
                        value = value.setScale(newMeasureScale);
                    }
                    vector.putDecimal(i, value, precision);
                }
            }
        }

        @Override
        public int getSize() {
            return -1;
        }

        @Override
        public DecimalConverterType getDecimalConverterType() {
            return DecimalConverterType.DECIMAL_LV;
        }
    }

    public class DecimalUnscaledConverter
    implements DecimalConverter {
        private int scale;
        private int numBytes;
        private byte[] decimalBuffer;

        DecimalUnscaledConverter(int precision, int scale) {
            this.decimalBuffer = new byte[DecimalConverterFactory.this.minBytesForPrecision[38]];
            this.scale = scale;
            this.numBytes = DecimalConverterFactory.this.minBytesForPrecision[precision];
        }

        @Override
        public Object convert(BigDecimal decimal) {
            byte[] bytes = decimal.unscaledValue().toByteArray();
            byte[] fixedLengthBytes = null;
            if (bytes.length == this.numBytes) {
                fixedLengthBytes = bytes;
            } else {
                byte signByte = 0;
                signByte = bytes[0] < 0 ? (byte)-1 : 0;
                Arrays.fill(this.decimalBuffer, 0, this.numBytes - bytes.length, signByte);
                System.arraycopy(bytes, 0, this.decimalBuffer, this.numBytes - bytes.length, bytes.length);
                fixedLengthBytes = this.decimalBuffer;
            }
            byte[] value = new byte[this.numBytes];
            System.arraycopy(fixedLengthBytes, 0, value, 0, this.numBytes);
            return value;
        }

        @Override
        public BigDecimal getDecimal(Object valueToBeConverted) {
            BigInteger bigInteger = new BigInteger((byte[])valueToBeConverted);
            return new BigDecimal(bigInteger, this.scale);
        }

        @Override
        public void fillVector(Object valuesToBeConverted, int size, ColumnVectorInfo vectorInfo, BitSet nullBitSet, DataType pageType) {
            CarbonColumnVector vector = DecimalConverterFactory.getCarbonColumnVector(vectorInfo, nullBitSet);
            int precision = vectorInfo.measure.getMeasure().getPrecision();
            int newMeasureScale = vectorInfo.measure.getMeasure().getScale();
            if (this.scale < newMeasureScale) {
                this.scale = newMeasureScale;
            }
            if (valuesToBeConverted instanceof byte[][]) {
                byte[][] data = (byte[][])valuesToBeConverted;
                for (int i = 0; i < size; ++i) {
                    if (nullBitSet.get(i)) {
                        vector.putNull(i);
                        continue;
                    }
                    BigInteger bigInteger = new BigInteger(data[i]);
                    BigDecimal value = new BigDecimal(bigInteger, this.scale);
                    if (value.scale() < newMeasureScale) {
                        value = value.setScale(newMeasureScale);
                    }
                    vector.putDecimal(i, value, precision);
                }
            }
        }

        @Override
        public int getSize() {
            return this.numBytes;
        }

        @Override
        public DecimalConverterType getDecimalConverterType() {
            return DecimalConverterType.DECIMAL_UNSCALED;
        }
    }

    public static class DecimalLongConverter
    extends DecimalIntConverter {
        DecimalLongConverter(int scale) {
            super(scale);
        }

        @Override
        public Object convert(BigDecimal decimal) {
            return decimal.unscaledValue().longValue();
        }

        @Override
        public BigDecimal getDecimal(Object valueToBeConverted) {
            return BigDecimal.valueOf((Long)valueToBeConverted, this.scale);
        }

        @Override
        public int getSize() {
            return 8;
        }

        @Override
        public DecimalConverterType getDecimalConverterType() {
            return DecimalConverterType.DECIMAL_LONG;
        }
    }

    public static class DecimalIntConverter
    implements DecimalConverter {
        protected int scale;

        DecimalIntConverter(int scale) {
            this.scale = scale;
        }

        @Override
        public Object convert(BigDecimal decimal) {
            long longValue = decimal.unscaledValue().longValue();
            return (int)longValue;
        }

        @Override
        public BigDecimal getDecimal(Object valueToBeConverted) {
            return BigDecimal.valueOf((Long)valueToBeConverted, this.scale);
        }

        @Override
        public void fillVector(Object valuesToBeConverted, int size, ColumnVectorInfo vectorInfo, BitSet nullBitSet, DataType pageType) {
            block17: {
                byte[] data;
                int newMeasureScale;
                int precision;
                CarbonColumnVector vector;
                block20: {
                    block19: {
                        block18: {
                            block16: {
                                vector = DecimalConverterFactory.getCarbonColumnVector(vectorInfo, nullBitSet);
                                precision = vectorInfo.measure.getMeasure().getPrecision();
                                newMeasureScale = vectorInfo.measure.getMeasure().getScale();
                                if (!(valuesToBeConverted instanceof byte[])) {
                                    throw new UnsupportedOperationException("This object type " + valuesToBeConverted.getClass() + " is not supported in this method");
                                }
                                data = (byte[])valuesToBeConverted;
                                if (pageType != DataTypes.BYTE) break block16;
                                for (int i = 0; i < size; ++i) {
                                    if (nullBitSet.get(i)) {
                                        vector.putNull(i);
                                        continue;
                                    }
                                    BigDecimal value = BigDecimal.valueOf(data[i], this.scale);
                                    if (value.scale() < newMeasureScale) {
                                        value = value.setScale(newMeasureScale);
                                    }
                                    vector.putDecimal(i, value, precision);
                                }
                                break block17;
                            }
                            if (pageType != DataTypes.SHORT) break block18;
                            for (int i = 0; i < size; ++i) {
                                if (nullBitSet.get(i)) {
                                    vector.putNull(i);
                                    continue;
                                }
                                BigDecimal value = BigDecimal.valueOf(ByteUtil.toShortLittleEndian(data, i * DataTypes.SHORT.getSizeInBytes()), this.scale);
                                if (value.scale() < newMeasureScale) {
                                    value = value.setScale(newMeasureScale);
                                }
                                vector.putDecimal(i, value, precision);
                            }
                            break block17;
                        }
                        if (pageType != DataTypes.SHORT_INT) break block19;
                        for (int i = 0; i < size; ++i) {
                            if (nullBitSet.get(i)) {
                                vector.putNull(i);
                                continue;
                            }
                            BigDecimal value = BigDecimal.valueOf(ByteUtil.valueOf3Bytes(data, i * DataTypes.SHORT_INT.getSizeInBytes()), this.scale);
                            if (value.scale() < newMeasureScale) {
                                value = value.setScale(newMeasureScale);
                            }
                            vector.putDecimal(i, value, precision);
                        }
                        break block17;
                    }
                    if (pageType != DataTypes.INT) break block20;
                    for (int i = 0; i < size; ++i) {
                        if (nullBitSet.get(i)) {
                            vector.putNull(i);
                            continue;
                        }
                        BigDecimal value = BigDecimal.valueOf(ByteUtil.toIntLittleEndian(data, i * DataTypes.INT.getSizeInBytes()), this.scale);
                        if (value.scale() < newMeasureScale) {
                            value = value.setScale(newMeasureScale);
                        }
                        vector.putDecimal(i, value, precision);
                    }
                    break block17;
                }
                if (pageType != DataTypes.LONG) break block17;
                for (int i = 0; i < size; ++i) {
                    if (nullBitSet.get(i)) {
                        vector.putNull(i);
                        continue;
                    }
                    BigDecimal value = BigDecimal.valueOf(ByteUtil.toLongLittleEndian(data, i * DataTypes.LONG.getSizeInBytes()), this.scale);
                    if (value.scale() < newMeasureScale) {
                        value = value.setScale(newMeasureScale);
                    }
                    vector.putDecimal(i, value, precision);
                }
            }
        }

        @Override
        public int getSize() {
            return 4;
        }

        @Override
        public DecimalConverterType getDecimalConverterType() {
            return DecimalConverterType.DECIMAL_INT;
        }
    }

    public static interface DecimalConverter {
        public Object convert(BigDecimal var1);

        public BigDecimal getDecimal(Object var1);

        public void fillVector(Object var1, int var2, ColumnVectorInfo var3, BitSet var4, DataType var5);

        public int getSize();

        public DecimalConverterType getDecimalConverterType();
    }

    public static enum DecimalConverterType {
        DECIMAL_LV(-1),
        DECIMAL_INT(4),
        DECIMAL_LONG(8),
        DECIMAL_UNSCALED(-1);

        private int sizeInBytes;

        private DecimalConverterType(int sizeInBytes) {
            this.sizeInBytes = sizeInBytes;
        }

        public int getSizeInBytes() {
            return this.sizeInBytes;
        }
    }
}

