/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.metadata.datatype;

import org.apache.carbondata.core.metadata.datatype.DataType;

public class MapType
extends DataType {
    private DataType keyType;
    private DataType valueType;

    MapType(DataType keyType, DataType valueType) {
        super(13, 11, "MAP", -1);
        this.keyType = keyType;
        this.valueType = valueType;
    }

    @Override
    public boolean isComplexType() {
        return true;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MapType other = (MapType)obj;
        if (!this.getName().equalsIgnoreCase(other.getName())) {
            return false;
        }
        if (!this.keyType.equals(other.keyType)) {
            return false;
        }
        return this.valueType.equals(other.valueType);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.getName().hashCode();
        result = 31 * result + this.keyType.hashCode();
        result = 31 * result + this.valueType.hashCode();
        return result;
    }

    public DataType getKeyType() {
        return this.keyType;
    }

    public DataType getValueType() {
        return this.valueType;
    }
}

