/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.metadata.datatype;

import java.io.Serializable;
import java.util.List;
import org.apache.carbondata.core.metadata.datatype.DataType;

public class StructField
implements Serializable {
    private static final long serialVersionUID = 3271726L;
    private String fieldName;
    private DataType dataType;
    private List<StructField> children;

    public StructField(String fieldName, DataType dataType) {
        this.fieldName = fieldName;
        this.dataType = dataType;
        this.children = null;
    }

    public StructField(String fieldName, DataType dataType, List<StructField> children) {
        this.fieldName = fieldName;
        this.dataType = dataType;
        this.children = children;
    }

    public DataType getDataType() {
        return this.dataType;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public List<StructField> getChildren() {
        return this.children;
    }

    public void setFieldName(String fieldName) {
        this.fieldName = fieldName;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.fieldName.hashCode();
        result = 31 * result + this.dataType.hashCode();
        result = 31 * result + (this.children == null ? 0 : this.children.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StructField other = (StructField)obj;
        if (!this.fieldName.equalsIgnoreCase(other.fieldName)) {
            return false;
        }
        if (!this.dataType.equals(other.dataType)) {
            return false;
        }
        if (this.children == null) {
            if (other.children != null) {
                return false;
            }
        } else {
            if (other.children == null) {
                return false;
            }
            if (!this.children.equals(other.children)) {
                return false;
            }
        }
        return true;
    }
}

