/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.metadata.encoder;

import java.util.List;

public enum Encoding {
    DICTIONARY,
    DELTA,
    RLE,
    INVERTED_INDEX,
    BIT_PACKED,
    DIRECT_DICTIONARY,
    IMPLICIT,
    DIRECT_COMPRESS,
    ADAPTIVE_INTEGRAL,
    ADAPTIVE_DELTA_INTEGRAL,
    RLE_INTEGRAL,
    DIRECT_STRING,
    ADAPTIVE_FLOATING,
    BOOL_BYTE,
    ADAPTIVE_DELTA_FLOATING,
    DIRECT_COMPRESS_VARCHAR,
    INT_LENGTH_COMPLEX_CHILD_BYTE_ARRAY;


    public static Encoding valueOf(int ordinal) {
        if (ordinal == DICTIONARY.ordinal()) {
            return DICTIONARY;
        }
        if (ordinal == DELTA.ordinal()) {
            return DELTA;
        }
        if (ordinal == RLE.ordinal()) {
            return RLE;
        }
        if (ordinal == INVERTED_INDEX.ordinal()) {
            return INVERTED_INDEX;
        }
        if (ordinal == BIT_PACKED.ordinal()) {
            return BIT_PACKED;
        }
        if (ordinal == DIRECT_DICTIONARY.ordinal()) {
            return DIRECT_DICTIONARY;
        }
        if (ordinal == IMPLICIT.ordinal()) {
            return IMPLICIT;
        }
        if (ordinal == DIRECT_COMPRESS.ordinal()) {
            return DIRECT_COMPRESS;
        }
        if (ordinal == ADAPTIVE_INTEGRAL.ordinal()) {
            return ADAPTIVE_INTEGRAL;
        }
        if (ordinal == ADAPTIVE_DELTA_INTEGRAL.ordinal()) {
            return ADAPTIVE_DELTA_INTEGRAL;
        }
        if (ordinal == RLE_INTEGRAL.ordinal()) {
            return RLE_INTEGRAL;
        }
        if (ordinal == DIRECT_STRING.ordinal()) {
            return DIRECT_STRING;
        }
        if (ordinal == ADAPTIVE_FLOATING.ordinal()) {
            return ADAPTIVE_FLOATING;
        }
        if (ordinal == BOOL_BYTE.ordinal()) {
            return BOOL_BYTE;
        }
        if (ordinal == ADAPTIVE_DELTA_FLOATING.ordinal()) {
            return ADAPTIVE_DELTA_FLOATING;
        }
        if (ordinal == DIRECT_COMPRESS_VARCHAR.ordinal()) {
            return DIRECT_COMPRESS_VARCHAR;
        }
        if (ordinal == INT_LENGTH_COMPLEX_CHILD_BYTE_ARRAY.ordinal()) {
            return INT_LENGTH_COMPLEX_CHILD_BYTE_ARRAY;
        }
        throw new RuntimeException("create Encoding with invalid ordinal: " + ordinal);
    }

    public static void validateEncodingTypes(List<org.apache.carbondata.format.Encoding> encodings) {
        if (null != encodings && !encodings.isEmpty()) {
            for (org.apache.carbondata.format.Encoding encoder : encodings) {
                if (null == encoder) {
                    throw new UnsupportedOperationException("There is mismatch between the encodings in data file and the encodings supported for read in the current version");
                }
                try {
                    Encoding.valueOf(encoder.name());
                }
                catch (IllegalArgumentException ex) {
                    throw new UnsupportedOperationException("There is mismatch between the encodings in data file and the encodings supported for read in the current version. Encoding: " + encoder.name());
                }
            }
        }
    }
}

