/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.metadata.index;

public enum IndexType {
    LUCENE("org.apache.carbondata.index.lucene.LuceneFineGrainIndexFactory", "lucene"),
    BLOOMFILTER("org.apache.carbondata.index.bloom.BloomCoarseGrainIndexFactory", "bloomfilter"),
    SI("", "si");

    private String className;
    private String shortName;

    private IndexType(String className, String shortName) {
        this.className = className;
        this.shortName = shortName;
    }

    public String getIndexProviderName() {
        return this.shortName;
    }

    public String getClassName() {
        return this.className;
    }

    private boolean isEqual(String indexClass) {
        return indexClass != null && (indexClass.equals(this.className) || indexClass.equalsIgnoreCase(this.shortName));
    }

    public static IndexType get(String indexProviderName) {
        if (LUCENE.isEqual(indexProviderName)) {
            return LUCENE;
        }
        if (BLOOMFILTER.isEqual(indexProviderName)) {
            return BLOOMFILTER;
        }
        throw new UnsupportedOperationException("Unknown index provider" + indexProviderName);
    }
}

