/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.metadata.schema;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.carbondata.common.annotations.InterfaceAudience;
import org.apache.carbondata.core.metadata.schema.ColumnRangeInfo;
import org.apache.carbondata.core.metadata.schema.table.Writable;
import org.apache.carbondata.core.metadata.schema.table.column.ColumnSchema;

@InterfaceAudience.Internal
public class BucketingInfo
implements ColumnRangeInfo,
Serializable,
Writable {
    private static final long serialVersionUID = 0L;
    private List<ColumnSchema> listOfColumns;
    private int numOfRanges;

    public BucketingInfo() {
    }

    public BucketingInfo(List<ColumnSchema> listOfColumns, int numberOfRanges) {
        this.listOfColumns = listOfColumns;
        this.numOfRanges = numberOfRanges;
    }

    public List<ColumnSchema> getListOfColumns() {
        return this.listOfColumns;
    }

    @Override
    public int getNumOfRanges() {
        return this.numOfRanges;
    }

    @Override
    public void write(DataOutput output) throws IOException {
        output.writeInt(this.numOfRanges);
        output.writeInt(this.listOfColumns.size());
        for (ColumnSchema aColSchema : this.listOfColumns) {
            aColSchema.write(output);
        }
    }

    @Override
    public void readFields(DataInput input) throws IOException {
        this.numOfRanges = input.readInt();
        int colSchemaSize = input.readInt();
        this.listOfColumns = new ArrayList<ColumnSchema>(colSchemaSize);
        for (int i = 0; i < colSchemaSize; ++i) {
            ColumnSchema aSchema = new ColumnSchema();
            aSchema.readFields(input);
            this.listOfColumns.add(aSchema);
        }
    }
}

