/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.metadata.schema;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.carbondata.core.metadata.schema.partition.PartitionType;
import org.apache.carbondata.core.metadata.schema.table.Writable;
import org.apache.carbondata.core.metadata.schema.table.column.ColumnSchema;

public class PartitionInfo
implements Serializable,
Writable {
    private static final long serialVersionUID = 0L;
    private List<ColumnSchema> columnSchemaList;
    private PartitionType partitionType;
    @Deprecated
    private List<String> rangeInfo;
    @Deprecated
    private List<List<String>> listInfo;
    @Deprecated
    private int numPartitions;
    @Deprecated
    private int maxPartitionId;
    @Deprecated
    private List<Integer> partitionIds;

    public PartitionInfo() {
    }

    public PartitionInfo(List<ColumnSchema> columnSchemaList, PartitionType partitionType) {
        this.columnSchemaList = columnSchemaList;
        this.partitionType = partitionType;
        this.partitionIds = new ArrayList<Integer>();
    }

    public List<ColumnSchema> getColumnSchemaList() {
        return this.columnSchemaList;
    }

    public void setColumnSchemaList(List<ColumnSchema> columnSchemaList) {
        this.columnSchemaList = columnSchemaList;
    }

    public PartitionType getPartitionType() {
        return this.partitionType;
    }

    @Override
    public void write(DataOutput output) throws IOException {
        output.writeInt(this.columnSchemaList.size());
        for (ColumnSchema columnSchema : this.columnSchemaList) {
            columnSchema.write(output);
        }
        output.writeInt(this.partitionType.ordinal());
        if (PartitionType.RANGE.equals((Object)this.partitionType)) {
            output.writeInt(this.rangeInfo.size());
            for (String string : this.rangeInfo) {
                output.writeUTF(string);
            }
        }
        output.writeInt(this.partitionIds.size());
        for (Integer n : this.partitionIds) {
            output.writeInt(n);
        }
        if (PartitionType.LIST.equals((Object)this.partitionType)) {
            output.writeInt(this.listInfo.size());
            for (List list : this.listInfo) {
                output.writeInt(list.size());
                for (String value : list) {
                    output.writeUTF(value);
                }
            }
        }
        output.writeInt(this.numPartitions);
        output.writeInt(this.maxPartitionId);
    }

    @Override
    public void readFields(DataInput input) throws IOException {
        int colSchemaSize = input.readInt();
        this.columnSchemaList = new ArrayList<ColumnSchema>(colSchemaSize);
        for (int i = 0; i < colSchemaSize; ++i) {
            ColumnSchema colSchema = new ColumnSchema();
            colSchema.readFields(input);
            this.columnSchemaList.add(colSchema);
        }
        this.partitionType = PartitionType.values()[input.readInt()];
        if (PartitionType.RANGE.equals((Object)this.partitionType)) {
            int rangeSize = input.readInt();
            this.rangeInfo = new ArrayList<String>(rangeSize);
            for (int i = 0; i < rangeSize; ++i) {
                this.rangeInfo.add(input.readUTF());
            }
        }
        int partitionIdSize = input.readInt();
        this.partitionIds = new ArrayList<Integer>(partitionIdSize);
        for (int i = 0; i < partitionIdSize; ++i) {
            this.partitionIds.add(input.readInt());
        }
        if (PartitionType.LIST.equals((Object)this.partitionType)) {
            int listInfoSize = input.readInt();
            this.listInfo = new ArrayList<List<String>>(listInfoSize);
            for (int i = 0; i < listInfoSize; ++i) {
                int aListSize = input.readInt();
                ArrayList<String> aList = new ArrayList<String>(aListSize);
                for (int j = 0; j < aListSize; ++j) {
                    aList.add(input.readUTF());
                }
                this.listInfo.add(aList);
            }
        }
        this.numPartitions = input.readInt();
        this.maxPartitionId = input.readInt();
    }
}

