/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.metadata.schema;

import java.io.IOException;
import org.apache.carbondata.core.datastore.impl.FileFactory;
import org.apache.carbondata.core.metadata.AbsoluteTableIdentifier;
import org.apache.carbondata.core.metadata.CarbonMetadata;
import org.apache.carbondata.core.metadata.CarbonTableIdentifier;
import org.apache.carbondata.core.metadata.converter.ThriftWrapperSchemaConverterImpl;
import org.apache.carbondata.core.metadata.schema.table.CarbonTable;
import org.apache.carbondata.core.metadata.schema.table.TableInfo;
import org.apache.carbondata.core.util.CarbonUtil;
import org.apache.carbondata.core.util.path.CarbonTablePath;
import org.apache.hadoop.conf.Configuration;

public class SchemaReader {
    public static CarbonTable readCarbonTableFromStore(AbsoluteTableIdentifier identifier) throws IOException {
        String schemaFilePath = CarbonTablePath.getSchemaFilePath(identifier.getTablePath());
        if (FileFactory.isFileExist(schemaFilePath)) {
            String tableName = identifier.getCarbonTableIdentifier().getTableName();
            org.apache.carbondata.format.TableInfo tableInfo = CarbonUtil.readSchemaFile(CarbonTablePath.getSchemaFilePath(identifier.getTablePath()));
            ThriftWrapperSchemaConverterImpl schemaConverter = new ThriftWrapperSchemaConverterImpl();
            TableInfo wrapperTableInfo = schemaConverter.fromExternalToWrapperTableInfo(tableInfo, identifier.getCarbonTableIdentifier().getDatabaseName(), tableName, identifier.getTablePath());
            CarbonMetadata.getInstance().loadTableMetadata(wrapperTableInfo);
            return CarbonMetadata.getInstance().getCarbonTable(identifier.getCarbonTableIdentifier().getTableUniqueName());
        }
        throw new IOException("File does not exist: " + schemaFilePath);
    }

    public static CarbonTable readCarbonTableFromSchema(String schemaFilePath, Configuration conf) throws IOException {
        TableInfo tableInfo = SchemaReader.readTableInfoFromSchema(schemaFilePath, conf);
        return CarbonTable.buildFromTableInfo(tableInfo);
    }

    private static TableInfo readTableInfoFromSchema(String schemaFilePath, Configuration conf) throws IOException {
        if (FileFactory.isFileExist(schemaFilePath)) {
            String tableName = "dummy";
            org.apache.carbondata.format.TableInfo tableInfo = CarbonUtil.readSchemaFile(schemaFilePath);
            ThriftWrapperSchemaConverterImpl schemaConverter = new ThriftWrapperSchemaConverterImpl();
            TableInfo wrapperTableInfo = schemaConverter.fromExternalToWrapperTableInfo(tableInfo, "dummy", tableName, "dummy");
            return wrapperTableInfo;
        }
        throw new IOException("File does not exist: " + schemaFilePath);
    }

    public static TableInfo getTableInfo(AbsoluteTableIdentifier identifier) throws IOException {
        org.apache.carbondata.format.TableInfo thriftTableInfo = CarbonUtil.readSchemaFile(CarbonTablePath.getSchemaFilePath(identifier.getTablePath()));
        ThriftWrapperSchemaConverterImpl thriftWrapperSchemaConverter = new ThriftWrapperSchemaConverterImpl();
        CarbonTableIdentifier carbonTableIdentifier = identifier.getCarbonTableIdentifier();
        return thriftWrapperSchemaConverter.fromExternalToWrapperTableInfo(thriftTableInfo, carbonTableIdentifier.getDatabaseName(), carbonTableIdentifier.getTableName(), identifier.getTablePath());
    }

    public static TableInfo inferSchema(AbsoluteTableIdentifier identifier, boolean isCarbonFileProvider, Configuration configuration) throws IOException {
        org.apache.carbondata.format.TableInfo tableInfo = CarbonUtil.inferSchema(identifier.getTablePath(), identifier.getTableName(), isCarbonFileProvider, configuration);
        ThriftWrapperSchemaConverterImpl schemaConverter = new ThriftWrapperSchemaConverterImpl();
        TableInfo wrapperTableInfo = schemaConverter.fromExternalToWrapperTableInfo(tableInfo, identifier.getDatabaseName(), identifier.getTableName(), identifier.getTablePath());
        wrapperTableInfo.setTransactionalTable(false);
        return wrapperTableInfo;
    }

    public static TableInfo inferSchema(AbsoluteTableIdentifier identifier, boolean isCarbonFileProvider) throws IOException {
        org.apache.carbondata.format.TableInfo tableInfo = CarbonUtil.inferSchema(identifier.getTablePath(), identifier.getTableName(), isCarbonFileProvider, FileFactory.getConfiguration());
        ThriftWrapperSchemaConverterImpl schemaConverter = new ThriftWrapperSchemaConverterImpl();
        TableInfo wrapperTableInfo = schemaConverter.fromExternalToWrapperTableInfo(tableInfo, identifier.getDatabaseName(), identifier.getTableName(), identifier.getTablePath());
        wrapperTableInfo.setTransactionalTable(false);
        return wrapperTableInfo;
    }
}

