/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.metadata.schema;

import java.io.Serializable;
import java.util.Arrays;
import org.apache.carbondata.common.annotations.InterfaceAudience;
import org.apache.carbondata.core.metadata.schema.ColumnRangeInfo;

@InterfaceAudience.Internal
public class SortColumnRangeInfo
implements ColumnRangeInfo,
Serializable {
    private static final long serialVersionUID = 1L;
    private int[] sortColumnIndex;
    private boolean[] isSortColumnNoDict;
    private String[] userSpecifiedRanges;
    private String separator;
    private int numOfRanges;

    public SortColumnRangeInfo(int[] sortColumnIndex, boolean[] isSortColumnNoDict, String[] userSpecifiedRanges, String separator) {
        this.sortColumnIndex = sortColumnIndex;
        this.isSortColumnNoDict = isSortColumnNoDict;
        this.userSpecifiedRanges = userSpecifiedRanges;
        this.separator = separator;
        this.numOfRanges = userSpecifiedRanges.length + 1;
    }

    public int[] getSortColumnIndex() {
        return this.sortColumnIndex;
    }

    public boolean[] getIsSortColumnNoDict() {
        return this.isSortColumnNoDict;
    }

    public String[] getUserSpecifiedRanges() {
        return this.userSpecifiedRanges;
    }

    public String getSeparator() {
        return this.separator;
    }

    @Override
    public int getNumOfRanges() {
        return this.numOfRanges;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("SortColumnRangeInfo{");
        sb.append("sortColumnIndex=").append(Arrays.toString(this.sortColumnIndex));
        sb.append(", isSortColumnNoDict=").append(Arrays.toString(this.isSortColumnNoDict));
        sb.append(", userSpecifiedRanges=").append(Arrays.toString(this.userSpecifiedRanges));
        sb.append(", separator='").append(this.separator).append('\'');
        sb.append(", numOfRanges=").append(this.numOfRanges);
        sb.append('}');
        return sb.toString();
    }
}

