/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.metadata.schema.indextable;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.carbondata.core.util.ObjectSerializationUtil;

public class IndexMetadata
implements Serializable {
    private static final long serialVersionUID = -8076464279248926823L;
    private Map<String, Map<String, Map<String, String>>> indexProviderMap;
    private String parentTableName;
    private String parentTablePath;
    private String parentTableId;
    private boolean isIndexTable;

    public IndexMetadata(boolean isIndexTable) {
        this.isIndexTable = isIndexTable;
    }

    public IndexMetadata(String parentTableName, boolean isIndexTable, String parentTablePath) {
        this(isIndexTable);
        this.parentTableName = parentTableName;
        this.parentTablePath = parentTablePath;
    }

    public IndexMetadata(Map<String, Map<String, Map<String, String>>> indexProviderMap, String parentTableName, boolean isIndexTable, String parentTablePath, String parentTableId) {
        this(parentTableName, isIndexTable, parentTablePath);
        this.indexProviderMap = indexProviderMap;
        this.parentTableId = parentTableId;
    }

    public void addIndexTableInfo(String providerName, String tableName, Map<String, String> indexProperties) {
        if (null == this.indexProviderMap) {
            this.indexProviderMap = new ConcurrentHashMap<String, Map<String, Map<String, String>>>();
        }
        if (null == this.indexProviderMap.get(providerName) || this.indexProviderMap.isEmpty()) {
            ConcurrentHashMap<String, Map<String, String>> indexMap = new ConcurrentHashMap<String, Map<String, String>>();
            indexMap.put(tableName, indexProperties);
            this.indexProviderMap.put(providerName, indexMap);
        } else {
            this.indexProviderMap.get(providerName).put(tableName, indexProperties);
        }
    }

    public void removeIndexTableInfo(String indexName) {
        if (null != this.indexProviderMap) {
            for (Map.Entry<String, Map<String, Map<String, String>>> indexProviderEntry : this.indexProviderMap.entrySet()) {
                Map<String, Map<String, String>> indexMap = indexProviderEntry.getValue();
                if (!indexMap.containsKey(indexName)) continue;
                this.indexProviderMap.get(indexProviderEntry.getKey()).remove(indexName);
            }
        }
    }

    public void updateIndexStatus(String indexProvider, String indexName, String indexStatus) {
        if (null != this.indexProviderMap) {
            this.indexProviderMap.get(indexProvider).get(indexName).put("index_status", indexStatus);
        }
    }

    public List<String> getIndexTables() {
        if (null != this.indexProviderMap) {
            ArrayList<String> indexTables = new ArrayList<String>();
            for (Map.Entry<String, Map<String, Map<String, String>>> mapEntry : this.indexProviderMap.entrySet()) {
                indexTables.addAll(mapEntry.getValue().keySet());
            }
            return indexTables;
        }
        return new ArrayList<String>();
    }

    public List<String> getIndexTables(String indexProvider) {
        if (null != this.indexProviderMap && null != this.indexProviderMap.get(indexProvider)) {
            return new ArrayList<String>(this.indexProviderMap.get(indexProvider).keySet());
        }
        return new ArrayList<String>();
    }

    public Map<String, Map<String, Map<String, String>>> getIndexesMap() {
        return this.indexProviderMap;
    }

    public String getParentTableName() {
        return this.parentTableName;
    }

    public boolean isIndexTable() {
        return this.isIndexTable;
    }

    public String getParentTablePath() {
        return this.parentTablePath;
    }

    public String getParentTableId() {
        return this.parentTableId;
    }

    public String serialize() throws IOException {
        String serializedIndexMeta = ObjectSerializationUtil.convertObjectToString(this);
        return serializedIndexMeta;
    }

    public static IndexMetadata deserialize(String serializedIndexMeta) throws IOException {
        if (null == serializedIndexMeta) {
            return null;
        }
        return (IndexMetadata)ObjectSerializationUtil.convertStringToObject(serializedIndexMeta);
    }

    public String getIndexColumns(String provider, String indexName) {
        return this.indexProviderMap.get(provider).get(indexName).get("INDEX_COLUMNS");
    }
}

