/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.metadata.schema.indextable;

import com.google.gson.Gson;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.carbondata.core.index.status.IndexStatus;

public class IndexTableInfo
implements Serializable {
    private static final long serialVersionUID = 1106104914918491724L;
    private String databaseName;
    private String tableName;
    private List<String> indexCols;
    private Map<String, String> indexProperties;

    public IndexTableInfo(String databaseName, String tableName, Map<String, String> indexProperties) {
        this.databaseName = databaseName;
        this.tableName = tableName;
        this.indexProperties = indexProperties;
        this.indexCols = Arrays.asList(indexProperties.get("INDEX_COLUMNS").split(","));
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public List<String> getIndexCols() {
        return this.indexCols;
    }

    public void setIndexCols(List<String> indexCols) {
        this.indexCols = indexCols;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IndexTableInfo)) {
            return false;
        }
        IndexTableInfo other = (IndexTableInfo)obj;
        return !(this.indexCols == null ? other.indexCols != null : !this.indexCols.equals(other.indexCols));
    }

    public static IndexTableInfo[] fromGson(String gsonData) {
        Gson gson = new Gson();
        return (IndexTableInfo[])gson.fromJson(gsonData, IndexTableInfo[].class);
    }

    public static String toGson(IndexTableInfo[] gsonData) {
        Gson gson = new Gson();
        return gson.toJson((Object)gsonData);
    }

    public int hashCode() {
        int hashCode = 0;
        for (String s : this.indexCols) {
            hashCode += s.hashCode();
        }
        return hashCode;
    }

    public static String updateIndexColumns(String oldGsonData, String columnToBeUpdated, String newColumnName) {
        IndexTableInfo[] indexTableInfos = IndexTableInfo.fromGson(oldGsonData);
        if (null == indexTableInfos) {
            indexTableInfos = new IndexTableInfo[]{};
        }
        for (int i = 0; i < indexTableInfos.length; ++i) {
            ArrayList<String> newColumnList = new ArrayList<String>();
            for (String indexColumn : indexTableInfos[i].getIndexCols()) {
                if (indexColumn.equalsIgnoreCase(columnToBeUpdated)) {
                    newColumnList.add(newColumnName);
                    continue;
                }
                newColumnList.add(indexColumn);
            }
            indexTableInfos[i].setIndexCols(newColumnList);
            Map<String, String> indexProperties = indexTableInfos[i].getIndexProperties();
            indexProperties.put("INDEX_COLUMNS", String.join((CharSequence)",", newColumnList));
            indexTableInfos[i].setIndexProperties(indexProperties);
        }
        return IndexTableInfo.toGson(indexTableInfos);
    }

    public static String enableIndex(String oldIndexIno, String indexName) {
        IndexTableInfo[] indexTableInfos;
        for (IndexTableInfo indexTableInfo : indexTableInfos = IndexTableInfo.fromGson(oldIndexIno)) {
            if (!indexTableInfo.tableName.equalsIgnoreCase(indexName)) continue;
            Map<String, String> oldindexProperties = indexTableInfo.indexProperties;
            oldindexProperties.put("index_status", IndexStatus.ENABLED.name());
            indexTableInfo.setIndexProperties(oldindexProperties);
        }
        return IndexTableInfo.toGson(indexTableInfos);
    }

    public Map<String, String> getIndexProperties() {
        return this.indexProperties;
    }

    public void setIndexProperties(Map<String, String> indexProperties) {
        this.indexProperties = indexProperties;
    }
}

