/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.metadata.schema.table;

import com.google.common.collect.Lists;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.carbondata.common.exceptions.sql.MalformedIndexCommandException;
import org.apache.carbondata.common.logging.LogServiceFactory;
import org.apache.carbondata.core.constants.SortScopeOptions;
import org.apache.carbondata.core.datastore.block.SegmentProperties;
import org.apache.carbondata.core.features.TableOperation;
import org.apache.carbondata.core.index.IndexStoreManager;
import org.apache.carbondata.core.index.TableIndex;
import org.apache.carbondata.core.index.dev.IndexFactory;
import org.apache.carbondata.core.metadata.AbsoluteTableIdentifier;
import org.apache.carbondata.core.metadata.CarbonTableIdentifier;
import org.apache.carbondata.core.metadata.DatabaseLocationProvider;
import org.apache.carbondata.core.metadata.datatype.DataTypes;
import org.apache.carbondata.core.metadata.schema.BucketingInfo;
import org.apache.carbondata.core.metadata.schema.PartitionInfo;
import org.apache.carbondata.core.metadata.schema.SchemaReader;
import org.apache.carbondata.core.metadata.schema.indextable.IndexMetadata;
import org.apache.carbondata.core.metadata.schema.indextable.IndexTableInfo;
import org.apache.carbondata.core.metadata.schema.partition.PartitionType;
import org.apache.carbondata.core.metadata.schema.table.CarbonTableBuilder;
import org.apache.carbondata.core.metadata.schema.table.TableInfo;
import org.apache.carbondata.core.metadata.schema.table.TableSchema;
import org.apache.carbondata.core.metadata.schema.table.column.CarbonColumn;
import org.apache.carbondata.core.metadata.schema.table.column.CarbonDimension;
import org.apache.carbondata.core.metadata.schema.table.column.CarbonImplicitDimension;
import org.apache.carbondata.core.metadata.schema.table.column.CarbonMeasure;
import org.apache.carbondata.core.metadata.schema.table.column.ColumnSchema;
import org.apache.carbondata.core.scan.expression.Expression;
import org.apache.carbondata.core.scan.filter.FilterExpressionProcessor;
import org.apache.carbondata.core.scan.filter.resolver.FilterResolverIntf;
import org.apache.carbondata.core.util.CarbonProperties;
import org.apache.carbondata.core.util.CarbonSessionInfo;
import org.apache.carbondata.core.util.CarbonUtil;
import org.apache.carbondata.core.util.DataTypeUtil;
import org.apache.carbondata.core.util.ThreadLocalSessionInfo;
import org.apache.carbondata.core.util.path.CarbonTablePath;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Writable;
import org.apache.log4j.Logger;

public class CarbonTable
implements Serializable,
Writable {
    private static final Logger LOGGER = LogServiceFactory.getLogService((String)CarbonTable.class.getName());
    private static final long serialVersionUID = 8696507171227156445L;
    private TableInfo tableInfo;
    private List<CarbonDimension> visibleDimensions = new LinkedList<CarbonDimension>();
    private List<CarbonDimension> allDimensions;
    private List<CarbonColumn> createOrderColumn;
    private List<CarbonDimension> implicitDimensions = new LinkedList<CarbonDimension>();
    private List<CarbonMeasure> visibleMeasures = new LinkedList<CarbonMeasure>();
    private List<CarbonMeasure> allMeasures;
    private List<CarbonDimension> columnDrift;
    @Deprecated
    private BucketingInfo bucket;
    @Deprecated
    private PartitionInfo partition;
    private int numberOfSortColumns;
    private int numberOfNoDictSortColumns;
    private int dimensionOrdinalMax;
    private boolean isLocalDictionaryEnabled;
    private int localDictionaryThreshold;
    private IndexMetadata indexMetadata;

    public CarbonTable() {
        this.createOrderColumn = new LinkedList<CarbonColumn>();
        this.columnDrift = new LinkedList<CarbonDimension>();
    }

    private static void updateTableInfo(TableInfo tableInfo) {
        for (ColumnSchema columnSchema : tableInfo.getFactTable().getListOfColumns()) {
            columnSchema.setDataType(DataTypeUtil.valueOf(columnSchema.getDataType(), columnSchema.getPrecision(), columnSchema.getScale()));
        }
        if (tableInfo.getFactTable().getBucketingInfo() != null) {
            for (ColumnSchema columnSchema : tableInfo.getFactTable().getBucketingInfo().getListOfColumns()) {
                columnSchema.setDataType(DataTypeUtil.valueOf(columnSchema.getDataType(), columnSchema.getPrecision(), columnSchema.getScale()));
            }
        }
        if (tableInfo.getFactTable().getPartitionInfo() != null) {
            for (ColumnSchema columnSchema : tableInfo.getFactTable().getPartitionInfo().getColumnSchemaList()) {
                columnSchema.setDataType(DataTypeUtil.valueOf(columnSchema.getDataType(), columnSchema.getPrecision(), columnSchema.getScale()));
            }
        }
    }

    public static CarbonTable buildTable(String tablePath, String tableName, Configuration configuration) throws IOException {
        TableInfo tableInfoInfer = CarbonUtil.buildDummyTableInfo(tablePath, tableName, "null");
        org.apache.carbondata.format.TableInfo tableInfo = CarbonUtil.inferSchema(tablePath, tableName, false, configuration);
        ArrayList<ColumnSchema> columnSchemaList = new ArrayList<ColumnSchema>();
        for (org.apache.carbondata.format.ColumnSchema thriftColumnSchema : tableInfo.getFact_table().getTable_columns()) {
            ColumnSchema columnSchema = CarbonUtil.thriftColumnSchemaToWrapperColumnSchema(thriftColumnSchema);
            if (columnSchema.getColumnReferenceId() == null) {
                columnSchema.setColumnReferenceId(columnSchema.getColumnUniqueId());
            }
            columnSchemaList.add(columnSchema);
        }
        tableInfoInfer.getFactTable().setListOfColumns(columnSchemaList);
        return CarbonTable.buildFromTableInfo(tableInfoInfer);
    }

    public static CarbonTable buildFromTablePath(String tableName, String dbName, String tablePath, String tableId) throws IOException {
        return SchemaReader.readCarbonTableFromStore(AbsoluteTableIdentifier.from(tablePath, dbName, tableName, tableId));
    }

    public static CarbonTable buildFromTableInfo(TableInfo tableInfo) {
        CarbonTable table = new CarbonTable();
        CarbonTable.updateTableByTableInfo(table, tableInfo);
        return table;
    }

    public static String buildUniqueName(String databaseName, String tableName) {
        return (DatabaseLocationProvider.get().provide(databaseName) + "_" + tableName).toLowerCase(Locale.getDefault());
    }

    public static CarbonDimension getCarbonDimension(String columnName, List<CarbonDimension> dimensions) {
        CarbonDimension carbonDimension = null;
        for (CarbonDimension dim : dimensions) {
            if (!dim.getColName().equalsIgnoreCase(columnName)) continue;
            carbonDimension = dim;
            break;
        }
        return carbonDimension;
    }

    public static FilterResolverIntf resolveFilter(Expression filterExpression, AbsoluteTableIdentifier identifier) {
        try {
            FilterExpressionProcessor filterExpressionProcessor = new FilterExpressionProcessor();
            return filterExpressionProcessor.getFilterResolver(filterExpression, identifier);
        }
        catch (Exception e) {
            throw new RuntimeException("Error while resolving filter expression", e);
        }
    }

    public static CarbonTableBuilder builder() {
        return new CarbonTableBuilder();
    }

    public static void updateTableByTableInfo(CarbonTable table, TableInfo tableInfo) {
        CarbonTable.updateTableInfo(tableInfo);
        table.tableInfo = tableInfo;
        table.setTransactionalTable(tableInfo.isTransactionalTable());
        table.fillDimensionsAndMeasuresForTables(tableInfo.getFactTable());
        table.fillCreateOrderColumn();
        if (tableInfo.getFactTable().getBucketingInfo() != null) {
            table.bucket = tableInfo.getFactTable().getBucketingInfo();
        }
        if (tableInfo.getFactTable().getPartitionInfo() != null) {
            table.partition = tableInfo.getFactTable().getPartitionInfo();
        }
        CarbonTable.setLocalDictInfo(table, tableInfo);
    }

    private static void setLocalDictInfo(CarbonTable table, TableInfo tableInfo) {
        Map<String, String> tableProperties = tableInfo.getFactTable().getTableProperties();
        String isLocalDictionaryEnabled = tableProperties.get("local_dictionary_enable");
        String localDictionaryThreshold = tableProperties.get("local_dictionary_threshold");
        if (null != isLocalDictionaryEnabled) {
            table.setLocalDictionaryEnabled(Boolean.parseBoolean(isLocalDictionaryEnabled));
            if (null != localDictionaryThreshold) {
                table.setLocalDictionaryThreshold(Integer.parseInt(localDictionaryThreshold));
            } else {
                table.setLocalDictionaryThreshold(Integer.parseInt("10000"));
            }
        } else {
            table.setLocalDictionaryEnabled(Boolean.parseBoolean("false"));
            tableProperties.put("local_dictionary_enable", "false");
        }
    }

    private void fillCreateOrderColumn() {
        ArrayList<CarbonColumn> columns = new ArrayList<CarbonColumn>();
        for (CarbonDimension dimension : this.visibleDimensions) {
            if (dimension.getColumnSchema().isSpatialColumn()) continue;
            columns.add(dimension);
        }
        columns.addAll(this.visibleMeasures);
        Collections.sort(columns, new Comparator<CarbonColumn>(){

            @Override
            public int compare(CarbonColumn o1, CarbonColumn o2) {
                return Integer.compare(o1.getSchemaOrdinal(), o2.getSchemaOrdinal());
            }
        });
        this.createOrderColumn = columns;
    }

    private void fillDimensionsAndMeasuresForTables(TableSchema tableSchema) {
        ArrayList<CarbonDimension> implicitDimensions = new ArrayList<CarbonDimension>();
        this.allDimensions = new ArrayList<CarbonDimension>();
        this.allMeasures = new ArrayList<CarbonMeasure>();
        this.implicitDimensions = implicitDimensions;
        int dimensionOrdinal = 0;
        int measureOrdinal = 0;
        int keyOrdinal = 0;
        List<ColumnSchema> listOfColumns = tableSchema.getListOfColumns();
        int complexTypeOrdinal = -1;
        for (int i = 0; i < listOfColumns.size(); ++i) {
            ColumnSchema columnSchema = listOfColumns.get(i);
            if (columnSchema.isDimensionColumn()) {
                CarbonDimension dimension;
                if (columnSchema.getNumberOfChild() > 0) {
                    ++complexTypeOrdinal;
                    CarbonDimension complexDimension = new CarbonDimension(columnSchema, dimensionOrdinal++, -1, columnSchema.getSchemaOrdinal());
                    complexDimension.initializeChildDimensionsList(columnSchema.getNumberOfChild());
                    this.allDimensions.add(complexDimension);
                    dimensionOrdinal = this.readAllComplexTypeChildrens(dimensionOrdinal, columnSchema.getNumberOfChild(), listOfColumns, complexDimension);
                    i = dimensionOrdinal - 1;
                    complexTypeOrdinal = this.assignComplexOrdinal(complexDimension, complexTypeOrdinal);
                    continue;
                }
                if (!columnSchema.isInvisible() && columnSchema.isSortColumn()) {
                    ++this.numberOfSortColumns;
                }
                if (columnSchema.getDataType() != DataTypes.DATE) {
                    dimension = new CarbonDimension(columnSchema, dimensionOrdinal++, -1, columnSchema.getSchemaOrdinal());
                    if (!columnSchema.isInvisible() && columnSchema.isSortColumn()) {
                        ++this.numberOfNoDictSortColumns;
                    }
                    this.allDimensions.add(dimension);
                    continue;
                }
                if (columnSchema.getDataType() != DataTypes.DATE) continue;
                dimension = new CarbonDimension(columnSchema, dimensionOrdinal++, keyOrdinal++, columnSchema.getSchemaOrdinal());
                this.allDimensions.add(dimension);
                continue;
            }
            this.allMeasures.add(new CarbonMeasure(columnSchema, measureOrdinal++, columnSchema.getSchemaOrdinal()));
        }
        this.fillVisibleDimensions();
        this.fillVisibleMeasures();
        this.addImplicitDimension(dimensionOrdinal, implicitDimensions);
        CarbonUtil.setLocalDictColumnsToWrapperSchema(tableSchema.getListOfColumns(), tableSchema.getTableProperties(), tableSchema.getTableProperties().get("local_dictionary_enable"));
        this.dimensionOrdinalMax = dimensionOrdinal;
    }

    private void addImplicitDimension(int dimensionOrdinal, List<CarbonDimension> dimensions) {
        dimensions.add(new CarbonImplicitDimension(dimensionOrdinal, "positionId"));
        dimensions.add(new CarbonImplicitDimension(dimensionOrdinal + 1, "tupleId"));
    }

    public List<CarbonDimension> getImplicitDimensions() {
        return this.implicitDimensions;
    }

    private int readAllComplexTypeChildrens(int dimensionOrdinal, int childCount, List<ColumnSchema> listOfColumns, CarbonDimension parentDimension) {
        for (int i = 0; i < childCount; ++i) {
            ColumnSchema columnSchema = listOfColumns.get(dimensionOrdinal);
            if (!columnSchema.isDimensionColumn()) continue;
            if (columnSchema.getNumberOfChild() > 0) {
                CarbonDimension complexDimension = new CarbonDimension(columnSchema, dimensionOrdinal++, -1, columnSchema.getSchemaOrdinal());
                complexDimension.initializeChildDimensionsList(columnSchema.getNumberOfChild());
                parentDimension.getListOfChildDimensions().add(complexDimension);
                dimensionOrdinal = this.readAllComplexTypeChildrens(dimensionOrdinal, columnSchema.getNumberOfChild(), listOfColumns, complexDimension);
                continue;
            }
            CarbonDimension carbonDimension = new CarbonDimension(columnSchema, dimensionOrdinal++, -1, columnSchema.getSchemaOrdinal());
            parentDimension.getListOfChildDimensions().add(carbonDimension);
        }
        return dimensionOrdinal;
    }

    private int assignComplexOrdinal(CarbonDimension parentDimension, int complexDimensionOrdianl) {
        for (int i = 0; i < parentDimension.getNumberOfChild(); ++i) {
            CarbonDimension dimension = parentDimension.getListOfChildDimensions().get(i);
            if (dimension.getNumberOfChild() > 0) {
                dimension.setComplexTypeOridnal(++complexDimensionOrdianl);
                complexDimensionOrdianl = this.assignComplexOrdinal(dimension, complexDimensionOrdianl);
                continue;
            }
            parentDimension.getListOfChildDimensions().get(i).setComplexTypeOridnal(++complexDimensionOrdianl);
        }
        return complexDimensionOrdianl;
    }

    public String getDatabaseName() {
        return this.tableInfo.getDatabaseName();
    }

    public String getTableName() {
        return this.tableInfo.getFactTable().getTableName();
    }

    public String getTableId() {
        return this.tableInfo.getFactTable().getTableId();
    }

    public String getTableUniqueName() {
        return this.tableInfo.getTableUniqueName();
    }

    public boolean isLocalDictionaryEnabled() {
        return this.isLocalDictionaryEnabled;
    }

    private void setLocalDictionaryEnabled(boolean localDictionaryEnabled) {
        this.isLocalDictionaryEnabled = localDictionaryEnabled;
    }

    public int getLocalDictionaryThreshold() {
        return this.localDictionaryThreshold;
    }

    private void setLocalDictionaryThreshold(int localDictionaryThreshold) {
        this.localDictionaryThreshold = localDictionaryThreshold;
    }

    public String getMetadataPath() {
        return CarbonTablePath.getMetadataPath(this.getTablePath());
    }

    public String getStagePath() {
        return CarbonTablePath.getStageDir(this.getTablePath());
    }

    public String getSegmentPath(String segmentId) {
        return CarbonTablePath.getSegmentPath(this.getTablePath(), segmentId);
    }

    public String getTablePath() {
        return this.tableInfo.getOrCreateAbsoluteTableIdentifier().getTablePath();
    }

    public long getTableLastUpdatedTime() {
        return this.tableInfo.getLastUpdatedTime();
    }

    public List<CarbonDimension> getVisibleDimensions() {
        return this.visibleDimensions;
    }

    public List<CarbonMeasure> getVisibleMeasures() {
        return this.visibleMeasures;
    }

    public List<CarbonColumn> getCreateOrderColumn() {
        return this.createOrderColumn;
    }

    public List<CarbonColumn> getStreamStorageOrderColumn() {
        List<CarbonDimension> dimensions = this.visibleDimensions;
        List<CarbonMeasure> measures = this.visibleMeasures;
        ArrayList<CarbonColumn> columnList = new ArrayList<CarbonColumn>(dimensions.size() + measures.size());
        ArrayList<CarbonColumn> complexDimensionList = new ArrayList<CarbonColumn>(dimensions.size());
        for (CarbonColumn carbonColumn : dimensions) {
            if (carbonColumn.isComplex().booleanValue()) {
                complexDimensionList.add(carbonColumn);
                continue;
            }
            columnList.add(carbonColumn);
        }
        columnList.addAll(complexDimensionList);
        for (CarbonColumn carbonColumn : measures) {
            if (carbonColumn.getColName().equals("default_dummy_measure")) continue;
            columnList.add(carbonColumn);
        }
        return columnList;
    }

    public CarbonMeasure getMeasureByName(String columnName) {
        for (CarbonMeasure measure : this.visibleMeasures) {
            if (!measure.getColName().equalsIgnoreCase(columnName)) continue;
            return measure;
        }
        return null;
    }

    public CarbonDimension getDimensionByName(String columnName) {
        CarbonDimension carbonDimension = null;
        List<CarbonDimension> dimList = this.visibleDimensions;
        String[] colSplits = columnName.split("\\.");
        StringBuffer tempColName = new StringBuffer(colSplits[0]);
        for (String colSplit : colSplits) {
            if (!tempColName.toString().equalsIgnoreCase(colSplit)) {
                tempColName = tempColName.append(".").append(colSplit);
            }
            if ((carbonDimension = CarbonTable.getCarbonDimension(tempColName.toString(), dimList)) == null || carbonDimension.getListOfChildDimensions() == null) continue;
            dimList = carbonDimension.getListOfChildDimensions();
        }
        List<CarbonDimension> implicitDimList = this.implicitDimensions;
        if (carbonDimension == null) {
            carbonDimension = CarbonTable.getCarbonDimension(columnName, implicitDimList);
        }
        if (colSplits.length > 1) {
            List<CarbonDimension> dimLists = this.visibleDimensions;
            for (CarbonDimension dims : dimLists) {
                if (!dims.getColName().equalsIgnoreCase(colSplits[0])) continue;
                carbonDimension.setComplexParentDimension(this.getDimensionBasedOnOrdinal(dimLists, dims.getOrdinal()));
                break;
            }
        }
        return carbonDimension;
    }

    private CarbonDimension getDimensionBasedOnOrdinal(List<CarbonDimension> dimList, int ordinal) {
        for (CarbonDimension dimension : dimList) {
            if (dimension.getOrdinal() != ordinal) continue;
            return dimension;
        }
        throw new RuntimeException("No Dimension Matches the ordinal value");
    }

    public CarbonColumn getColumnByName(String columnName) {
        List<CarbonColumn> columns = this.createOrderColumn;
        for (CarbonColumn col : columns) {
            if (!col.getColName().equalsIgnoreCase(columnName)) continue;
            return col;
        }
        return null;
    }

    public List<CarbonDimension> getChildren(String dimName) {
        return this.getChildren(dimName, this.visibleDimensions);
    }

    private List<CarbonDimension> getChildren(String dimName, List<CarbonDimension> dimensions) {
        for (CarbonDimension carbonDimension : dimensions) {
            List<CarbonDimension> childDims;
            if (carbonDimension.getColName().equals(dimName)) {
                return carbonDimension.getListOfChildDimensions();
            }
            if (null == carbonDimension.getListOfChildDimensions() || carbonDimension.getListOfChildDimensions().size() <= 0 || (childDims = this.getChildren(dimName, carbonDimension.getListOfChildDimensions())) == null) continue;
            return childDims;
        }
        return null;
    }

    public BucketingInfo getBucketingInfo() {
        return this.bucket;
    }

    public PartitionInfo getPartitionInfo() {
        return this.partition;
    }

    public boolean isPartitionTable() {
        return null != this.partition && this.partition.getPartitionType() != PartitionType.NATIVE_HIVE;
    }

    public boolean isHivePartitionTable() {
        PartitionInfo partitionInfo = this.partition;
        return null != partitionInfo && partitionInfo.getPartitionType() == PartitionType.NATIVE_HIVE;
    }

    public AbsoluteTableIdentifier getAbsoluteTableIdentifier() {
        return this.tableInfo.getOrCreateAbsoluteTableIdentifier();
    }

    public CarbonTableIdentifier getCarbonTableIdentifier() {
        return this.tableInfo.getOrCreateAbsoluteTableIdentifier().getCarbonTableIdentifier();
    }

    public int getBlockSizeInMB() {
        return this.tableInfo.getTableBlockSizeInMB();
    }

    public int getBlockletSizeInMB() {
        try {
            return Integer.parseInt(this.tableInfo.getFactTable().getTableProperties().get("table_blocklet_size"));
        }
        catch (NumberFormatException e) {
            return Integer.parseInt("64");
        }
    }

    public String getBucketHashMethod() {
        String configuredMethod = this.tableInfo.getFactTable().getTableProperties().get("bucket_hash_method");
        if (configuredMethod == null) {
            return "spark_hash_expression";
        }
        if ("native".equals(configuredMethod)) {
            return "native";
        }
        return "spark_hash_expression";
    }

    public CarbonColumn getPrimitiveDimensionByName(String columnName) {
        for (CarbonDimension dim : this.visibleDimensions) {
            if (dim.getNumberOfChild() != 0 || !dim.getColName().equalsIgnoreCase(columnName)) continue;
            return dim;
        }
        return null;
    }

    public List<CarbonDimension> getAllDimensions() {
        return this.allDimensions;
    }

    private void fillVisibleDimensions() {
        ArrayList<CarbonDimension> visibleDimensions = new ArrayList<CarbonDimension>(this.allDimensions.size());
        for (CarbonDimension dimension : this.allDimensions) {
            if (dimension.isInvisible()) continue;
            visibleDimensions.add(dimension);
            Map<String, String> columnProperties = dimension.getColumnProperties();
            if (columnProperties == null || columnProperties.get("column_drift") == null) continue;
            this.columnDrift.add(dimension);
        }
        this.visibleDimensions = visibleDimensions;
    }

    public List<CarbonMeasure> getAllMeasures() {
        return this.allMeasures;
    }

    public List<CarbonDimension> getColumnDrift() {
        return this.columnDrift;
    }

    public boolean hasColumnDrift() {
        return this.tableInfo.hasColumnDrift();
    }

    private void fillVisibleMeasures() {
        ArrayList<CarbonMeasure> visibleMeasures = new ArrayList<CarbonMeasure>(this.allMeasures.size());
        for (CarbonMeasure measure : this.allMeasures) {
            if (measure.isInvisible()) continue;
            visibleMeasures.add(measure);
        }
        this.visibleMeasures = visibleMeasures;
    }

    public List<String> getSortColumns() {
        ArrayList<String> sortColumnsList = new ArrayList<String>(this.allDimensions.size());
        for (CarbonDimension dim : this.visibleDimensions) {
            if (!dim.isSortColumn()) continue;
            sortColumnsList.add(dim.getColName());
        }
        return sortColumnsList;
    }

    public int getNumberOfSortColumns() {
        return this.numberOfSortColumns;
    }

    public int getNumberOfNoDictSortColumns() {
        return this.numberOfNoDictSortColumns;
    }

    public static List<CarbonDimension> getNoDictSortColumns(List<CarbonDimension> dimensions) {
        ArrayList<CarbonDimension> noDictSortColumns = new ArrayList<CarbonDimension>(dimensions.size());
        for (int i = 0; i < dimensions.size(); ++i) {
            CarbonDimension dimension = dimensions.get(i);
            if (!dimension.isSortColumn() || dimension.getDataType() == DataTypes.DATE) continue;
            noDictSortColumns.add(dimension);
        }
        return noDictSortColumns;
    }

    public CarbonColumn getRangeColumn() {
        String rangeColumn = this.tableInfo.getFactTable().getTableProperties().get("range_column");
        if (rangeColumn == null) {
            return null;
        }
        return this.getColumnByName(rangeColumn);
    }

    public TableInfo getTableInfo() {
        return this.tableInfo;
    }

    public boolean isStreamingSink() {
        String streaming = this.getTableInfo().getFactTable().getTableProperties().get("streaming");
        return streaming != null && (streaming.equalsIgnoreCase("true") || streaming.equalsIgnoreCase("sink"));
    }

    public boolean isStreamingSource() {
        String streaming = this.getTableInfo().getFactTable().getTableProperties().get("streaming");
        return streaming != null && streaming.equalsIgnoreCase("source");
    }

    public int getDimensionOrdinalMax() {
        return this.dimensionOrdinalMax;
    }

    public boolean isMV() {
        return this.tableInfo.getFactTable().getTableProperties().get("mv_related_tables") != null && !this.tableInfo.getFactTable().getTableProperties().get("mv_related_tables").isEmpty();
    }

    public boolean isExternalTable() {
        String external = this.tableInfo.getFactTable().getTableProperties().get("_external");
        return external != null && external.equalsIgnoreCase("true");
    }

    public boolean isFileLevelFormat() {
        String external = this.tableInfo.getFactTable().getTableProperties().get("_filelevelformat");
        return external != null && external.equalsIgnoreCase("true");
    }

    public long size() throws IOException {
        Long indexSize;
        Map<String, Long> dataIndexSize = CarbonUtil.calculateDataIndexSize(this, true);
        Long dataSize = dataIndexSize.get("datasize");
        if (dataSize == null) {
            dataSize = 0L;
        }
        if ((indexSize = dataIndexSize.get("indexsize")) == null) {
            indexSize = 0L;
        }
        return dataSize + indexSize;
    }

    public boolean isTransactionalTable() {
        return this.tableInfo.isTransactionalTable();
    }

    public void setTransactionalTable(boolean transactionalTable) {
        this.tableInfo.setTransactionalTable(transactionalTable);
    }

    public boolean canAllow(CarbonTable carbonTable, TableOperation operation, Object ... targets) {
        try {
            List<TableIndex> indexes = IndexStoreManager.getInstance().getAllCGAndFGIndexes(carbonTable);
            if (!indexes.isEmpty()) {
                for (TableIndex index : indexes) {
                    IndexFactory factoryClass = IndexStoreManager.getInstance().getIndexFactoryClass(carbonTable, index.getIndexSchema());
                    if (factoryClass.willBecomeStale(operation)) {
                        return false;
                    }
                    if (!factoryClass.isOperationBlocked(operation, targets)) continue;
                    return false;
                }
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
            return true;
        }
        return true;
    }

    public List<CarbonColumn> getIndexedColumns(String[] columns) throws MalformedIndexCommandException {
        ArrayList<CarbonColumn> indexColumn = new ArrayList<CarbonColumn>(columns.length);
        for (String column : columns) {
            CarbonColumn carbonColumn = this.getColumnByName(column.trim().toLowerCase());
            if (carbonColumn == null) {
                throw new MalformedIndexCommandException(String.format("column '%s' does not exist in table. Please check create index statement.", column));
            }
            if (carbonColumn.getColName().isEmpty()) {
                throw new MalformedIndexCommandException("INDEX_COLUMNS contains invalid column name");
            }
            indexColumn.add(carbonColumn);
        }
        return indexColumn;
    }

    public boolean isSupportFlatFolder() {
        boolean supportFlatFolder = Boolean.parseBoolean("false");
        Map<String, String> tblProps = this.getTableInfo().getFactTable().getTableProperties();
        if (tblProps.containsKey("flat_folder")) {
            supportFlatFolder = tblProps.get("flat_folder").equalsIgnoreCase("true");
        }
        return supportFlatFolder;
    }

    public String getFormat() {
        return this.getTableInfo().getFactTable().getTableProperties().get("format");
    }

    public List<String> getMinMaxCachedColumnsInCreateOrder() {
        ArrayList<String> cachedColsList = new ArrayList<String>();
        String cacheColumns = this.tableInfo.getFactTable().getTableProperties().get("column_meta_cache");
        if (null != cacheColumns) {
            if (!cacheColumns.isEmpty()) {
                String[] cachedCols;
                for (String column : cachedCols = cacheColumns.split(",")) {
                    CarbonColumn carbonColumn = this.getColumnByName(column);
                    if (null == carbonColumn || carbonColumn.isInvisible()) continue;
                    cachedColsList.add(carbonColumn.getColName());
                }
                return cachedColsList;
            }
            return new LinkedList<String>();
        }
        return Lists.newArrayList((Object[])new String[]{"All columns"});
    }

    public List<CarbonColumn> getMinMaxCacheColumns(SegmentProperties segmentProperties) {
        ArrayList<CarbonColumn> minMaxCachedColsList = null;
        String cacheColumns = this.tableInfo.getFactTable().getTableProperties().get("column_meta_cache");
        if (null != cacheColumns) {
            minMaxCachedColsList = new ArrayList<CarbonColumn>();
            String[] cachedCols = cacheColumns.split(",");
            ArrayList<String> measureColumns = new ArrayList<String>(cachedCols.length);
            ArrayList<CarbonDimension> complexDimensions = new ArrayList<CarbonDimension>(cacheColumns.length());
            for (String column : cachedCols) {
                CarbonDimension dimension = this.getDimensionByName(column);
                if (null != dimension) {
                    CarbonDimension dimensionFromCurrentBlock = segmentProperties.getDimensionFromCurrentBlock(dimension);
                    if (null == dimensionFromCurrentBlock) continue;
                    if (dimensionFromCurrentBlock.isComplex().booleanValue()) {
                        complexDimensions.add(dimensionFromCurrentBlock);
                        continue;
                    }
                    minMaxCachedColsList.add(dimensionFromCurrentBlock);
                    continue;
                }
                measureColumns.add(column);
            }
            minMaxCachedColsList.addAll(complexDimensions);
            for (String measureColumn : measureColumns) {
                CarbonMeasure measureFromCurrentBlock;
                CarbonMeasure measure = this.getMeasureByName(measureColumn);
                if (null == measure || null == (measureFromCurrentBlock = segmentProperties.getMeasureFromCurrentBlock(measure))) continue;
                minMaxCachedColsList.add(measureFromCurrentBlock);
            }
        }
        return minMaxCachedColsList;
    }

    public List<ColumnSchema> getInvertedIndexColumns() {
        if (this.getSortScope() == SortScopeOptions.SortScope.NO_SORT) {
            return new LinkedList<ColumnSchema>();
        }
        LinkedList<ColumnSchema> columns = new LinkedList<ColumnSchema>();
        for (ColumnSchema column : this.tableInfo.getFactTable().getListOfColumns()) {
            if (!column.isUseInvertedIndex() || !column.isSortColumn()) continue;
            columns.add(column);
        }
        return columns;
    }

    public SortScopeOptions.SortScope getSortScope() {
        String sortScope = this.tableInfo.getFactTable().getTableProperties().get("sort_scope");
        if (sortScope == null) {
            if (this.getNumberOfSortColumns() == 0) {
                return SortScopeOptions.SortScope.NO_SORT;
            }
            String sortScopeSessionProp = CarbonProperties.getInstance().getProperty("carbon.table.load.sort.scope." + this.getDatabaseName() + "." + this.getTableName());
            if (null != sortScopeSessionProp) {
                return SortScopeOptions.getSortScope(sortScopeSessionProp);
            }
            return SortScopeOptions.getSortScope(CarbonProperties.getInstance().getProperty("carbon.options.sort.scope", CarbonProperties.getInstance().getProperty("carbon.load.sort.scope", "LOCAL_SORT")));
        }
        return SortScopeOptions.getSortScope(sortScope);
    }

    public String getGlobalSortPartitions() {
        return this.tableInfo.getFactTable().getTableProperties().get("global_sort_partitions");
    }

    public void write(DataOutput out) throws IOException {
        this.tableInfo.write(out);
    }

    public void readFields(DataInput in) throws IOException {
        this.tableInfo = new TableInfo();
        this.tableInfo.readFields(in);
        CarbonTable.updateTableByTableInfo(this, this.tableInfo);
    }

    private void deserializeIndexMetadata() throws IOException {
        String indexMeta;
        if (this.indexMetadata == null && null != (indexMeta = this.tableInfo.getFactTable().getTableProperties().get(this.getTableId()))) {
            this.indexMetadata = IndexMetadata.deserialize(indexMeta);
        }
    }

    public boolean isIndexTable() throws IOException {
        this.deserializeIndexMetadata();
        return this.indexMetadata != null && this.indexMetadata.isIndexTable();
    }

    public List<String> getIndexTableNames() throws IOException {
        this.deserializeIndexMetadata();
        if (null != this.indexMetadata) {
            return this.indexMetadata.getIndexTables();
        }
        return new ArrayList<String>();
    }

    public List<String> getIndexTableNames(String indexProvider) throws IOException {
        this.deserializeIndexMetadata();
        if (null != this.indexMetadata) {
            return this.indexMetadata.getIndexTables(indexProvider);
        }
        return new ArrayList<String>();
    }

    public String getIndexInfo() throws IOException {
        return this.getIndexInfo(null);
    }

    public IndexMetadata getIndexMetadata() throws IOException {
        this.deserializeIndexMetadata();
        return this.indexMetadata;
    }

    public Map<String, Map<String, Map<String, String>>> getIndexesMap() throws IOException {
        this.deserializeIndexMetadata();
        if (null == this.indexMetadata) {
            return new HashMap<String, Map<String, Map<String, String>>>();
        }
        return this.indexMetadata.getIndexesMap();
    }

    public String getIndexInfo(String indexProvider) throws IOException {
        this.deserializeIndexMetadata();
        if (null != this.indexMetadata) {
            if (null != indexProvider) {
                if (null != this.indexMetadata.getIndexesMap().get(indexProvider)) {
                    IndexTableInfo[] indexTableInfos = new IndexTableInfo[this.indexMetadata.getIndexesMap().get(indexProvider).entrySet().size()];
                    int index = 0;
                    if (!this.isIndexTable()) {
                        for (Map.Entry<String, Map<String, String>> entry : this.indexMetadata.getIndexesMap().get(indexProvider).entrySet()) {
                            indexTableInfos[index] = new IndexTableInfo(this.getDatabaseName(), entry.getKey(), entry.getValue());
                            ++index;
                        }
                        return IndexTableInfo.toGson(indexTableInfos);
                    }
                    return IndexTableInfo.toGson(new IndexTableInfo[0]);
                }
                return IndexTableInfo.toGson(new IndexTableInfo[0]);
            }
            IndexTableInfo[] indexTableInfos = new IndexTableInfo[this.indexMetadata.getIndexTables().size()];
            int index = 0;
            if (!this.isIndexTable()) {
                for (Map.Entry<String, Map<String, Map<String, String>>> entry : this.indexMetadata.getIndexesMap().entrySet()) {
                    for (Map.Entry<String, Map<String, String>> indexEntry : entry.getValue().entrySet()) {
                        indexTableInfos[index] = new IndexTableInfo(this.getDatabaseName(), indexEntry.getKey(), indexEntry.getValue());
                        ++index;
                    }
                }
                return IndexTableInfo.toGson(indexTableInfos);
            }
            return IndexTableInfo.toGson(new IndexTableInfo[0]);
        }
        return null;
    }

    public String getParentTableName() {
        String parentTableName = "";
        try {
            this.deserializeIndexMetadata();
        }
        catch (IOException e) {
            LOGGER.error((Object)"Error deserializing index metadata");
        }
        if (null != this.indexMetadata && null != this.indexMetadata.getParentTableName()) {
            parentTableName = this.indexMetadata.getParentTableName();
        }
        return parentTableName;
    }

    public List<TableIndex> getAllVisibleIndexes() throws IOException {
        CarbonSessionInfo sessionInfo = ThreadLocalSessionInfo.getCarbonSessionInfo();
        List<TableIndex> allIndexes = IndexStoreManager.getInstance().getAllCGAndFGIndexes(this);
        Iterator<TableIndex> indexIterator = allIndexes.iterator();
        while (indexIterator.hasNext()) {
            TableIndex index = indexIterator.next();
            String dbName = this.getDatabaseName();
            String tableName = this.getTableName();
            String indexName = index.getIndexSchema().getIndexName();
            if (sessionInfo != null) {
                boolean isIndexVisible = sessionInfo.getSessionParams().getProperty(String.format("%s%s.%s.%s", "carbon.index.visible.", dbName, tableName, indexName), "true").trim().equalsIgnoreCase("true");
                if (isIndexVisible) continue;
                LOGGER.warn((Object)String.format("Ignore invisible index %s on table %s.%s", indexName, dbName, tableName));
                indexIterator.remove();
                continue;
            }
            String message = "Carbon session info is null";
            LOGGER.info((Object)message);
        }
        return allIndexes;
    }
}

