/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.metadata.schema.table;

import java.util.Objects;
import org.apache.carbondata.core.metadata.schema.table.CarbonTable;
import org.apache.carbondata.core.metadata.schema.table.TableInfo;
import org.apache.carbondata.core.metadata.schema.table.TableSchema;

public class CarbonTableBuilder {
    private String tableName;
    private String databaseName;
    private String tablePath;
    private boolean isTransactionalTable;
    private TableSchema tableSchema;

    public CarbonTableBuilder tableName(String tableName) {
        this.tableName = tableName;
        return this;
    }

    public CarbonTableBuilder databaseName(String databaseName) {
        this.databaseName = databaseName;
        return this;
    }

    public CarbonTableBuilder tablePath(String tablePath) {
        Objects.requireNonNull(tablePath, "tablePath should not be null");
        this.tablePath = tablePath;
        return this;
    }

    public CarbonTableBuilder isTransactionalTable(boolean isTransactionalTable) {
        Objects.requireNonNull(Boolean.valueOf(isTransactionalTable), "Transactional Table should not be null");
        this.isTransactionalTable = isTransactionalTable;
        return this;
    }

    public CarbonTableBuilder tableSchema(TableSchema tableSchema) {
        Objects.requireNonNull(tableSchema, "tableSchema should not be null");
        this.tableSchema = tableSchema;
        return this;
    }

    public CarbonTable build() {
        Objects.requireNonNull(this.tablePath, "tablePath should not be null");
        Objects.requireNonNull(this.tableSchema, "tableSchema should not be null");
        Objects.requireNonNull(Boolean.valueOf(this.isTransactionalTable), "Transactional Table should not be null");
        TableInfo tableInfo = new TableInfo();
        tableInfo.setDatabaseName(this.databaseName);
        tableInfo.setTableUniqueName(CarbonTable.buildUniqueName(this.databaseName, this.tableName));
        tableInfo.setFactTable(this.tableSchema);
        tableInfo.setTablePath(this.tablePath);
        tableInfo.setTransactionalTable(this.isTransactionalTable);
        tableInfo.setLastUpdatedTime(System.currentTimeMillis());
        return CarbonTable.buildFromTableInfo(tableInfo);
    }
}

