/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.metadata.schema.table;

import com.google.gson.annotations.SerializedName;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.carbondata.common.exceptions.sql.MalformedIndexCommandException;
import org.apache.carbondata.core.metadata.schema.table.RelationIdentifier;
import org.apache.carbondata.core.metadata.schema.table.TableSchema;
import org.apache.carbondata.core.metadata.schema.table.Writable;
import org.apache.commons.lang.StringUtils;

public class IndexSchema
implements Serializable,
Writable {
    private static final long serialVersionUID = -8394577999061329687L;
    protected String indexName;
    @SerializedName(value="providerName", alternate={"className"})
    protected String providerName;
    protected RelationIdentifier relationIdentifier;
    protected Map<String, String> properties;
    protected TableSchema childSchema;

    public IndexSchema(String indexName, String providerName) {
        this.indexName = indexName;
        this.providerName = providerName;
    }

    public IndexSchema() {
    }

    public String getIndexName() {
        return this.indexName;
    }

    public void setIndexName(String indexName) {
        this.indexName = indexName;
    }

    public String getProviderName() {
        return this.providerName;
    }

    public RelationIdentifier getRelationIdentifier() {
        return this.relationIdentifier;
    }

    public void setRelationIdentifier(RelationIdentifier relationIdentifier) {
        this.relationIdentifier = relationIdentifier;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, String> properties) {
        this.properties = properties;
    }

    public boolean isIndex() {
        return true;
    }

    public boolean isLazy() {
        String deferredRebuild = this.getProperties().get("_internal.deferred.rebuild");
        return deferredRebuild != null && deferredRebuild.equalsIgnoreCase("true");
    }

    @Override
    public void write(DataOutput out) throws IOException {
        out.writeUTF(this.indexName);
        out.writeUTF(this.providerName);
        boolean isRelationIdentifierExists = null != this.relationIdentifier;
        out.writeBoolean(isRelationIdentifierExists);
        if (isRelationIdentifierExists) {
            this.relationIdentifier.write(out);
        }
        boolean isChildSchemaExists = null != this.childSchema;
        out.writeBoolean(isChildSchemaExists);
        if (isChildSchemaExists) {
            this.childSchema.write(out);
        }
        if (this.properties == null) {
            out.writeShort(0);
        } else {
            out.writeShort(this.properties.size());
            for (Map.Entry<String, String> entry : this.properties.entrySet()) {
                out.writeUTF(entry.getKey());
                out.writeUTF(entry.getValue());
            }
        }
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        boolean isChildSchemaExists;
        this.indexName = in.readUTF();
        this.providerName = in.readUTF();
        boolean isRelationIdentifierExists = in.readBoolean();
        if (isRelationIdentifierExists) {
            this.relationIdentifier = new RelationIdentifier(null, null, null);
            this.relationIdentifier.readFields(in);
        }
        if (isChildSchemaExists = in.readBoolean()) {
            this.childSchema = new TableSchema();
            this.childSchema.readFields(in);
        }
        int mapSize = in.readShort();
        this.properties = new HashMap<String, String>(mapSize);
        for (int i = 0; i < mapSize; ++i) {
            String key = in.readUTF();
            String value = in.readUTF();
            this.properties.put(key, value);
        }
    }

    public String[] getIndexColumns() throws MalformedIndexCommandException {
        String columns = this.getProperties().get("INDEX_COLUMNS");
        if (columns == null) {
            columns = this.getProperties().get("INDEX_COLUMNS".toLowerCase());
        }
        if (columns == null) {
            throw new MalformedIndexCommandException("INDEX_COLUMNS INDEXPROPERTY is required");
        }
        if (StringUtils.isBlank((String)columns)) {
            throw new MalformedIndexCommandException("INDEX_COLUMNS INDEXPROPERTY is blank");
        }
        return columns.split(",", -1);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IndexSchema that = (IndexSchema)o;
        return Objects.equals(this.indexName, that.indexName);
    }

    public int hashCode() {
        return Objects.hash(this.indexName);
    }
}

