/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.metadata.schema.table;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import java.util.Objects;
import org.apache.carbondata.core.metadata.schema.table.Writable;

public class RelationIdentifier
implements Serializable,
Writable {
    private String databaseName;
    private String tableName;
    private String tableId;
    private String tablePath = "";
    private String provider = "carbondata";

    public RelationIdentifier(String databaseName, String tableName, String tableId) {
        this.databaseName = databaseName;
        this.tableName = tableName;
        this.tableId = tableId;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getTableId() {
        return this.tableId;
    }

    public String getTablePath() {
        return this.tablePath;
    }

    public void setTablePath(String tablePath) {
        this.tablePath = tablePath;
    }

    public String getProvider() {
        return this.provider;
    }

    public void setProvider(String provider) {
        this.provider = provider;
    }

    public boolean isCarbonDataTable() {
        return this.provider.equalsIgnoreCase("carbondata");
    }

    @Override
    public void write(DataOutput out) throws IOException {
        out.writeUTF(this.databaseName);
        out.writeUTF(this.tableName);
        out.writeUTF(this.tableId);
        out.writeUTF(this.tablePath);
        out.writeUTF(this.provider);
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        this.databaseName = in.readUTF();
        this.tableName = in.readUTF();
        this.tableId = in.readUTF();
        this.tablePath = in.readUTF();
        this.provider = in.readUTF();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RelationIdentifier that = (RelationIdentifier)o;
        if (!Objects.equals(this.databaseName, that.databaseName)) {
            return false;
        }
        if (!Objects.equals(this.tableName, that.tableName)) {
            return false;
        }
        if (!Objects.equals(this.provider, that.provider)) {
            return false;
        }
        return Objects.equals(this.tableId, that.tableId);
    }

    public int hashCode() {
        int result = this.databaseName != null ? this.databaseName.hashCode() : 0;
        result = 31 * result + (this.tableName != null ? this.tableName.hashCode() : 0);
        result = 31 * result + (this.tableId != null ? this.tableId.hashCode() : 0);
        result = 31 * result + (this.provider != null ? this.provider.hashCode() : 0);
        return result;
    }

    public String toString() {
        return this.databaseName + "." + this.tableName;
    }
}

