/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.metadata.schema.table;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.Map;
import org.apache.carbondata.common.logging.LogServiceFactory;
import org.apache.carbondata.core.metadata.AbsoluteTableIdentifier;
import org.apache.carbondata.core.metadata.CarbonTableIdentifier;
import org.apache.carbondata.core.metadata.schema.table.TableSchema;
import org.apache.carbondata.core.metadata.schema.table.Writable;
import org.apache.carbondata.core.metadata.schema.table.column.ColumnSchema;
import org.apache.log4j.Logger;

public class TableInfo
implements Serializable,
Writable {
    private static final Logger LOGGER = LogServiceFactory.getLogService((String)TableInfo.class.getName());
    private static final long serialVersionUID = -5034287968314105193L;
    private String databaseName;
    private String tableUniqueName;
    private TableSchema factTable;
    private long lastUpdatedTime;
    private String tablePath;
    private boolean isTransactionalTable = true;
    private boolean hasColumnDrift = false;
    private AbsoluteTableIdentifier identifier;
    private boolean isSchemaModified;

    public TableSchema getFactTable() {
        return this.factTable;
    }

    public void setFactTable(TableSchema factTable) {
        this.factTable = factTable;
        this.updateIsSchemaModified();
        this.updateHasColumnDrift();
    }

    private void updateIsSchemaModified() {
        if (null != this.factTable.getSchemaEvolution()) {
            this.isSchemaModified = this.factTable.getSchemaEvolution().getSchemaEvolutionEntryList().size() > 1;
        }
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public void setDatabaseName(String databaseName) {
        this.databaseName = databaseName;
    }

    public String getTableUniqueName() {
        return this.tableUniqueName;
    }

    public void setTableUniqueName(String tableUniqueName) {
        this.tableUniqueName = tableUniqueName;
    }

    public long getLastUpdatedTime() {
        return this.lastUpdatedTime;
    }

    public void setLastUpdatedTime(long lastUpdatedTime) {
        this.lastUpdatedTime = lastUpdatedTime;
    }

    public void setTablePath(String tablePath) {
        this.tablePath = tablePath;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.databaseName == null ? 0 : this.databaseName.hashCode());
        result = 31 * result + (this.tableUniqueName == null ? 0 : this.tableUniqueName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TableInfo)) {
            return false;
        }
        TableInfo other = (TableInfo)obj;
        if (null == this.databaseName || null == other.databaseName) {
            return false;
        }
        if (null == this.tableUniqueName || null == other.tableUniqueName) {
            return false;
        }
        return this.tableUniqueName.equals(other.tableUniqueName);
    }

    int getTableBlockSizeInMB() {
        String tableBlockSize = null;
        Map<String, String> tableProperties = this.getFactTable().getTableProperties();
        if (null != tableProperties) {
            tableBlockSize = tableProperties.get("table_blocksize");
        }
        if (null == tableBlockSize) {
            tableBlockSize = "1024";
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("Table block size not specified for " + this.getTableUniqueName() + ". Therefore considering the default value " + "1024" + " MB"));
            }
        }
        return Integer.parseInt(tableBlockSize);
    }

    @Override
    public void write(DataOutput out) throws IOException {
        out.writeUTF(this.databaseName);
        out.writeUTF(this.tableUniqueName);
        this.factTable.write(out);
        out.writeLong(this.lastUpdatedTime);
        out.writeUTF(this.getOrCreateAbsoluteTableIdentifier().getTablePath());
        out.writeBoolean(this.isTransactionalTable);
        out.writeBoolean(this.hasColumnDrift);
        out.writeBoolean(this.isSchemaModified);
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        this.databaseName = in.readUTF();
        this.tableUniqueName = in.readUTF();
        this.factTable = new TableSchema();
        this.factTable.readFields(in);
        this.lastUpdatedTime = in.readLong();
        this.tablePath = in.readUTF();
        this.isTransactionalTable = in.readBoolean();
        this.hasColumnDrift = in.readBoolean();
        this.isSchemaModified = in.readBoolean();
    }

    public AbsoluteTableIdentifier getOrCreateAbsoluteTableIdentifier() {
        if (this.identifier == null) {
            CarbonTableIdentifier carbontableIdentifier = new CarbonTableIdentifier(this.databaseName, this.factTable.getTableName(), this.factTable.getTableId());
            this.identifier = AbsoluteTableIdentifier.from(this.tablePath, carbontableIdentifier);
        }
        return this.identifier;
    }

    public byte[] serialize() throws IOException {
        ByteArrayOutputStream bao = new ByteArrayOutputStream();
        this.write(new DataOutputStream(bao));
        return bao.toByteArray();
    }

    public static TableInfo deserialize(byte[] bytes) throws IOException {
        TableInfo tableInfo = new TableInfo();
        DataInputStream in = new DataInputStream(new ByteArrayInputStream(bytes));
        tableInfo.readFields(in);
        return tableInfo;
    }

    public boolean isTransactionalTable() {
        return this.isTransactionalTable;
    }

    public void setTransactionalTable(boolean transactionalTable) {
        this.isTransactionalTable = transactionalTable;
    }

    public boolean isSchemaModified() {
        return this.isSchemaModified;
    }

    private void updateHasColumnDrift() {
        this.hasColumnDrift = false;
        for (ColumnSchema columnSchema : this.factTable.getListOfColumns()) {
            Map<String, String> columnProperties;
            if (!columnSchema.isDimensionColumn() || columnSchema.isInvisible() || (columnProperties = columnSchema.getColumnProperties()) == null || columnProperties.get("column_drift") == null) continue;
            this.hasColumnDrift = true;
            break;
        }
    }

    public boolean hasColumnDrift() {
        return this.hasColumnDrift;
    }

    public String getTablePath() {
        return this.tablePath;
    }
}

