/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.metadata.schema.table;

import com.google.gson.annotations.SerializedName;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.carbondata.core.metadata.schema.BucketingInfo;
import org.apache.carbondata.core.metadata.schema.PartitionInfo;
import org.apache.carbondata.core.metadata.schema.SchemaEvolution;
import org.apache.carbondata.core.metadata.schema.table.TableSchemaBuilder;
import org.apache.carbondata.core.metadata.schema.table.Writable;
import org.apache.carbondata.core.metadata.schema.table.column.ColumnSchema;

public class TableSchema
implements Serializable,
Writable,
Cloneable {
    private static final long serialVersionUID = -1928614587722507026L;
    private String tableId;
    private String tableName;
    private List<ColumnSchema> listOfColumns = new ArrayList<ColumnSchema>(16);
    @SerializedName(value="schemaEvolution", alternate={"schemaEvalution"})
    private SchemaEvolution schemaEvolution;
    private Map<String, String> tableProperties = new HashMap<String, String>();
    private BucketingInfo bucketingInfo;
    private PartitionInfo partitionInfo;

    public String getTableId() {
        return this.tableId;
    }

    public void setTableId(String tableId) {
        this.tableId = tableId;
    }

    public List<ColumnSchema> getListOfColumns() {
        return this.listOfColumns;
    }

    public void setListOfColumns(List<ColumnSchema> listOfColumns) {
        this.listOfColumns = listOfColumns;
    }

    public SchemaEvolution getSchemaEvolution() {
        return this.schemaEvolution;
    }

    public void setSchemaEvolution(SchemaEvolution schemaEvolution) {
        this.schemaEvolution = schemaEvolution;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        if (tableName != null) {
            tableName = tableName.toLowerCase(Locale.getDefault());
        }
        this.tableName = tableName;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.tableId == null ? 0 : this.tableId.hashCode());
        result = 31 * result + (this.tableName == null ? 0 : this.tableName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TableSchema other = (TableSchema)obj;
        if (this.tableId == null ? other.tableId != null : !this.tableId.equals(other.tableId)) {
            return false;
        }
        return !(this.tableName == null ? other.tableName != null : !this.tableName.equals(other.tableName));
    }

    public Map<String, String> getTableProperties() {
        return this.tableProperties;
    }

    public void setTableProperties(Map<String, String> tableProperties) {
        this.tableProperties = tableProperties;
    }

    public BucketingInfo getBucketingInfo() {
        return this.bucketingInfo;
    }

    public void setBucketingInfo(BucketingInfo bucketingInfo) {
        this.bucketingInfo = bucketingInfo;
    }

    public PartitionInfo getPartitionInfo() {
        return this.partitionInfo;
    }

    public void setPartitionInfo(PartitionInfo partitionInfo) {
        this.partitionInfo = partitionInfo;
    }

    @Override
    public void write(DataOutput out) throws IOException {
        out.writeUTF(this.tableId);
        out.writeUTF(this.tableName);
        out.writeInt(this.listOfColumns.size());
        for (ColumnSchema columnSchema : this.listOfColumns) {
            columnSchema.write(out);
        }
        out.writeInt(this.tableProperties.size());
        for (Map.Entry entry : this.tableProperties.entrySet()) {
            out.writeUTF((String)entry.getKey());
            out.writeUTF((String)entry.getValue());
        }
        if (null != this.partitionInfo) {
            out.writeBoolean(true);
            this.partitionInfo.write(out);
        } else {
            out.writeBoolean(false);
        }
        if (null != this.bucketingInfo) {
            out.writeBoolean(true);
            this.bucketingInfo.write(out);
        } else {
            out.writeBoolean(false);
        }
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        boolean bucketingExists;
        this.tableId = in.readUTF();
        this.tableName = in.readUTF();
        int listSize = in.readInt();
        this.listOfColumns = new ArrayList<ColumnSchema>(listSize);
        for (int i = 0; i < listSize; ++i) {
            ColumnSchema schema = new ColumnSchema();
            schema.readFields(in);
            this.listOfColumns.add(schema);
        }
        int propertySize = in.readInt();
        this.tableProperties = new HashMap<String, String>(propertySize);
        for (int i = 0; i < propertySize; ++i) {
            String key = in.readUTF();
            String value = in.readUTF();
            this.tableProperties.put(key, value);
        }
        boolean partitionExists = in.readBoolean();
        if (partitionExists) {
            this.partitionInfo = new PartitionInfo();
            this.partitionInfo.readFields(in);
        }
        if (bucketingExists = in.readBoolean()) {
            this.bucketingInfo = new BucketingInfo();
            this.bucketingInfo.readFields(in);
        }
    }

    public static TableSchemaBuilder builder() {
        return new TableSchemaBuilder();
    }

    public Object clone() throws CloneNotSupportedException {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(bos);
            this.write(dos);
            dos.close();
            bos.close();
            DataInputStream dis = new DataInputStream(new ByteArrayInputStream(bos.toByteArray()));
            TableSchema tableSchema = (TableSchema)super.clone();
            tableSchema.readFields(dis);
            return tableSchema;
        }
        catch (IOException e) {
            throw new RuntimeException("Error occur while cloning TableSchema", e);
        }
    }
}

