/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.metadata.schema.table;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.carbondata.core.metadata.datatype.ArrayType;
import org.apache.carbondata.core.metadata.datatype.DataType;
import org.apache.carbondata.core.metadata.datatype.DataTypes;
import org.apache.carbondata.core.metadata.datatype.DecimalType;
import org.apache.carbondata.core.metadata.datatype.StructField;
import org.apache.carbondata.core.metadata.datatype.StructType;
import org.apache.carbondata.core.metadata.encoder.Encoding;
import org.apache.carbondata.core.metadata.schema.SchemaEvolution;
import org.apache.carbondata.core.metadata.schema.SchemaEvolutionEntry;
import org.apache.carbondata.core.metadata.schema.table.TableSchema;
import org.apache.carbondata.core.metadata.schema.table.column.ColumnSchema;

public class TableSchemaBuilder {
    private int ordinal = 0;
    private List<ColumnSchema> sortColumns = new LinkedList<ColumnSchema>();
    private List<ColumnSchema> dimension = new LinkedList<ColumnSchema>();
    private List<ColumnSchema> varCharColumns = new LinkedList<ColumnSchema>();
    private List<ColumnSchema> complex = new LinkedList<ColumnSchema>();
    private List<ColumnSchema> measures = new LinkedList<ColumnSchema>();
    private int blockSize;
    private int blockletSize;
    private int pageSizeInMb;
    private String tableName;
    private boolean isLocalDictionaryEnabled;
    private String localDictionaryThreshold;

    public TableSchemaBuilder blockSize(int blockSize) {
        if (blockSize <= 0) {
            throw new IllegalArgumentException("blockSize should be greater than 0");
        }
        this.blockSize = blockSize;
        return this;
    }

    public TableSchemaBuilder blockletSize(int blockletSize) {
        if (blockletSize <= 0) {
            throw new IllegalArgumentException("blockletSize should be greater than 0");
        }
        this.blockletSize = blockletSize;
        return this;
    }

    public TableSchemaBuilder pageSizeInMb(int pageSizeInMb) {
        this.pageSizeInMb = pageSizeInMb;
        return this;
    }

    public TableSchemaBuilder localDictionaryThreshold(int localDictionaryThreshold) {
        this.localDictionaryThreshold = String.valueOf(localDictionaryThreshold);
        return this;
    }

    public TableSchemaBuilder enableLocalDictionary(boolean enableLocalDictionary) {
        this.isLocalDictionaryEnabled = enableLocalDictionary;
        return this;
    }

    public TableSchemaBuilder tableName(String tableName) {
        Objects.requireNonNull(tableName);
        this.tableName = tableName;
        return this;
    }

    public TableSchema build() {
        TableSchema schema = new TableSchema();
        schema.setTableName(this.tableName);
        schema.setTableId(UUID.randomUUID().toString());
        schema.setPartitionInfo(null);
        schema.setBucketingInfo(null);
        SchemaEvolution schemaEvol = new SchemaEvolution();
        schemaEvol.setSchemaEvolutionEntryList(new ArrayList<SchemaEvolutionEntry>());
        schema.setSchemaEvolution(schemaEvol);
        LinkedList<ColumnSchema> allColumns = new LinkedList<ColumnSchema>(this.sortColumns);
        allColumns.addAll(this.dimension);
        allColumns.addAll(this.varCharColumns);
        allColumns.addAll(this.complex);
        allColumns.addAll(this.measures);
        schema.setListOfColumns(allColumns);
        HashMap<String, String> property = new HashMap<String, String>();
        if (this.blockSize > 0) {
            property.put("table_blocksize", String.valueOf(this.blockSize));
        }
        if (this.blockletSize > 0) {
            property.put("table_blocklet_size", String.valueOf(this.blockletSize));
        }
        if (this.pageSizeInMb > 0) {
            property.put("table_page_size_inmb", String.valueOf(this.pageSizeInMb));
        }
        if (this.isLocalDictionaryEnabled) {
            property.put("local_dictionary_enable", String.valueOf(this.isLocalDictionaryEnabled));
            String localdictionaryThreshold = this.localDictionaryThreshold.equalsIgnoreCase("0") ? "10000" : this.localDictionaryThreshold;
            property.put("local_dictionary_threshold", localdictionaryThreshold);
            for (int index = 0; index < allColumns.size(); ++index) {
                ColumnSchema colSchema = (ColumnSchema)allColumns.get(index);
                if (colSchema.getDataType() != DataTypes.STRING && colSchema.getDataType() != DataTypes.VARCHAR) continue;
                colSchema.setLocalDictColumn(true);
                allColumns.set(index, colSchema);
            }
        }
        if (property.size() != 0) {
            schema.setTableProperties(property);
        }
        return schema;
    }

    public void setSortColumns(List<ColumnSchema> sortColumns) {
        this.sortColumns = sortColumns;
    }

    public ColumnSchema addColumn(StructField field, AtomicInteger valIndex, boolean isSortColumn, boolean isInvertedIdxColumn) {
        return this.addColumn(field, null, valIndex, isSortColumn, false, isInvertedIdxColumn);
    }

    private ColumnSchema addColumn(StructField field, String parentName, AtomicInteger valIndex, boolean isSortColumn, boolean isComplexChild, boolean isInvertedIdxColumn) {
        ColumnSchema newColumn;
        block25: {
            String parentFieldName;
            block27: {
                block26: {
                    Objects.requireNonNull(field);
                    if (isComplexChild) {
                        this.checkRepeatColumnName(field, parentName);
                    } else {
                        this.checkRepeatColumnName(field);
                    }
                    newColumn = new ColumnSchema();
                    if (parentName != null) {
                        newColumn.setColumnName(parentName + "." + field.getFieldName());
                    } else {
                        newColumn.setColumnName(field.getFieldName());
                    }
                    newColumn.setDataType(field.getDataType());
                    if (isSortColumn || field.getDataType() == DataTypes.STRING || field.getDataType() == DataTypes.VARCHAR || field.getDataType() == DataTypes.DATE || field.getDataType() == DataTypes.TIMESTAMP || field.getDataType() == DataTypes.BINARY || field.getDataType().isComplexType() || isComplexChild) {
                        newColumn.setDimensionColumn(true);
                    } else {
                        newColumn.setDimensionColumn(false);
                    }
                    if (!isComplexChild) {
                        newColumn.setSchemaOrdinal(this.ordinal++);
                    } else {
                        newColumn.setSchemaOrdinal(-1);
                    }
                    newColumn.setColumnUniqueId(field.getFieldName());
                    newColumn.setColumnReferenceId(newColumn.getColumnUniqueId());
                    newColumn.setEncodingList(this.createEncoding(field.getDataType(), isInvertedIdxColumn, isComplexChild));
                    if (field.getDataType().isComplexType()) {
                        if (DataTypes.isArrayType(field.getDataType()) || DataTypes.isMapType(field.getDataType())) {
                            newColumn.setNumberOfChild(1);
                        } else {
                            newColumn.setNumberOfChild(((StructType)field.getDataType()).getFields().size());
                        }
                    }
                    if (DataTypes.isDecimal(field.getDataType())) {
                        DecimalType decimalType = (DecimalType)field.getDataType();
                        newColumn.setPrecision(decimalType.getPrecision());
                        newColumn.setScale(decimalType.getScale());
                    }
                    if (!isSortColumn) {
                        if (!newColumn.isDimensionColumn()) {
                            this.measures.add(newColumn);
                        } else if (DataTypes.isStructType(field.getDataType()) || DataTypes.isArrayType(field.getDataType()) || DataTypes.isMapType(field.getDataType()) || isComplexChild) {
                            this.complex.add(newColumn);
                        } else if (field.getDataType() == DataTypes.VARCHAR) {
                            this.varCharColumns.add(newColumn);
                        } else {
                            this.dimension.add(newColumn);
                        }
                    } else {
                        newColumn.setSortColumn(true);
                        this.sortColumns.add(newColumn);
                    }
                    if (!field.getDataType().isComplexType()) break block25;
                    parentFieldName = newColumn.getColumnName();
                    if (!DataTypes.isArrayType(field.getDataType())) break block26;
                    for (StructField structField : field.getChildren()) {
                        String colName = this.getColNameForArray(valIndex);
                        if (null != ((ArrayType)field.getDataType()).getElementName()) {
                            colName = ((ArrayType)field.getDataType()).getElementName();
                        }
                        structField.setFieldName(colName);
                        this.addColumn(structField, parentFieldName, valIndex, false, true, isInvertedIdxColumn);
                    }
                    break block25;
                }
                if (!DataTypes.isStructType(field.getDataType()) || ((StructType)field.getDataType()).getFields().size() <= 0) break block27;
                if (field.getChildren() == null) break block25;
                for (StructField structField : field.getChildren()) {
                    this.addColumn(structField, parentFieldName, valIndex, false, true, isInvertedIdxColumn);
                }
                break block25;
            }
            if (DataTypes.isMapType(field.getDataType())) {
                for (StructField structField : field.getChildren()) {
                    structField.setFieldName(this.getColNameForArray(valIndex));
                    this.addColumn(structField, parentFieldName, valIndex, false, true, isInvertedIdxColumn);
                }
            }
        }
        return newColumn;
    }

    private String getColNameForArray(AtomicInteger valIndex) {
        String colName = "val" + valIndex.get();
        valIndex.incrementAndGet();
        return colName;
    }

    private void checkRepeatColumnName(StructField field, String parentName) {
        this.checkRepeatColumnName(new StructField(parentName + "." + field.getFieldName(), field.getDataType(), field.getChildren()));
    }

    private void checkRepeatColumnName(StructField field) {
        for (ColumnSchema column : this.sortColumns) {
            if (!column.getColumnName().equalsIgnoreCase(field.getFieldName())) continue;
            throw new IllegalArgumentException("column name already exists");
        }
        for (ColumnSchema column : this.dimension) {
            if (!column.getColumnName().equalsIgnoreCase(field.getFieldName())) continue;
            throw new IllegalArgumentException("column name already exists");
        }
        for (ColumnSchema column : this.complex) {
            if (!column.getColumnName().equalsIgnoreCase(field.getFieldName())) continue;
            throw new IllegalArgumentException("column name already exists");
        }
        for (ColumnSchema column : this.measures) {
            if (!column.getColumnName().equalsIgnoreCase(field.getFieldName())) continue;
            throw new IllegalArgumentException("column name already exists");
        }
    }

    private List<Encoding> createEncoding(DataType dataType, boolean isInvertedIdxColumn, boolean isComplexChild) {
        LinkedList<Encoding> encodings = new LinkedList<Encoding>();
        if (dataType == DataTypes.DATE && !isComplexChild) {
            encodings.add(Encoding.DIRECT_DICTIONARY);
            encodings.add(Encoding.DICTIONARY);
        }
        if (isInvertedIdxColumn) {
            encodings.add(Encoding.INVERTED_INDEX);
        }
        return encodings;
    }
}

