/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.metadata.schema.table.column;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.apache.carbondata.core.metadata.ColumnIdentifier;
import org.apache.carbondata.core.metadata.datatype.DataType;
import org.apache.carbondata.core.metadata.encoder.Encoding;
import org.apache.carbondata.core.metadata.schema.table.column.ColumnSchema;

public class CarbonColumn
implements Serializable {
    private static final long serialVersionUID = 3648269871256322681L;
    protected ColumnSchema columnSchema;
    protected int ordinal;
    private int schemaOrdinal;
    protected ColumnIdentifier columnIdentifier;
    private String dateFormat;
    private String timestampFormat;
    private boolean useActualData;

    public CarbonColumn(ColumnSchema columnSchema, int ordinal, int schemaOrdinal) {
        this.columnSchema = columnSchema;
        this.ordinal = ordinal;
        this.schemaOrdinal = schemaOrdinal;
        this.columnIdentifier = new ColumnIdentifier(this.getColumnId(), this.getColumnProperties(), this.getDataType());
    }

    public String getColumnId() {
        return this.columnSchema.getColumnUniqueId();
    }

    public DataType getDataType() {
        return this.columnSchema.getDataType();
    }

    public String getColName() {
        return this.columnSchema.getColumnName();
    }

    public int getOrdinal() {
        return this.ordinal;
    }

    public List<Encoding> getEncoder() {
        return this.columnSchema.getEncodingList();
    }

    public byte[] getDefaultValue() {
        return this.columnSchema.getDefaultValue();
    }

    public boolean hasEncoding(Encoding encoding) {
        return this.columnSchema.hasEncoding(encoding);
    }

    public Boolean isComplex() {
        return this.columnSchema.getDataType().isComplexType();
    }

    public Boolean isDimension() {
        return this.columnSchema.isDimensionColumn();
    }

    public Boolean isMeasure() {
        return this.isDimension() == false;
    }

    public boolean isInvisible() {
        return this.columnSchema.isInvisible();
    }

    public Boolean isUseInvertedIndex() {
        return this.columnSchema.isUseInvertedIndex();
    }

    public ColumnSchema getColumnSchema() {
        return this.columnSchema;
    }

    public boolean isSpatialColumn() {
        return this.columnSchema.isSpatialColumn();
    }

    public Map<String, String> getColumnProperties() {
        return this.columnSchema.getColumnProperties();
    }

    public ColumnIdentifier getColumnIdentifier() {
        return this.columnIdentifier;
    }

    public int getSchemaOrdinal() {
        return this.schemaOrdinal;
    }

    public String getDateFormat() {
        return this.dateFormat;
    }

    public void setDateFormat(String dateFormat) {
        this.dateFormat = dateFormat;
    }

    public String getTimestampFormat() {
        return this.timestampFormat;
    }

    public void setTimestampFormat(String timestampFormat) {
        this.timestampFormat = timestampFormat;
    }

    public boolean getUseActualData() {
        return this.useActualData;
    }

    public void setUseActualData(boolean useActualData) {
        this.useActualData = useActualData;
    }

    public boolean isColmatchBasedOnId(CarbonColumn queryColumn) {
        return this.getColName().equalsIgnoreCase(this.getColumnId()) && this.getColName().equalsIgnoreCase(queryColumn.getColName());
    }
}

