/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.metadata.schema.table.column;

import java.util.ArrayList;
import java.util.List;
import org.apache.carbondata.core.metadata.encoder.Encoding;
import org.apache.carbondata.core.metadata.schema.table.column.CarbonColumn;
import org.apache.carbondata.core.metadata.schema.table.column.ColumnSchema;

public class CarbonDimension
extends CarbonColumn {
    private static final long serialVersionUID = 3648269871656322681L;
    private List<CarbonDimension> listOfChildDimensions;
    private int keyOrdinal;
    private CarbonDimension complexParentDimension = null;

    public CarbonDimension(ColumnSchema columnSchema, int ordinal, int keyOrdinal) {
        this(columnSchema, ordinal, keyOrdinal, 0);
    }

    public CarbonDimension(ColumnSchema columnSchema, int ordinal, int keyOrdinal, int schemaOrdinal) {
        super(columnSchema, ordinal, schemaOrdinal);
        this.keyOrdinal = keyOrdinal;
    }

    public void initializeChildDimensionsList(int childDimension) {
        this.listOfChildDimensions = new ArrayList<CarbonDimension>(childDimension);
    }

    public int getNumberOfChild() {
        return this.columnSchema.getNumberOfChild();
    }

    public List<CarbonDimension> getListOfChildDimensions() {
        return this.listOfChildDimensions;
    }

    @Override
    public boolean hasEncoding(Encoding encoding) {
        return this.columnSchema.getEncodingList().contains((Object)encoding);
    }

    public int getKeyOrdinal() {
        return this.keyOrdinal;
    }

    public void setComplexTypeOridnal(int complexTypeOrdinal) {
    }

    public boolean isSortColumn() {
        return this.columnSchema.isSortColumn();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.columnSchema == null ? 0 : this.columnSchema.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CarbonDimension)) {
            return false;
        }
        CarbonDimension other = (CarbonDimension)obj;
        return !(this.columnSchema == null ? other.columnSchema != null : !this.columnSchema.equals(other.columnSchema));
    }

    public CarbonDimension getComplexParentDimension() {
        return this.complexParentDimension;
    }

    public void setComplexParentDimension(CarbonDimension complexParentDimension) {
        this.complexParentDimension = complexParentDimension;
    }
}

