/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.metadata.schema.table.column;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.carbondata.core.metadata.datatype.DataType;
import org.apache.carbondata.core.metadata.datatype.DataTypes;
import org.apache.carbondata.core.metadata.encoder.Encoding;
import org.apache.carbondata.core.metadata.schema.table.column.CarbonDimension;

public class CarbonImplicitDimension
extends CarbonDimension {
    private static final long serialVersionUID = 3648269871656322681L;
    private List<Encoding> encodingList = new ArrayList<Encoding>();
    private String implicitDimensionName;

    public CarbonImplicitDimension(int ordinal, String implicitDimensionName) {
        super(null, ordinal, -1, -1);
        this.encodingList.add(Encoding.IMPLICIT);
        this.implicitDimensionName = implicitDimensionName;
    }

    @Override
    public boolean hasEncoding(Encoding encoding) {
        return this.encodingList.contains((Object)encoding);
    }

    @Override
    public String getColumnId() {
        return UUID.randomUUID().toString();
    }

    @Override
    public Map<String, String> getColumnProperties() {
        return null;
    }

    @Override
    public Boolean isComplex() {
        return false;
    }

    @Override
    public List<Encoding> getEncoder() {
        return this.encodingList;
    }

    @Override
    public int getNumberOfChild() {
        return 0;
    }

    @Override
    public String getColName() {
        return this.implicitDimensionName;
    }

    @Override
    public Boolean isDimension() {
        return true;
    }

    @Override
    public DataType getDataType() {
        return DataTypes.STRING;
    }

    public boolean isColumnar() {
        return true;
    }

    @Override
    public boolean isInvisible() {
        return true;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.implicitDimensionName == null ? super.hashCode() : super.hashCode() + this.implicitDimensionName.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CarbonImplicitDimension)) {
            return false;
        }
        CarbonImplicitDimension other = (CarbonImplicitDimension)obj;
        if (this.columnSchema == null && other.columnSchema != null) {
            return false;
        }
        return this.getColName().equals(other.getColName());
    }
}

