/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.metadata.schema.table.column;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.carbondata.core.metadata.datatype.DataType;
import org.apache.carbondata.core.metadata.datatype.DataTypes;
import org.apache.carbondata.core.metadata.datatype.DecimalType;
import org.apache.carbondata.core.metadata.encoder.Encoding;
import org.apache.carbondata.core.metadata.schema.table.Writable;
import org.apache.carbondata.core.metadata.schema.table.WritableUtil;
import org.apache.carbondata.core.metadata.schema.table.column.ParentColumnTableRelation;
import org.apache.carbondata.core.preagg.TimeSeriesUDF;

public class ColumnSchema
implements Serializable,
Writable,
Cloneable {
    private static final long serialVersionUID = 7676766554874863763L;
    private DataType dataType;
    private String columnName;
    private String columnUniqueId;
    private String columnReferenceId;
    private boolean isColumnar = true;
    private List<Encoding> encodingList;
    private boolean isDimensionColumn;
    private int scale;
    private int precision;
    private int schemaOrdinal;
    private int numberOfChild;
    private byte[] defaultValue;
    private Map<String, String> columnProperties;
    private boolean invisible = false;
    private boolean isSortColumn = false;
    private boolean spatialColumn = false;
    private String aggFunction = "";
    private List<ParentColumnTableRelation> parentColumnTableRelations;
    private String timeSeriesFunction = "";
    private boolean isLocalDictColumn = false;

    public boolean isLocalDictColumn() {
        return this.isLocalDictColumn;
    }

    public void setLocalDictColumn(boolean localDictColumn) {
        this.isLocalDictColumn = localDictColumn;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public void setColumnName(String columnName) {
        this.columnName = columnName;
    }

    public String getColumnUniqueId() {
        return this.columnUniqueId;
    }

    public void setColumnUniqueId(String columnUniqueId) {
        this.columnUniqueId = columnUniqueId;
    }

    public boolean isDimensionColumn() {
        return this.isDimensionColumn;
    }

    public void setDimensionColumn(boolean isDimensionColumn) {
        this.isDimensionColumn = isDimensionColumn;
    }

    public boolean isUseInvertedIndex() {
        return this.hasEncoding(Encoding.INVERTED_INDEX);
    }

    public void setUseInvertedIndex(boolean useInvertedIndex) {
        if (useInvertedIndex) {
            if (!this.hasEncoding(Encoding.INVERTED_INDEX)) {
                this.getEncodingList().add(Encoding.INVERTED_INDEX);
            }
        } else if (this.hasEncoding(Encoding.INVERTED_INDEX)) {
            this.getEncodingList().remove((Object)Encoding.INVERTED_INDEX);
        }
    }

    public void setScale(int scale) {
        this.scale = scale;
        if (DataTypes.isDecimal(this.dataType)) {
            ((DecimalType)this.dataType).setScale(scale);
        }
    }

    public int getScale() {
        return this.scale;
    }

    public void setPrecision(int precision) {
        this.precision = precision;
        if (DataTypes.isDecimal(this.dataType)) {
            ((DecimalType)this.dataType).setPrecision(precision);
        }
    }

    public int getPrecision() {
        return this.precision;
    }

    public int getNumberOfChild() {
        return this.numberOfChild;
    }

    public void setNumberOfChild(int numberOfChild) {
        this.numberOfChild = numberOfChild;
    }

    public byte[] getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(byte[] defaultValue) {
        this.defaultValue = defaultValue;
    }

    public List<ParentColumnTableRelation> getParentColumnTableRelations() {
        return this.parentColumnTableRelations;
    }

    public void setParentColumnTableRelations(List<ParentColumnTableRelation> parentColumnTableRelations) {
        this.parentColumnTableRelations = parentColumnTableRelations;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.columnName == null ? 0 : this.columnName.hashCode()) + (this.dataType == null ? 0 : this.dataType.hashCode());
        return result;
    }

    public int strictHashCode() {
        return this.hashCode() + this.columnUniqueId.hashCode() + this.encodingList.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ColumnSchema)) {
            return false;
        }
        ColumnSchema other = (ColumnSchema)obj;
        if (this.columnName == null ? other.columnName != null : !this.columnName.equalsIgnoreCase(other.columnName)) {
            return false;
        }
        return !(this.dataType == null ? other.dataType != null : !this.dataType.equals(other.dataType));
    }

    public boolean equalsWithStrictCheck(Object obj) {
        if (!this.equals(obj)) {
            return false;
        }
        ColumnSchema other = (ColumnSchema)obj;
        if (!this.columnUniqueId.equals(other.columnUniqueId) || this.isDimensionColumn != other.isDimensionColumn || this.isSortColumn != other.isSortColumn) {
            return false;
        }
        if (this.encodingList.size() != other.encodingList.size()) {
            return false;
        }
        for (int i = 0; i < this.encodingList.size(); ++i) {
            if (this.encodingList.get(i).compareTo((Enum)other.encodingList.get(i)) == 0) continue;
            return false;
        }
        return true;
    }

    public DataType getDataType() {
        return this.dataType;
    }

    public void setDataType(DataType dataType) {
        this.dataType = dataType;
    }

    public List<Encoding> getEncodingList() {
        return this.encodingList;
    }

    public void setEncodingList(List<Encoding> encodingList) {
        this.encodingList = encodingList;
    }

    public boolean hasEncoding(Encoding encoding) {
        if (this.encodingList == null || this.encodingList.isEmpty()) {
            return false;
        }
        return this.encodingList.contains((Object)encoding);
    }

    public void setColumnProperties(Map<String, String> columnProperties) {
        this.columnProperties = columnProperties;
    }

    public Map<String, String> getColumnProperties() {
        return this.columnProperties;
    }

    public boolean isInvisible() {
        return this.invisible;
    }

    public void setInvisible(boolean invisible) {
        this.invisible = invisible;
    }

    public String getColumnReferenceId() {
        return this.columnReferenceId;
    }

    public void setColumnReferenceId(String columnReferenceId) {
        this.columnReferenceId = columnReferenceId;
    }

    public int getSchemaOrdinal() {
        return this.schemaOrdinal;
    }

    public void setSchemaOrdinal(int schemaOrdinal) {
        this.schemaOrdinal = schemaOrdinal;
    }

    public boolean isSortColumn() {
        return this.isSortColumn;
    }

    public void setSortColumn(boolean sortColumn) {
        this.isSortColumn = sortColumn;
    }

    public String getAggFunction() {
        return this.aggFunction;
    }

    public void setFunction(String function) {
        if (null == function) {
            return;
        }
        if (TimeSeriesUDF.INSTANCE.TIMESERIES_FUNCTION.contains(function.toLowerCase())) {
            this.timeSeriesFunction = function;
        } else {
            this.aggFunction = function;
        }
    }

    public String getTimeSeriesFunction() {
        return this.timeSeriesFunction;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void write(DataOutput out) throws IOException {
        out.writeShort(this.dataType.getId());
        out.writeUTF(this.columnName);
        out.writeUTF(this.columnUniqueId);
        out.writeUTF(this.columnReferenceId);
        if (this.encodingList == null) {
            out.writeShort(0);
        } else {
            out.writeShort(this.encodingList.size());
            for (Encoding encoding : this.encodingList) {
                out.writeShort(encoding.ordinal());
            }
        }
        out.writeBoolean(this.isDimensionColumn);
        if (DataTypes.isDecimal(this.dataType)) {
            out.writeInt(((DecimalType)this.dataType).getScale());
            out.writeInt(((DecimalType)this.dataType).getPrecision());
        } else {
            out.writeInt(-1);
            out.writeInt(-1);
        }
        out.writeInt(this.schemaOrdinal);
        out.writeInt(this.numberOfChild);
        WritableUtil.writeByteArray(out, this.defaultValue);
        if (this.columnProperties == null) {
            out.writeShort(0);
        } else {
            out.writeShort(this.columnProperties.size());
            for (Map.Entry entry : this.columnProperties.entrySet()) {
                out.writeUTF((String)entry.getKey());
                out.writeUTF((String)entry.getValue());
            }
        }
        out.writeBoolean(this.invisible);
        out.writeBoolean(this.isSortColumn);
        out.writeUTF(null != this.aggFunction ? this.aggFunction : "");
        out.writeUTF(this.timeSeriesFunction);
        boolean isParentTableColumnRelationExists = null != this.parentColumnTableRelations && this.parentColumnTableRelations.size() > 0;
        out.writeBoolean(isParentTableColumnRelationExists);
        if (isParentTableColumnRelationExists) {
            void var3_8;
            out.writeShort(this.parentColumnTableRelations.size());
            boolean bl = false;
            while (var3_8 < this.parentColumnTableRelations.size()) {
                this.parentColumnTableRelations.get((int)var3_8).write(out);
                ++var3_8;
            }
        }
        out.writeBoolean(this.isLocalDictColumn);
        out.writeBoolean(this.spatialColumn);
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        short id = in.readShort();
        this.dataType = DataTypes.valueOf(id);
        this.columnName = in.readUTF();
        this.columnUniqueId = in.readUTF();
        this.columnReferenceId = in.readUTF();
        int encodingListSize = in.readShort();
        this.encodingList = new ArrayList<Encoding>(encodingListSize);
        for (int i = 0; i < encodingListSize; ++i) {
            id = in.readShort();
            this.encodingList.add(Encoding.valueOf(id));
        }
        this.isDimensionColumn = in.readBoolean();
        this.scale = in.readInt();
        this.precision = in.readInt();
        if (DataTypes.isDecimal(this.dataType)) {
            DecimalType decimalType = (DecimalType)this.dataType;
            decimalType.setPrecision(this.precision);
            decimalType.setScale(this.scale);
        }
        this.schemaOrdinal = in.readInt();
        this.numberOfChild = in.readInt();
        this.defaultValue = WritableUtil.readByteArray(in);
        int mapSize = in.readShort();
        this.columnProperties = new HashMap<String, String>(mapSize);
        for (int i = 0; i < mapSize; ++i) {
            String key = in.readUTF();
            String value = in.readUTF();
            this.columnProperties.put(key, value);
        }
        this.invisible = in.readBoolean();
        this.isSortColumn = in.readBoolean();
        this.aggFunction = in.readUTF();
        this.timeSeriesFunction = in.readUTF();
        boolean isParentTableColumnRelationExists = in.readBoolean();
        if (isParentTableColumnRelationExists) {
            int parentColumnTableRelationSize = in.readShort();
            this.parentColumnTableRelations = new ArrayList<ParentColumnTableRelation>(parentColumnTableRelationSize);
            for (int i = 0; i < parentColumnTableRelationSize; ++i) {
                ParentColumnTableRelation parentColumnTableRelation = new ParentColumnTableRelation(null, null, null);
                parentColumnTableRelation.readFields(in);
                this.parentColumnTableRelations.add(parentColumnTableRelation);
            }
        }
        this.isLocalDictColumn = in.readBoolean();
        this.spatialColumn = in.readBoolean();
    }

    public boolean isComplexColumn() {
        return this.getColumnName().contains(".val") || this.getColumnName().contains(".");
    }

    /*
     * Exception decompiling
     */
    public ColumnSchema clone() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public boolean isSpatialColumn() {
        return this.spatialColumn;
    }

    public void setSpatialColumn(boolean spatialColumn) {
        this.spatialColumn = spatialColumn;
    }
}

