/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.mutate;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.carbondata.common.logging.LogServiceFactory;
import org.apache.carbondata.core.datastore.filesystem.CarbonFile;
import org.apache.carbondata.core.datastore.filesystem.CarbonFileFilter;
import org.apache.carbondata.core.datastore.impl.FileFactory;
import org.apache.carbondata.core.index.Segment;
import org.apache.carbondata.core.locks.ICarbonLock;
import org.apache.carbondata.core.metadata.AbsoluteTableIdentifier;
import org.apache.carbondata.core.metadata.SegmentFileStore;
import org.apache.carbondata.core.metadata.schema.table.CarbonTable;
import org.apache.carbondata.core.mutate.SegmentUpdateDetails;
import org.apache.carbondata.core.mutate.TupleIdEnum;
import org.apache.carbondata.core.mutate.data.BlockMappingVO;
import org.apache.carbondata.core.mutate.data.RowCountDetailsVO;
import org.apache.carbondata.core.statusmanager.LoadMetadataDetails;
import org.apache.carbondata.core.statusmanager.SegmentStatus;
import org.apache.carbondata.core.statusmanager.SegmentStatusManager;
import org.apache.carbondata.core.statusmanager.SegmentUpdateStatusManager;
import org.apache.carbondata.core.util.CarbonProperties;
import org.apache.carbondata.core.util.CarbonUtil;
import org.apache.carbondata.core.util.path.CarbonTablePath;
import org.apache.hadoop.fs.Path;
import org.apache.log4j.Logger;

public class CarbonUpdateUtil {
    private static final Logger LOGGER = LogServiceFactory.getLogService((String)CarbonUpdateUtil.class.getName());

    public static String getRequiredFieldFromTID(String Tid, int index) {
        return Tid.split("/")[index];
    }

    public static String getRequiredFieldFromTID(String Tid, TupleIdEnum tid) {
        return Tid.split("/")[tid.getTupleIdIndex()];
    }

    public static String getSegmentWithBlockFromTID(String Tid, boolean isPartitionTable) {
        if (isPartitionTable) {
            return CarbonUpdateUtil.getRequiredFieldFromTID(Tid, TupleIdEnum.SEGMENT_ID);
        }
        return CarbonUpdateUtil.getRequiredFieldFromTID(Tid, TupleIdEnum.SEGMENT_ID) + "/" + CarbonUpdateUtil.getRequiredFieldFromTID(Tid, TupleIdEnum.BLOCK_ID);
    }

    public static String getTableBlockPath(String tid, String tablePath, boolean isStandardTable) {
        String partField = CarbonUpdateUtil.getRequiredFieldFromTID(tid, TupleIdEnum.PART_ID);
        if (!isStandardTable) {
            return tablePath + "/" + partField.replace("#", "/");
        }
        String part = CarbonTablePath.addPartPrefix(partField);
        String segment = CarbonTablePath.addSegmentPrefix(CarbonUpdateUtil.getRequiredFieldFromTID(tid, TupleIdEnum.SEGMENT_ID));
        return CarbonTablePath.getFactDir(tablePath) + "/" + part + "/" + segment;
    }

    public static String getDeleteDeltaFilePath(String blockPath, String blockName, String timestamp) {
        return blockPath + "/" + blockName + "-" + timestamp + ".deletedelta";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean updateSegmentStatus(List<SegmentUpdateDetails> updateDetailsList, CarbonTable table, String updateStatusFileIdentifier, boolean isCompaction) {
        boolean status = false;
        SegmentUpdateStatusManager segmentUpdateStatusManager = new SegmentUpdateStatusManager(table);
        ICarbonLock updateLock = segmentUpdateStatusManager.getTableUpdateStatusLock();
        boolean lockStatus = false;
        try {
            lockStatus = updateLock.lockWithRetries();
            if (lockStatus) {
                SegmentUpdateDetails[] oldDetails = segmentUpdateStatusManager.getUpdateStatusDetails();
                ArrayList<SegmentUpdateDetails> oldList = new ArrayList<SegmentUpdateDetails>(Arrays.asList(oldDetails));
                for (SegmentUpdateDetails newBlockEntry : updateDetailsList) {
                    CarbonUpdateUtil.mergeSegmentUpdate(isCompaction, oldList, newBlockEntry);
                }
                segmentUpdateStatusManager.writeLoadDetailsIntoFile(oldList, updateStatusFileIdentifier);
                status = true;
            } else {
                LOGGER.error((Object)"Not able to acquire the segment update lock.");
                status = false;
            }
        }
        catch (IOException e) {
            status = false;
        }
        finally {
            if (lockStatus) {
                if (updateLock.unlock()) {
                    LOGGER.info((Object)"Unlock the segment update lock successfull.");
                } else {
                    LOGGER.error((Object)"Not able to unlock the segment update lock.");
                }
            }
        }
        return status;
    }

    public static void mergeSegmentUpdate(boolean isCompaction, List<SegmentUpdateDetails> oldList, SegmentUpdateDetails newBlockEntry) {
        int index = oldList.indexOf(newBlockEntry);
        if (index != -1) {
            SegmentUpdateDetails blockDetail = oldList.get(index);
            if (blockDetail.getDeleteDeltaStartTimestamp().isEmpty() || isCompaction) {
                blockDetail.setDeleteDeltaStartTimestamp(newBlockEntry.getDeleteDeltaStartTimestamp());
            }
            blockDetail.setDeleteDeltaEndTimestamp(newBlockEntry.getDeleteDeltaEndTimestamp());
            blockDetail.setSegmentStatus(newBlockEntry.getSegmentStatus());
            blockDetail.setDeletedRowsInBlock(newBlockEntry.getDeletedRowsInBlock());
            if (!blockDetail.getDeleteDeltaStartTimestamp().equals(blockDetail.getDeleteDeltaEndTimestamp())) {
                blockDetail.addDeltaFileStamp(blockDetail.getDeleteDeltaStartTimestamp());
                blockDetail.addDeltaFileStamp(blockDetail.getDeleteDeltaEndTimestamp());
            } else {
                blockDetail.setDeltaFileStamps(null);
            }
        } else {
            oldList.add(newBlockEntry);
        }
    }

    public static boolean updateTableMetadataStatus(Set<Segment> updatedSegmentsList, CarbonTable table, String updatedTimeStamp, boolean isTimestampUpdationRequired, List<Segment> segmentsToBeDeleted) {
        return CarbonUpdateUtil.updateTableMetadataStatus(updatedSegmentsList, table, updatedTimeStamp, isTimestampUpdationRequired, segmentsToBeDeleted, new ArrayList<Segment>(), "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean updateTableMetadataStatus(Set<Segment> updatedSegmentsList, CarbonTable table, String updatedTimeStamp, boolean isTimestampUpdationRequired, List<Segment> segmentsToBeDeleted, List<Segment> segmentFilesTobeUpdated, String uuid) {
        boolean status;
        block20: {
            status = false;
            String metaDataFilepath = table.getMetadataPath();
            AbsoluteTableIdentifier identifier = table.getAbsoluteTableIdentifier();
            String tableStatusPath = CarbonTablePath.getTableStatusFilePathWithUUID(identifier.getTablePath(), uuid);
            SegmentStatusManager segmentStatusManager = new SegmentStatusManager(identifier);
            ICarbonLock carbonLock = segmentStatusManager.getTableStatusLock();
            boolean lockStatus = false;
            try {
                lockStatus = carbonLock.lockWithRetries();
                if (lockStatus) {
                    LoadMetadataDetails[] listOfLoadFolderDetailsArray;
                    LOGGER.info((Object)("Acquired lock for table" + table.getDatabaseName() + "." + table.getTableName() + " for table status updation"));
                    for (LoadMetadataDetails loadMetadata : listOfLoadFolderDetailsArray = SegmentStatusManager.readLoadMetadata(metaDataFilepath)) {
                        if (isTimestampUpdationRequired) {
                            if (loadMetadata.getLoadName().equalsIgnoreCase("0")) {
                                loadMetadata.setUpdateStatusFileName(CarbonUpdateUtil.getUpdateStatusFileName(updatedTimeStamp));
                            }
                            if (segmentsToBeDeleted.contains(new Segment(loadMetadata.getLoadName()))) {
                                loadMetadata.setSegmentStatus(SegmentStatus.MARKED_FOR_DELETE);
                                loadMetadata.setModificationOrdeletionTimesStamp(Long.parseLong(updatedTimeStamp));
                            }
                        }
                        for (Segment segName : updatedSegmentsList) {
                            if (!loadMetadata.getLoadName().equalsIgnoreCase(segName.getSegmentNo())) continue;
                            if (isTimestampUpdationRequired) {
                                if (loadMetadata.getUpdateDeltaStartTimestamp().isEmpty()) {
                                    loadMetadata.setUpdateDeltaStartTimestamp(updatedTimeStamp);
                                }
                                loadMetadata.setUpdateDeltaEndTimestamp(updatedTimeStamp);
                            }
                            if (!segmentFilesTobeUpdated.contains(Segment.toSegment(loadMetadata.getLoadName(), null))) continue;
                            loadMetadata.setSegmentFile(loadMetadata.getLoadName() + "_" + updatedTimeStamp + ".segment");
                        }
                    }
                    try {
                        SegmentStatusManager.writeLoadDetailsIntoFile(tableStatusPath, listOfLoadFolderDetailsArray);
                    }
                    catch (IOException e) {
                        int n = 0;
                        if (lockStatus) {
                            if (carbonLock.unlock()) {
                                LOGGER.info((Object)("Table unlocked successfully after table status updation" + table.getDatabaseName() + "." + table.getTableName()));
                            } else {
                                LOGGER.error((Object)("Unable to unlock Table lock for table" + table.getDatabaseName() + "." + table.getTableName() + " during table status updation"));
                            }
                        }
                        return n != 0;
                    }
                    status = true;
                    break block20;
                }
                LOGGER.error((Object)("Not able to acquire the lock for Table status updation for table " + table.getDatabaseName() + "." + table.getTableName()));
            }
            finally {
                if (lockStatus) {
                    if (carbonLock.unlock()) {
                        LOGGER.info((Object)("Table unlocked successfully after table status updation" + table.getDatabaseName() + "." + table.getTableName()));
                    } else {
                        LOGGER.error((Object)("Unable to unlock Table lock for table" + table.getDatabaseName() + "." + table.getTableName() + " during table status updation"));
                    }
                }
            }
        }
        return status;
    }

    public static String getUpdateStatusFileName(String updatedTimeStamp) {
        return "tableupdatestatus-" + updatedTimeStamp;
    }

    public static void cleanStaleDeltaFiles(CarbonTable table, final String timeStamp) {
        AbsoluteTableIdentifier identifier = table.getAbsoluteTableIdentifier();
        String partitionDir = CarbonTablePath.getPartitionDir(identifier.getTablePath());
        CarbonFile file = FileFactory.getCarbonFile(partitionDir);
        if (!file.exists()) {
            return;
        }
        for (CarbonFile eachDir : file.listFiles()) {
            CarbonFile[] toBeDeleted = eachDir.listFiles(new CarbonFileFilter(){

                @Override
                public boolean accept(CarbonFile file) {
                    String fileName = file.getName();
                    return fileName.endsWith(timeStamp + ".carbondata") || fileName.endsWith(timeStamp + ".carbonindex") || fileName.endsWith(timeStamp + ".deletedelta");
                }
            });
            try {
                CarbonUtil.deleteFoldersAndFilesSilent(toBeDeleted);
            }
            catch (IOException e) {
                LOGGER.error((Object)("Exception in deleting the delta files." + e));
            }
            catch (InterruptedException e) {
                LOGGER.error((Object)("Exception in deleting the delta files." + e));
            }
        }
    }

    public static Long getTimeStampAsLong(String timtstamp) {
        try {
            return Long.parseLong(timtstamp);
        }
        catch (NumberFormatException nfe) {
            String errorMsg = "Invalid timestamp : " + timtstamp;
            LOGGER.error((Object)errorMsg);
            return null;
        }
    }

    public static Integer getIntegerValue(String value) throws Exception {
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException nfe) {
            LOGGER.error((Object)("Invalid row : " + value + nfe.getLocalizedMessage()));
            throw new Exception("Invalid row : " + nfe.getLocalizedMessage());
        }
    }

    public static String getBlockName(String completeBlockName) {
        return completeBlockName.substring(0, completeBlockName.lastIndexOf("-"));
    }

    public static String getSegmentId(String segmentName) {
        return segmentName.split("_")[1];
    }

    public static long getLatestTaskIdForSegment(Segment segment, String tablePath) throws IOException {
        long max = 0L;
        ArrayList<String> dataFiles = new ArrayList<String>();
        if (segment.getSegmentFileName() != null) {
            SegmentFileStore fileStore = new SegmentFileStore(tablePath, segment.getSegmentFileName());
            fileStore.readIndexFiles(FileFactory.getConfiguration());
            Map<String, List<String>> indexFilesMap = fileStore.getIndexFilesMap();
            ArrayList dataFilePaths = new ArrayList();
            for (List list : indexFilesMap.values()) {
                dataFilePaths.addAll(list);
            }
            for (String string : dataFilePaths) {
                dataFiles.add(new Path(string).getName());
            }
        } else {
            String segmentDirPath = CarbonTablePath.getSegmentPath(tablePath, segment.getSegmentNo());
            CarbonFile segmentDir = FileFactory.getCarbonFile(segmentDirPath);
            CarbonFile[] carbonDataFiles = segmentDir.listFiles(new CarbonFileFilter(){

                @Override
                public boolean accept(CarbonFile file) {
                    return file.getName().endsWith(".carbondata");
                }
            });
            for (CarbonFile carbonDataFile : carbonDataFiles) {
                dataFiles.add(carbonDataFile.getName());
            }
        }
        for (String name : dataFiles) {
            long taskNumber = Long.parseLong(CarbonTablePath.DataFileUtil.getTaskNo(name).split("_")[0]);
            if (taskNumber <= max) continue;
            max = taskNumber;
        }
        return max;
    }

    public static void cleanUpDeltaFiles(CarbonTable table, boolean forceDelete) throws IOException {
        SegmentStatusManager ssm = new SegmentStatusManager(table.getAbsoluteTableIdentifier());
        LoadMetadataDetails[] details = SegmentStatusManager.readLoadMetadata(table.getMetadataPath());
        String validUpdateStatusFile = "";
        boolean isAbortedFile = true;
        boolean isInvalidFile = false;
        ArrayList<Segment> segmentFilesToBeUpdated = new ArrayList<Segment>();
        for (LoadMetadataDetails segment : details) {
            validUpdateStatusFile = ssm.getUpdateStatusFileName(details);
            if (segment.getSegmentStatus() != SegmentStatus.SUCCESS && segment.getSegmentStatus() != SegmentStatus.LOAD_PARTIAL_SUCCESS) continue;
            if (!segment.getUpdateDeltaStartTimestamp().isEmpty()) {
                SegmentUpdateDetails[] updateDetails;
                CarbonFile[] invalidIndexFiles;
                CarbonFile[] invalidUpdateDeltaFiles;
                String segmentPath = CarbonTablePath.getSegmentPath(table.getAbsoluteTableIdentifier().getTablePath(), segment.getLoadName());
                CarbonFile segDir = FileFactory.getCarbonFile(segmentPath);
                CarbonFile[] allSegmentFiles = segDir.listFiles();
                SegmentUpdateStatusManager updateStatusManager = new SegmentUpdateStatusManager(table);
                boolean updateSegmentFile = false;
                if (CarbonUpdateUtil.deleteStaleCarbonDataFiles(segment, allSegmentFiles, updateStatusManager)) {
                    updateSegmentFile = true;
                }
                for (CarbonFile invalidFile : invalidUpdateDeltaFiles = updateStatusManager.getUpdateDeltaFilesList(segment, false, ".carbondata", true, allSegmentFiles, isInvalidFile)) {
                    CarbonUpdateUtil.compareTimestampsAndDelete(invalidFile, forceDelete, false);
                }
                for (CarbonFile invalidFile : invalidIndexFiles = updateStatusManager.getUpdateDeltaFilesList(segment, false, ".carbonindex", true, allSegmentFiles, isInvalidFile)) {
                    if (!CarbonUpdateUtil.compareTimestampsAndDelete(invalidFile, forceDelete, false)) continue;
                    updateSegmentFile = true;
                }
                for (SegmentUpdateDetails block : updateDetails = updateStatusManager.readLoadMetadata()) {
                    CarbonFile[] invalidDeleteDeltaFiles;
                    if (!block.getSegmentName().equalsIgnoreCase(segment.getLoadName())) continue;
                    for (CarbonFile invalidFile : invalidDeleteDeltaFiles = updateStatusManager.getDeleteDeltaInvalidFilesList(block, false, allSegmentFiles, isAbortedFile)) {
                        boolean doForceDelete = true;
                        CarbonUpdateUtil.compareTimestampsAndDelete(invalidFile, doForceDelete, false);
                    }
                    if (CarbonUpdateUtil.isBlockInvalid(block.getSegmentStatus())) {
                        CarbonFile[] completeListOfDeleteDeltaFiles;
                        for (CarbonFile invalidFile : completeListOfDeleteDeltaFiles = updateStatusManager.getDeleteDeltaInvalidFilesList(block, true, allSegmentFiles, isInvalidFile)) {
                            CarbonUpdateUtil.compareTimestampsAndDelete(invalidFile, forceDelete, false);
                        }
                        continue;
                    }
                    for (CarbonFile invalidFile : invalidDeleteDeltaFiles = updateStatusManager.getDeleteDeltaInvalidFilesList(block, false, allSegmentFiles, isInvalidFile)) {
                        CarbonUpdateUtil.compareTimestampsAndDelete(invalidFile, forceDelete, false);
                    }
                }
                if (updateSegmentFile) {
                    segmentFilesToBeUpdated.add(new Segment(segment.getLoadName(), segment.getSegmentFile(), null));
                }
            }
            CarbonUpdateUtil.cleanUpDataFilesAfterSmallFilesMergeForSI(table, segment);
        }
        String UUID = String.valueOf(System.currentTimeMillis());
        ArrayList<Segment> segmentFilesToBeUpdatedLatest = new ArrayList<Segment>();
        CarbonFile segmentFilesLocation = FileFactory.getCarbonFile(CarbonTablePath.getSegmentFilesLocation(table.getTablePath()));
        for (Segment segment : segmentFilesToBeUpdated) {
            CarbonFile[] invalidSegmentFiles;
            SegmentFileStore fileStore = new SegmentFileStore(table.getTablePath(), segment.getSegmentFileName());
            segment.setSegmentMetaDataInfo(fileStore.getSegmentFile().getSegmentMetaDataInfo());
            final String updatedSegmentFile = SegmentFileStore.writeSegmentFile(table, segment.getSegmentNo(), UUID, CarbonTablePath.getSegmentPath(table.getTablePath(), segment.getSegmentNo()), segment.getSegmentMetaDataInfo());
            segmentFilesToBeUpdatedLatest.add(new Segment(segment.getSegmentNo(), updatedSegmentFile));
            for (CarbonFile invalidSegmentFile : invalidSegmentFiles = segmentFilesLocation.listFiles(new CarbonFileFilter(){

                @Override
                public boolean accept(CarbonFile file) {
                    return !file.getName().equalsIgnoreCase(updatedSegmentFile);
                }
            })) {
                invalidSegmentFile.delete();
            }
        }
        if (segmentFilesToBeUpdated.size() > 0) {
            CarbonUpdateUtil.updateTableMetadataStatus(new HashSet<Segment>(segmentFilesToBeUpdated), table, UUID, false, new ArrayList<Segment>(), segmentFilesToBeUpdatedLatest, "");
        }
        if (null != validUpdateStatusFile && !validUpdateStatusFile.isEmpty()) {
            CarbonFile[] invalidUpdateStatusFiles;
            final String updateStatusTimestamp = validUpdateStatusFile.substring(validUpdateStatusFile.lastIndexOf("-") + 1);
            String tablePath = table.getAbsoluteTableIdentifier().getTablePath();
            CarbonFile metaFolder = FileFactory.getCarbonFile(CarbonTablePath.getMetadataPath(tablePath));
            for (CarbonFile invalidFile : invalidUpdateStatusFiles = metaFolder.listFiles(new CarbonFileFilter(){

                @Override
                public boolean accept(CarbonFile file) {
                    if (file.getName().startsWith("tableupdatestatus")) {
                        return !file.getName().endsWith(updateStatusTimestamp);
                    }
                    return false;
                }
            })) {
                CarbonUpdateUtil.compareTimestampsAndDelete(invalidFile, forceDelete, true);
            }
        }
    }

    private static void cleanUpDataFilesAfterSmallFilesMergeForSI(CarbonTable table, LoadMetadataDetails segment) throws IOException {
        if (table.isIndexTable()) {
            String segmentPath = CarbonTablePath.getSegmentPath(table.getAbsoluteTableIdentifier().getTablePath(), segment.getLoadName());
            CarbonFile segmentDirPath = FileFactory.getCarbonFile(segmentPath);
            CarbonFile[] allFilesOfSegment = segmentDirPath.listFiles();
            long startTimeStampFinal = segment.getLoadStartTime();
            long endTimeStampFinal = segment.getLoadEndTime();
            for (CarbonFile file : allFilesOfSegment) {
                boolean deleteFile = false;
                String fileTimestamp = CarbonTablePath.DataFileUtil.getTimeStampFromFileName(file.getName());
                if ((file.getName().endsWith(".carbondata") || file.getName().endsWith(".carbonindex")) && (Long.parseLong(fileTimestamp) < startTimeStampFinal || Long.parseLong(fileTimestamp) > endTimeStampFinal)) {
                    deleteFile = true;
                } else if (file.getName().endsWith(".carbonindexmerge") && Long.parseLong(fileTimestamp) < startTimeStampFinal) {
                    deleteFile = true;
                }
                if (!deleteFile) continue;
                try {
                    LOGGER.info((Object)("Deleting the invalid file : " + file.getName()));
                    CarbonUtil.deleteFoldersAndFiles(file);
                }
                catch (IOException e) {
                    LOGGER.error((Object)("Error in clean up of merged files." + e.getMessage()), (Throwable)e);
                }
                catch (InterruptedException e) {
                    LOGGER.error((Object)("Error in clean up of merged files." + e.getMessage()), (Throwable)e);
                }
            }
        }
    }

    private static boolean deleteStaleCarbonDataFiles(LoadMetadataDetails segment, CarbonFile[] allSegmentFiles, SegmentUpdateStatusManager updateStatusManager) {
        CarbonFile[] invalidUpdateDeltaFiles;
        for (CarbonFile invalidFile : invalidUpdateDeltaFiles = updateStatusManager.getUpdateDeltaFilesList(segment, false, ".carbondata", true, allSegmentFiles, true)) {
            CarbonUpdateUtil.compareTimestampsAndDelete(invalidFile, true, false);
        }
        CarbonFile[] invalidIndexFiles = updateStatusManager.getUpdateDeltaFilesList(segment, false, ".carbonindex", true, allSegmentFiles, true);
        boolean updateSegmentFile = false;
        for (CarbonFile invalidFile : invalidIndexFiles) {
            if (!CarbonUpdateUtil.compareTimestampsAndDelete(invalidFile, true, false)) continue;
            updateSegmentFile = true;
        }
        return updateSegmentFile;
    }

    public static boolean isMaxQueryTimeoutExceeded(long fileTimestamp) {
        int maxTime;
        long currentTime = CarbonUpdateUtil.readCurrentTime();
        try {
            maxTime = Integer.parseInt(CarbonProperties.getInstance().getProperty("max.query.execution.time"));
        }
        catch (NumberFormatException e) {
            maxTime = 60;
        }
        long difference = currentTime - fileTimestamp;
        long minutesElapsed = difference / 60000L;
        return minutesElapsed > (long)maxTime;
    }

    private static boolean compareTimestampsAndDelete(CarbonFile invalidFile, boolean forceDelete, boolean isUpdateStatusFile) {
        boolean isDeleted = false;
        Long fileTimestamp = isUpdateStatusFile ? CarbonUpdateUtil.getTimeStampAsLong(invalidFile.getName().substring(invalidFile.getName().lastIndexOf("-") + 1)) : CarbonUpdateUtil.getTimeStampAsLong(CarbonTablePath.DataFileUtil.getTimeStampFromFileName(invalidFile.getName()));
        if (fileTimestamp == null) {
            long tableUpdateStatusFileTimeStamp;
            String tableUpdateStatusFilename = invalidFile.getName();
            if (tableUpdateStatusFilename.endsWith(".write") && CarbonUpdateUtil.isMaxQueryTimeoutExceeded(tableUpdateStatusFileTimeStamp = Long.parseLong(CarbonTablePath.DataFileUtil.getTimeStampFromFileName(tableUpdateStatusFilename)))) {
                isDeleted = CarbonUpdateUtil.deleteInvalidFiles(invalidFile);
            }
        } else if (CarbonUpdateUtil.isMaxQueryTimeoutExceeded(fileTimestamp) || forceDelete) {
            isDeleted = CarbonUpdateUtil.deleteInvalidFiles(invalidFile);
        }
        return isDeleted;
    }

    private static boolean deleteInvalidFiles(CarbonFile invalidFile) {
        boolean isDeleted;
        try {
            LOGGER.info((Object)("deleting the invalid file : " + invalidFile.getName()));
            CarbonUtil.deleteFoldersAndFiles(invalidFile);
            isDeleted = true;
        }
        catch (IOException | InterruptedException e) {
            LOGGER.error((Object)("error in clean up of invalid files." + e.getMessage()), (Throwable)e);
            isDeleted = false;
        }
        return isDeleted;
    }

    public static boolean isBlockInvalid(SegmentStatus blockStatus) {
        return blockStatus == SegmentStatus.COMPACTED || blockStatus == SegmentStatus.MARKED_FOR_DELETE;
    }

    public static long readCurrentTime() {
        return System.currentTimeMillis();
    }

    public static void decrementDeletedBlockCount(SegmentUpdateDetails details, Map<String, Long> segmentBlockCount) {
        String segId = details.getSegmentName();
        segmentBlockCount.put(details.getSegmentName(), segmentBlockCount.get(segId) - 1L);
    }

    public static List<Segment> getListOfSegmentsToMarkDeleted(Map<String, Long> segmentBlockCount) {
        ArrayList<Segment> segmentsToBeDeleted = new ArrayList<Segment>(16);
        for (Map.Entry<String, Long> eachSeg : segmentBlockCount.entrySet()) {
            if (eachSeg.getValue() != 0L) continue;
            segmentsToBeDeleted.add(new Segment(eachSeg.getKey(), ""));
        }
        return segmentsToBeDeleted;
    }

    public static long getRowCount(BlockMappingVO blockMappingVO, CarbonTable carbonTable) {
        if (blockMappingVO.getBlockRowCountMapping().size() == 1 && blockMappingVO.getBlockRowCountMapping().get("rowCount") != null) {
            return blockMappingVO.getBlockRowCountMapping().get("rowCount");
        }
        SegmentUpdateStatusManager updateStatusManager = new SegmentUpdateStatusManager(carbonTable);
        long rowCount = 0L;
        Map<String, Long> blockRowCountMap = blockMappingVO.getBlockRowCountMapping();
        for (Map.Entry<String, Long> blockRowEntry : blockRowCountMap.entrySet()) {
            String key = blockRowEntry.getKey();
            long alreadyDeletedCount = 0L;
            SegmentUpdateDetails detail = updateStatusManager.getDetailsForABlock(key);
            if (detail != null) {
                alreadyDeletedCount = Long.parseLong(detail.getDeletedRowsInBlock());
            }
            rowCount += blockRowEntry.getValue() - alreadyDeletedCount;
        }
        return rowCount;
    }

    public static void createBlockDetailsMap(BlockMappingVO blockMappingVO, SegmentUpdateStatusManager segmentUpdateStatusManager) {
        Map<String, Long> blockRowCountMap = blockMappingVO.getBlockRowCountMapping();
        HashMap<String, RowCountDetailsVO> outputMap = new HashMap<String, RowCountDetailsVO>(16);
        for (Map.Entry<String, Long> blockRowEntry : blockRowCountMap.entrySet()) {
            String key = blockRowEntry.getKey();
            long alreadyDeletedCount = 0L;
            SegmentUpdateDetails detail = segmentUpdateStatusManager.getDetailsForABlock(key);
            if (null != detail) {
                alreadyDeletedCount = Long.parseLong(detail.getDeletedRowsInBlock());
            }
            RowCountDetailsVO rowCountDetailsVO = new RowCountDetailsVO(blockRowEntry.getValue(), alreadyDeletedCount);
            outputMap.put(key, rowCountDetailsVO);
        }
        blockMappingVO.setCompleteBlockRowDetailVO(outputMap);
    }

    public static String getSegmentBlockNameKey(String segID, String blockName, boolean isPartitionTable) {
        String blockNameWithOutPart = blockName.substring(blockName.indexOf("-") + 1, blockName.lastIndexOf(CarbonTablePath.getCarbonDataExtension()));
        if (isPartitionTable) {
            return blockNameWithOutPart;
        }
        return segID + "/" + blockNameWithOutPart;
    }

    public static long getLatestDeleteDeltaTimestamp(String[] deleteDeltaFiles) {
        long latestTimestamp = 0L;
        for (int i = 0; i < deleteDeltaFiles.length; ++i) {
            long convertTimeStampToLong = Long.parseLong(CarbonTablePath.DataFileUtil.getTimeStampFromDeleteDeltaFile(deleteDeltaFiles[i]));
            if (latestTimestamp >= convertTimeStampToLong) continue;
            latestTimestamp = convertTimeStampToLong;
        }
        return latestTimestamp;
    }
}

