/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.mutate;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.carbondata.common.logging.LogServiceFactory;
import org.apache.carbondata.core.mutate.CarbonUpdateUtil;
import org.apache.carbondata.core.mutate.DeleteDeltaBlockletDetails;
import org.apache.log4j.Logger;

public class DeleteDeltaBlockDetails
implements Serializable {
    private static final long serialVersionUID = 1206104914918495724L;
    private Map<String, DeleteDeltaBlockletDetails> blockletDetailsMap;
    private String blockName;
    private static final Logger LOGGER = LogServiceFactory.getLogService((String)DeleteDeltaBlockDetails.class.getName());

    public DeleteDeltaBlockDetails(String blockName) {
        this.blockName = blockName;
        this.blockletDetailsMap = new TreeMap<String, DeleteDeltaBlockletDetails>();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof DeleteDeltaBlockDetails)) {
            return false;
        }
        DeleteDeltaBlockDetails that = (DeleteDeltaBlockDetails)obj;
        return this.blockName.equals(that.blockName);
    }

    public int hashCode() {
        return this.blockName.hashCode();
    }

    public List<DeleteDeltaBlockletDetails> getBlockletDetails() {
        Set<Map.Entry<String, DeleteDeltaBlockletDetails>> entries;
        ArrayList<DeleteDeltaBlockletDetails> deleteDeltaBlockletDetailsList = new ArrayList<DeleteDeltaBlockletDetails>();
        if (null != this.blockletDetailsMap && null != (entries = this.blockletDetailsMap.entrySet()) && !entries.isEmpty()) {
            Iterator<Map.Entry<String, DeleteDeltaBlockletDetails>> iterator = entries.iterator();
            while (iterator.hasNext()) {
                deleteDeltaBlockletDetailsList.add(iterator.next().getValue());
            }
        }
        return deleteDeltaBlockletDetailsList;
    }

    public boolean addBlockletDetails(DeleteDeltaBlockletDetails blocklet) {
        DeleteDeltaBlockletDetails deleteDeltaBlockletDetails = this.blockletDetailsMap.get(blocklet.getBlockletKey());
        if (null == deleteDeltaBlockletDetails) {
            this.blockletDetailsMap.put(blocklet.getBlockletKey(), blocklet);
            return true;
        }
        deleteDeltaBlockletDetails.addDeletedRows(blocklet.getDeletedRows());
        return true;
    }

    public boolean addBlocklet(String blockletId, String offset, Integer pageId) throws Exception {
        DeleteDeltaBlockletDetails blocklet = new DeleteDeltaBlockletDetails(blockletId, pageId);
        try {
            blocklet.addDeletedRow(CarbonUpdateUtil.getIntegerValue(offset));
            return this.addBlockletDetails(blocklet);
        }
        catch (Exception e) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)e.getMessage());
            }
            throw e;
        }
    }
}

