/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.mutate;

import java.io.Serializable;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.carbondata.common.logging.LogServiceFactory;
import org.apache.carbondata.core.statusmanager.SegmentStatus;
import org.apache.log4j.Logger;

public class SegmentUpdateDetails
implements Serializable {
    private static final long serialVersionUID = 1206104914918491724L;
    private String segmentName;
    private String blockName;
    private SegmentStatus segmentStatus;
    private String deleteDeltaEndTimestamp = "";
    private String deleteDeltaStartTimestamp = "";
    private Set<String> deltaFileStamps;
    private String actualBlockName;
    private String deletedRowsInBlock = "0";
    private static final Logger LOGGER = LogServiceFactory.getLogService((String)SegmentUpdateDetails.class.getName());

    public String getDeleteDeltaEndTimestamp() {
        return this.deleteDeltaEndTimestamp;
    }

    public void setDeleteDeltaEndTimestamp(String deleteDeltaEndTimestamp) {
        this.deleteDeltaEndTimestamp = deleteDeltaEndTimestamp;
    }

    public String getSegmentName() {
        return this.segmentName;
    }

    public void setSegmentName(String segmentName) {
        this.segmentName = segmentName;
    }

    public String getBlockName() {
        return this.blockName;
    }

    public void setBlockName(String blockName) {
        this.blockName = blockName;
    }

    public String getDeleteDeltaStartTimestamp() {
        return this.deleteDeltaStartTimestamp;
    }

    public void setDeleteDeltaStartTimestamp(String deleteDeltaStartTimestamp) {
        this.deleteDeltaStartTimestamp = deleteDeltaStartTimestamp;
    }

    public void setSegmentStatus(SegmentStatus segmentStatus) {
        this.segmentStatus = segmentStatus;
    }

    public SegmentStatus getSegmentStatus() {
        return this.segmentStatus;
    }

    public Set<String> getDeltaFileStamps() {
        return this.deltaFileStamps;
    }

    public void addDeltaFileStamp(String deltaFileStamp) {
        if (this.deltaFileStamps == null) {
            this.deltaFileStamps = new LinkedHashSet<String>();
        }
        this.deltaFileStamps.add(deltaFileStamp);
    }

    public void setDeltaFileStamp(String deltaFileStamp) {
        if (this.deltaFileStamps == null) {
            this.deltaFileStamps = new LinkedHashSet<String>();
        }
        this.deltaFileStamps.add(deltaFileStamp);
    }

    public void setDeltaFileStamps(Set<String> deltaFileStamps) {
        this.deltaFileStamps = deltaFileStamps;
    }

    public int hashCode() {
        int prime = 31;
        int result = this.segmentName.hashCode();
        result = 31 * result + this.blockName.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SegmentUpdateDetails)) {
            return false;
        }
        SegmentUpdateDetails other = (SegmentUpdateDetails)obj;
        if (this.segmentName == null ? other.segmentName != null : !this.segmentName.equals(other.segmentName)) {
            return false;
        }
        return !(this.blockName == null ? other.blockName != null : !this.blockName.equals(other.blockName));
    }

    public long getDeleteDeltaEndTimeAsLong() {
        return this.getTimeStampAsLong(this.deleteDeltaEndTimestamp);
    }

    public long getDeleteDeltaStartTimeAsLong() {
        return this.getTimeStampAsLong(this.deleteDeltaStartTimestamp);
    }

    public String getActualBlockName() {
        return this.actualBlockName;
    }

    public void setActualBlockName(String actualBlockName) {
        this.actualBlockName = actualBlockName;
    }

    private Long getTimeStampAsLong(String timtstamp) {
        long longValue;
        block2: {
            longValue = 0L;
            try {
                longValue = Long.parseLong(timtstamp);
            }
            catch (NumberFormatException nfe) {
                if (!LOGGER.isDebugEnabled()) break block2;
                String errorMsg = "Invalid timestamp : " + timtstamp;
                LOGGER.debug((Object)errorMsg);
            }
        }
        return longValue;
    }

    public String getDeletedRowsInBlock() {
        return this.deletedRowsInBlock;
    }

    public void setDeletedRowsInBlock(String deletedRowsInBlock) {
        this.deletedRowsInBlock = deletedRowsInBlock;
    }
}

