/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.preagg;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.List;
import org.apache.carbondata.common.logging.LogServiceFactory;
import org.apache.carbondata.core.preagg.DaysOfWeekEnum;
import org.apache.carbondata.core.preagg.TimeSeriesFunctionEnum;
import org.apache.carbondata.core.util.CarbonProperties;
import org.apache.log4j.Logger;

public class TimeSeriesUDF {
    private static final Logger LOGGER = LogServiceFactory.getLogService((String)TimeSeriesUDF.class.getName());
    public final List<String> TIMESERIES_FUNCTION = new ArrayList<String>();
    private ThreadLocal<Calendar> calanderThreadLocal = new ThreadLocal();
    public static final TimeSeriesUDF INSTANCE = new TimeSeriesUDF();

    private TimeSeriesUDF() {
        this.initialize();
    }

    public Timestamp applyUDF(Timestamp data, String function) {
        if (null == data) {
            return data;
        }
        this.initialize();
        Calendar calendar = this.calanderThreadLocal.get();
        calendar.clear();
        calendar.setTimeInMillis(data.getTime());
        TimeSeriesFunctionEnum timeSeriesFunctionEnum = TimeSeriesFunctionEnum.valueOf(function.toUpperCase());
        switch (timeSeriesFunctionEnum) {
            case SECOND: {
                calendar.set(14, 0);
                break;
            }
            case MINUTE: {
                calendar.set(14, 0);
                calendar.set(13, 0);
                break;
            }
            case FIVE_MINUTE: {
                this.setData(calendar, 5);
                break;
            }
            case TEN_MINUTE: {
                this.setData(calendar, 10);
                break;
            }
            case FIFTEEN_MINUTE: {
                this.setData(calendar, 15);
                break;
            }
            case THIRTY_MINUTE: {
                this.setData(calendar, 30);
                break;
            }
            case WEEK: {
                calendar.set(11, 0);
                calendar.set(12, 0);
                calendar.set(13, 0);
                calendar.set(14, 0);
                calendar.set(7, calendar.getFirstDayOfWeek());
                break;
            }
            case HOUR: {
                calendar.set(14, 0);
                calendar.set(13, 0);
                calendar.set(12, 0);
                break;
            }
            case DAY: {
                calendar.set(11, 0);
                calendar.set(12, 0);
                calendar.set(13, 0);
                calendar.set(14, 0);
                break;
            }
            case MONTH: {
                calendar.set(14, 0);
                calendar.set(13, 0);
                calendar.set(12, 0);
                calendar.set(11, 0);
                calendar.set(5, 1);
                break;
            }
            case YEAR: {
                calendar.set(2, 1);
                calendar.set(6, 1);
                calendar.set(11, 0);
                calendar.set(12, 0);
                calendar.set(13, 0);
                calendar.set(14, 0);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid timeseries function name: " + function);
            }
        }
        data.setTime(calendar.getTimeInMillis());
        return data;
    }

    private void setData(Calendar calendar, int intervalTime) {
        calendar.set(14, 0);
        calendar.set(13, 0);
        calendar.set(12, calendar.get(12) / intervalTime * intervalTime);
    }

    private void initialize() {
        int firstDayOfWeek;
        if (this.calanderThreadLocal.get() == null) {
            this.calanderThreadLocal.set(new GregorianCalendar());
        }
        if (this.TIMESERIES_FUNCTION.isEmpty()) {
            this.TIMESERIES_FUNCTION.add("second");
            this.TIMESERIES_FUNCTION.add("minute");
            this.TIMESERIES_FUNCTION.add("five_minute");
            this.TIMESERIES_FUNCTION.add("ten_minute");
            this.TIMESERIES_FUNCTION.add("fifteen_minute");
            this.TIMESERIES_FUNCTION.add("thirty_minute");
            this.TIMESERIES_FUNCTION.add("hour");
            this.TIMESERIES_FUNCTION.add("day");
            this.TIMESERIES_FUNCTION.add("week");
            this.TIMESERIES_FUNCTION.add("month");
            this.TIMESERIES_FUNCTION.add("year");
        }
        try {
            firstDayOfWeek = DaysOfWeekEnum.valueOf(CarbonProperties.getInstance().getProperty("carbon.timeseries.first.day.of.week", "SUNDAY").toUpperCase()).getOrdinal();
        }
        catch (IllegalArgumentException ex) {
            LOGGER.warn((Object)"Invalid value set for first of the week. Considering the default value as: SUNDAY");
            firstDayOfWeek = DaysOfWeekEnum.valueOf(CarbonProperties.getInstance().getProperty("SUNDAY").toUpperCase()).getOrdinal();
        }
        this.calanderThreadLocal.get().setFirstDayOfWeek(firstDayOfWeek);
    }
}

