/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.profiler;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.carbondata.common.annotations.InterfaceAudience;
import org.apache.carbondata.core.index.dev.expr.IndexWrapperSimpleInfo;
import org.apache.carbondata.core.profiler.TablePruningInfo;
import org.apache.carbondata.core.util.CarbonProperties;

@InterfaceAudience.Internal
public class ExplainCollector {
    private static ExplainCollector INSTANCE = null;
    private List<String> mvProviders = new ArrayList<String>();
    private List<String> mvNames = new ArrayList<String>();
    private Map<String, Map<String, TablePruningInfo>> scans = new ConcurrentHashMap<String, Map<String, TablePruningInfo>>();

    private ExplainCollector() {
    }

    public static boolean enabled() {
        return INSTANCE != null;
    }

    public static void setup() {
        boolean isQueryStatisticsEnabled = Boolean.parseBoolean(CarbonProperties.getInstance().getProperty("enable.query.statistics", "false"));
        if (isQueryStatisticsEnabled) {
            INSTANCE = new ExplainCollector();
        }
    }

    public static void remove() {
        if (ExplainCollector.enabled()) {
            INSTANCE = null;
        }
    }

    public static ExplainCollector get() {
        return INSTANCE;
    }

    public static void addPruningInfo(String tableName) {
        if (ExplainCollector.enabled()) {
            ExplainCollector profiler = ExplainCollector.get();
            String threadName = Thread.currentThread().getName();
            if (!profiler.scans.containsKey(threadName)) {
                HashMap<String, TablePruningInfo> map = new HashMap<String, TablePruningInfo>();
                map.put(tableName, new TablePruningInfo());
                profiler.scans.put(threadName, map);
            }
        }
    }

    public static void setFilterStatement(String filterStatement) {
        if (ExplainCollector.enabled()) {
            TablePruningInfo scan = ExplainCollector.getCurrentTablePruningInfo();
            scan.setFilterStatement(filterStatement);
        }
    }

    public static void setShowPruningInfo(boolean showPruningInfo) {
        if (ExplainCollector.enabled()) {
            TablePruningInfo scan = ExplainCollector.getCurrentTablePruningInfo();
            scan.setShowPruningInfo(showPruningInfo);
        }
    }

    public static void addDefaultIndexPruningHit(int numBlocklets) {
        if (ExplainCollector.enabled()) {
            TablePruningInfo scan = ExplainCollector.getCurrentTablePruningInfo();
            scan.addNumBlockletsAfterDefaultPruning(numBlocklets);
        }
    }

    public static void setDefaultIndexPruningBlockHit(int numBlocks) {
        if (ExplainCollector.enabled()) {
            TablePruningInfo scan = ExplainCollector.getCurrentTablePruningInfo();
            scan.setNumBlocksAfterDefaultPruning(numBlocks);
        }
    }

    public static void recordCGIndexPruning(IndexWrapperSimpleInfo indexWrapperSimpleInfo, int numBlocklets, int numBlocks) {
        if (ExplainCollector.enabled()) {
            TablePruningInfo scan = ExplainCollector.getCurrentTablePruningInfo();
            scan.setNumBlockletsAfterCGPruning(indexWrapperSimpleInfo, numBlocklets, numBlocks);
        }
    }

    public static void recordFGIndexPruning(IndexWrapperSimpleInfo indexWrapperSimpleInfo, int numBlocklets, int numBlocks) {
        if (ExplainCollector.enabled()) {
            TablePruningInfo scan = ExplainCollector.getCurrentTablePruningInfo();
            scan.setNumBlockletsAfterFGPruning(indexWrapperSimpleInfo, numBlocklets, numBlocks);
        }
    }

    public static void addTotalBlocklets(int numBlocklets) {
        if (ExplainCollector.enabled()) {
            TablePruningInfo scan = ExplainCollector.getCurrentTablePruningInfo();
            scan.addTotalBlocklets(numBlocklets);
        }
    }

    public static void addTotalBlocks(int numBlocks) {
        if (ExplainCollector.enabled()) {
            TablePruningInfo scan = ExplainCollector.getCurrentTablePruningInfo();
            scan.addTotalBlocks(numBlocks);
        }
    }

    private static TablePruningInfo getCurrentTablePruningInfo() {
        String threadName = Thread.currentThread().getName();
        if (!ExplainCollector.get().scans.containsKey(threadName)) {
            throw new IllegalStateException();
        }
        Iterator<TablePruningInfo> iterator = ExplainCollector.get().scans.get(threadName).values().iterator();
        TablePruningInfo output = null;
        while (iterator.hasNext()) {
            output = iterator.next();
        }
        return output;
    }

    public static String getFormatedOutput() {
        if (null != ExplainCollector.get()) {
            return ExplainCollector.get().toString();
        }
        return null;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < this.mvProviders.size(); ++i) {
            if (i == 0) {
                builder.append("Query rewrite based on Index:").append("\n");
            }
            builder.append(" - ").append(this.mvNames.get(i)).append(" (").append(this.mvProviders.get(i)).append(")").append("\n");
        }
        for (Map.Entry<String, Map<String, TablePruningInfo>> allThreads : this.scans.entrySet()) {
            for (Map.Entry<String, TablePruningInfo> entry : allThreads.getValue().entrySet()) {
                builder.append("Table Scan on ").append(entry.getKey()).append("\n").append(entry.getValue().toString());
            }
        }
        return builder.toString();
    }
}

