/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.profiler;

import org.apache.carbondata.common.annotations.InterfaceAudience;
import org.apache.carbondata.core.index.dev.expr.IndexWrapperSimpleInfo;

@InterfaceAudience.Internal
public class TablePruningInfo {
    private int totalBlocks;
    private int totalBlocklets;
    private String filterStatement;
    private boolean showPruningInfo;
    private int numBlocksAfterDefaultPruning;
    private int numBlockletsAfterDefaultPruning = 0;
    private IndexWrapperSimpleInfo cgIndex;
    private int numBlocksAfterCGPruning;
    private int numBlockletsAfterCGPruning;
    private IndexWrapperSimpleInfo fgIndex;
    private int numBlocksAfterFGPruning;
    private int numBlockletsAfterFGPruning;

    synchronized void addTotalBlocks(int numBlocks) {
        this.totalBlocks += numBlocks;
    }

    synchronized void addTotalBlocklets(int numBlocklets) {
        this.totalBlocklets += numBlocklets;
    }

    void setFilterStatement(String filterStatement) {
        this.filterStatement = filterStatement;
    }

    void setShowPruningInfo(boolean showPruningInfo) {
        this.showPruningInfo = showPruningInfo;
    }

    void setNumBlocksAfterDefaultPruning(int numBlocks) {
        this.numBlocksAfterDefaultPruning = numBlocks;
    }

    synchronized void addNumBlockletsAfterDefaultPruning(int numBlocklets) {
        this.numBlockletsAfterDefaultPruning += numBlocklets;
    }

    void setNumBlockletsAfterCGPruning(IndexWrapperSimpleInfo indexWrapperSimpleInfo, int numBlocklets, int numBlocks) {
        this.cgIndex = indexWrapperSimpleInfo;
        this.numBlocksAfterCGPruning = numBlocks;
        this.numBlockletsAfterCGPruning = numBlocklets;
    }

    void setNumBlockletsAfterFGPruning(IndexWrapperSimpleInfo indexWrapperSimpleInfo, int numBlocklets, int numBlocks) {
        this.fgIndex = indexWrapperSimpleInfo;
        this.numBlocksAfterFGPruning = numBlocks;
        this.numBlockletsAfterFGPruning = numBlocklets;
    }

    public String toString() {
        if (this.showPruningInfo) {
            StringBuilder builder = new StringBuilder();
            builder.append(" - total: ").append(this.totalBlocks).append(" blocks, ").append(this.totalBlocklets).append(" blocklets").append("\n").append(" - filter: ").append(this.filterStatement).append("\n");
            int skipBlocks = this.totalBlocks - this.numBlocksAfterDefaultPruning;
            int skipBlocklets = this.totalBlocklets - this.numBlockletsAfterDefaultPruning;
            builder.append(" - pruned by Main Index").append("\n").append("    - skipped: ").append(skipBlocks).append(" blocks, ").append(skipBlocklets).append(" blocklets").append("\n");
            if (this.cgIndex != null) {
                skipBlocks = this.numBlocksAfterDefaultPruning - this.numBlocksAfterCGPruning;
                skipBlocklets = this.numBlockletsAfterDefaultPruning - this.numBlockletsAfterCGPruning;
                builder.append(" - pruned by CG Index").append("\n").append("    - name: ").append(this.cgIndex.getIndexWrapperName()).append("\n").append("    - provider: ").append(this.cgIndex.getIndexWrapperProvider()).append("\n").append("    - skipped: ").append(skipBlocks).append(" blocks, ").append(skipBlocklets).append(" blocklets").append("\n");
            }
            if (this.fgIndex != null) {
                if (this.numBlockletsAfterCGPruning != 0) {
                    skipBlocks = this.numBlocksAfterCGPruning - this.numBlocksAfterFGPruning;
                    skipBlocklets = this.numBlockletsAfterCGPruning - this.numBlockletsAfterFGPruning;
                } else {
                    skipBlocks = this.numBlocksAfterDefaultPruning - this.numBlocksAfterFGPruning;
                    skipBlocklets = this.numBlockletsAfterDefaultPruning - this.numBlockletsAfterFGPruning;
                }
                builder.append(" - pruned by FG Index").append("\n").append("    - name: ").append(this.fgIndex.getIndexWrapperName()).append("\n").append("    - provider: ").append(this.fgIndex.getIndexWrapperProvider()).append("\n").append("    - skipped: ").append(skipBlocks).append(" blocks, ").append(skipBlocklets).append(" blocklets").append("\n");
            }
            return builder.toString();
        }
        return "";
    }
}

