/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.readcommitter;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.carbondata.common.annotations.InterfaceAudience;
import org.apache.carbondata.common.annotations.InterfaceStability;
import org.apache.carbondata.core.datastore.filesystem.CarbonFile;
import org.apache.carbondata.core.datastore.impl.FileFactory;
import org.apache.carbondata.core.index.Segment;
import org.apache.carbondata.core.indexstore.blockletindex.SegmentIndexFileStore;
import org.apache.carbondata.core.mutate.UpdateVO;
import org.apache.carbondata.core.readcommitter.ReadCommittedIndexFileSnapShot;
import org.apache.carbondata.core.readcommitter.ReadCommittedScope;
import org.apache.carbondata.core.statusmanager.LoadMetadataDetails;
import org.apache.carbondata.core.statusmanager.SegmentRefreshInfo;
import org.apache.carbondata.core.statusmanager.SegmentStatus;
import org.apache.carbondata.core.util.path.CarbonTablePath;
import org.apache.hadoop.conf.Configuration;

@InterfaceAudience.Internal
@InterfaceStability.Stable
public class LatestFilesReadCommittedScope
implements ReadCommittedScope {
    private static final long serialVersionUID = -839970494288861816L;
    private String carbonFilePath;
    private String segmentId;
    private ReadCommittedIndexFileSnapShot readCommittedIndexFileSnapShot;
    private LoadMetadataDetails[] loadMetadataDetails;
    private transient Configuration configuration;

    public LatestFilesReadCommittedScope(String path, String segmentId, Configuration configuration) throws IOException {
        this.configuration = configuration;
        Objects.requireNonNull(path);
        this.carbonFilePath = path;
        this.segmentId = segmentId;
        this.takeCarbonIndexFileSnapShot();
    }

    public LatestFilesReadCommittedScope(String path, Configuration configuration) throws IOException {
        this(path, null, configuration);
    }

    public LatestFilesReadCommittedScope(CarbonFile[] indexFiles, Configuration configuration) {
        this.configuration = configuration;
        this.takeCarbonIndexFileSnapShot(indexFiles);
    }

    private void prepareLoadMetadata() {
        int loadCount = 0;
        Map<String, List<String>> snapshotMap = this.readCommittedIndexFileSnapShot.getSegmentIndexFileMap();
        LoadMetadataDetails[] loadMetadataDetailsArray = new LoadMetadataDetails[snapshotMap.size()];
        for (Map.Entry<String, List<String>> entry : snapshotMap.entrySet()) {
            long timeSet;
            String segmentID = entry.getKey();
            LoadMetadataDetails loadMetadataDetails = new LoadMetadataDetails();
            try {
                timeSet = Long.parseLong(segmentID);
            }
            catch (NumberFormatException nu) {
                timeSet = 0L;
            }
            loadMetadataDetails.setLoadEndTime(timeSet);
            loadMetadataDetails.setLoadStartTime(timeSet);
            loadMetadataDetails.setSegmentStatus(SegmentStatus.SUCCESS);
            loadMetadataDetails.setLoadName(segmentID);
            loadMetadataDetailsArray[loadCount++] = loadMetadataDetails;
        }
        this.loadMetadataDetails = loadMetadataDetailsArray;
    }

    @Override
    public LoadMetadataDetails[] getSegmentList() throws IOException {
        try {
            if (this.loadMetadataDetails == null) {
                this.takeCarbonIndexFileSnapShot();
            }
            return this.loadMetadataDetails;
        }
        catch (IOException ex) {
            throw new IOException("Problem encountered while reading the Table Status file.", ex);
        }
    }

    @Override
    public Map<String, String> getCommittedIndexFile(Segment segment) {
        String segName;
        HashMap<String, String> indexFileStore = new HashMap<String, String>();
        Map<String, List<String>> snapShot = this.readCommittedIndexFileSnapShot.getSegmentIndexFileMap();
        List<String> index = snapShot.get(segName = segment.getSegmentNo() != null ? segment.getSegmentNo() : segment.getSegmentFileName());
        if (null == index) {
            index = new LinkedList<String>();
        }
        for (String indexPath : index) {
            if (indexPath.endsWith(".carbonindexmerge")) {
                indexFileStore.put(indexPath, indexPath.substring(indexPath.lastIndexOf(47) + 1));
                continue;
            }
            indexFileStore.put(indexPath, null);
        }
        return indexFileStore;
    }

    @Override
    public SegmentRefreshInfo getCommittedSegmentRefreshInfo(Segment segment, UpdateVO updateVo) {
        Map<String, SegmentRefreshInfo> snapShot = this.readCommittedIndexFileSnapShot.getSegmentTimestampUpdaterMap();
        String segName = segment.getSegmentNo() != null ? segment.getSegmentNo() : segment.getSegmentFileName();
        SegmentRefreshInfo segmentRefreshInfo = snapShot.get(segName);
        return segmentRefreshInfo;
    }

    private String getSegmentID(String carbonIndexFileName, String indexFilePath) {
        if (indexFilePath.contains("/Fact/Part0/Segment_")) {
            String segString = indexFilePath.substring(0, indexFilePath.lastIndexOf("/") + 1);
            String segName = segString.substring(segString.lastIndexOf("_") + 1, segString.lastIndexOf("/"));
            return segName;
        }
        String fileName = carbonIndexFileName;
        String segId = fileName.substring(fileName.lastIndexOf("-") + 1, fileName.lastIndexOf("."));
        return segId;
    }

    @Override
    public void takeCarbonIndexFileSnapShot() throws IOException {
        CarbonFile file = FileFactory.getCarbonFile(this.carbonFilePath, this.configuration);
        CarbonFile[] carbonIndexFiles = null;
        if (file.isDirectory()) {
            if (this.segmentId == null) {
                ArrayList<CarbonFile> indexFiles = new ArrayList<CarbonFile>();
                SegmentIndexFileStore.getCarbonIndexFilesRecursively(file, indexFiles);
                carbonIndexFiles = indexFiles.toArray(new CarbonFile[0]);
            } else {
                String segmentPath = CarbonTablePath.getSegmentPath(this.carbonFilePath, this.segmentId);
                carbonIndexFiles = SegmentIndexFileStore.getCarbonIndexFiles(segmentPath, this.configuration);
            }
            if (carbonIndexFiles.length == 0) {
                throw new IOException("No Index files are present in the table location :" + this.carbonFilePath);
            }
        } else {
            throw new IOException("Path is not pointing to directory");
        }
        this.takeCarbonIndexFileSnapShot(carbonIndexFiles);
    }

    private void takeCarbonIndexFileSnapShot(CarbonFile[] carbonIndexFiles) {
        ReadCommittedIndexFileSnapShot readCommittedIndexFileSnapShot;
        HashMap<String, List<String>> indexFileStore = new HashMap<String, List<String>>();
        HashMap<String, SegmentRefreshInfo> segmentTimestampUpdaterMap = new HashMap<String, SegmentRefreshInfo>();
        for (int i = 0; i < carbonIndexFiles.length; ++i) {
            SegmentRefreshInfo segmentRefreshInfo;
            List<String> indexList;
            if (!carbonIndexFiles[i].getName().endsWith(".carbonindex") && !carbonIndexFiles[i].getName().endsWith(".carbonindexmerge")) continue;
            String indexFilePath = FileFactory.getUpdatedFilePath(carbonIndexFiles[i].getAbsolutePath());
            String timestamp = this.getSegmentID(carbonIndexFiles[i].getName(), indexFilePath);
            if (indexFileStore.get(timestamp) == null) {
                indexList = new ArrayList(1);
                segmentRefreshInfo = new SegmentRefreshInfo(carbonIndexFiles[i].getLastModifiedTime(), 0, 0L);
                segmentTimestampUpdaterMap.put(timestamp, segmentRefreshInfo);
            } else {
                indexList = (List)indexFileStore.get(timestamp);
                segmentRefreshInfo = (SegmentRefreshInfo)segmentTimestampUpdaterMap.get(timestamp);
            }
            indexList.add(indexFilePath);
            if (segmentRefreshInfo.getSegmentUpdatedTimestamp() < carbonIndexFiles[i].getLastModifiedTime()) {
                segmentRefreshInfo.setSegmentUpdatedTimestamp(carbonIndexFiles[i].getLastModifiedTime());
            }
            indexFileStore.put(timestamp, indexList);
            segmentRefreshInfo.setCountOfFileInSegment(indexList.size());
        }
        this.readCommittedIndexFileSnapShot = readCommittedIndexFileSnapShot = new ReadCommittedIndexFileSnapShot(indexFileStore, segmentTimestampUpdaterMap);
        this.prepareLoadMetadata();
    }

    @Override
    public Configuration getConfiguration() {
        return this.configuration;
    }

    @Override
    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    @Override
    public String getFilePath() {
        return this.carbonFilePath;
    }
}

