/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.readcommitter;

import java.io.IOException;
import java.util.Map;
import org.apache.carbondata.common.annotations.InterfaceAudience;
import org.apache.carbondata.common.annotations.InterfaceStability;
import org.apache.carbondata.core.datastore.impl.FileFactory;
import org.apache.carbondata.core.index.Segment;
import org.apache.carbondata.core.indexstore.blockletindex.SegmentIndexFileStore;
import org.apache.carbondata.core.metadata.AbsoluteTableIdentifier;
import org.apache.carbondata.core.metadata.SegmentFileStore;
import org.apache.carbondata.core.mutate.UpdateVO;
import org.apache.carbondata.core.readcommitter.ReadCommittedScope;
import org.apache.carbondata.core.statusmanager.LoadMetadataDetails;
import org.apache.carbondata.core.statusmanager.SegmentRefreshInfo;
import org.apache.carbondata.core.statusmanager.SegmentStatusManager;
import org.apache.carbondata.core.util.path.CarbonTablePath;
import org.apache.hadoop.conf.Configuration;

@InterfaceAudience.Internal
@InterfaceStability.Stable
public class TableStatusReadCommittedScope
implements ReadCommittedScope {
    private static final long serialVersionUID = 2324397174595872738L;
    private LoadMetadataDetails[] loadMetadataDetails;
    private AbsoluteTableIdentifier identifier;
    private transient Configuration configuration;

    public TableStatusReadCommittedScope(AbsoluteTableIdentifier identifier, Configuration configuration) throws IOException {
        this.identifier = identifier;
        this.configuration = configuration;
        this.takeCarbonIndexFileSnapShot();
    }

    public TableStatusReadCommittedScope(AbsoluteTableIdentifier identifier, LoadMetadataDetails[] loadMetadataDetails, Configuration configuration) {
        this.identifier = identifier;
        this.configuration = configuration;
        this.loadMetadataDetails = loadMetadataDetails;
    }

    @Override
    public LoadMetadataDetails[] getSegmentList() throws IOException {
        try {
            if (this.loadMetadataDetails == null) {
                this.takeCarbonIndexFileSnapShot();
            }
            return this.loadMetadataDetails;
        }
        catch (IOException ex) {
            throw new IOException("Problem encountered while reading the Table Status file.", ex);
        }
    }

    @Override
    public Map<String, String> getCommittedIndexFile(Segment segment) throws IOException {
        Map<String, String> indexFiles;
        if (segment.getSegmentFileName() == null) {
            String path = CarbonTablePath.getSegmentPath(this.identifier.getTablePath(), segment.getSegmentNo());
            indexFiles = new SegmentIndexFileStore().getMergeOrIndexFilesFromSegment(path);
        } else {
            SegmentFileStore fileStore = new SegmentFileStore(this.identifier.getTablePath(), segment.getSegmentFileName());
            indexFiles = fileStore.getIndexOrMergeFiles();
            segment.setSegmentMetaDataInfo(fileStore.getSegmentFile().getSegmentMetaDataInfo());
        }
        return indexFiles;
    }

    @Override
    public SegmentRefreshInfo getCommittedSegmentRefreshInfo(Segment segment, UpdateVO updateVo) {
        long segmentFileTimeStamp = 0L;
        if (null != segment.getSegmentFileName()) {
            segmentFileTimeStamp = FileFactory.getCarbonFile(CarbonTablePath.getSegmentFilePath(this.identifier.getTablePath(), segment.getSegmentFileName())).getLastModifiedTime();
        }
        SegmentRefreshInfo segmentRefreshInfo = updateVo != null ? new SegmentRefreshInfo(updateVo.getLatestUpdateTimestamp(), 0, segmentFileTimeStamp) : new SegmentRefreshInfo(0L, 0, segmentFileTimeStamp);
        return segmentRefreshInfo;
    }

    @Override
    public void takeCarbonIndexFileSnapShot() throws IOException {
        this.loadMetadataDetails = SegmentStatusManager.readTableStatusFile(CarbonTablePath.getTableStatusFilePath(this.identifier.getTablePath()));
    }

    @Override
    public Configuration getConfiguration() {
        return this.configuration;
    }

    @Override
    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    @Override
    public String getFilePath() {
        return this.identifier.getTablePath();
    }
}

