/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.reader;

import com.google.gson.Gson;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import org.apache.carbondata.core.datastore.impl.FileFactory;
import org.apache.carbondata.core.fileoperations.AtomicFileOperationFactory;
import org.apache.carbondata.core.fileoperations.AtomicFileOperations;
import org.apache.carbondata.core.mutate.DeleteDeltaBlockDetails;
import org.apache.carbondata.core.reader.CarbonDeleteDeltaFileReader;
import org.apache.carbondata.core.util.CarbonUtil;

public class CarbonDeleteDeltaFileReaderImpl
implements CarbonDeleteDeltaFileReader {
    private String filePath;
    private DataInputStream dataInputStream = null;
    private InputStreamReader inputStream = null;
    private static final int DEFAULT_BUFFER_SIZE = 258;

    public CarbonDeleteDeltaFileReaderImpl(String filePath) {
        this.filePath = filePath;
    }

    @Override
    public String read() throws IOException {
        char[] buffer = new char[258];
        StringWriter sw = new StringWriter();
        this.dataInputStream = FileFactory.getDataInputStream(this.filePath);
        this.inputStream = new InputStreamReader((InputStream)this.dataInputStream, "UTF-8");
        int n = 0;
        while (-1 != (n = this.inputStream.read(buffer))) {
            sw.write(buffer, 0, n);
        }
        return sw.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteDeltaBlockDetails readJson() {
        DeleteDeltaBlockDetails deleteDeltaBlockDetails;
        AtomicFileOperations fileOperation;
        InputStreamReader inStream;
        BufferedReader buffReader;
        DataInputStream dataInputStream;
        Gson gsonObjectToRead;
        block5: {
            gsonObjectToRead = new Gson();
            dataInputStream = null;
            buffReader = null;
            inStream = null;
            fileOperation = AtomicFileOperationFactory.getAtomicFileOperations(this.filePath);
            if (FileFactory.isFileExist(this.filePath)) break block5;
            DeleteDeltaBlockDetails deleteDeltaBlockDetails2 = new DeleteDeltaBlockDetails("");
            CarbonUtil.closeStreams(buffReader, inStream, dataInputStream);
            return deleteDeltaBlockDetails2;
        }
        try {
            dataInputStream = fileOperation.openForRead();
            inStream = new InputStreamReader((InputStream)dataInputStream, "UTF-8");
            buffReader = new BufferedReader(inStream);
            deleteDeltaBlockDetails = (DeleteDeltaBlockDetails)gsonObjectToRead.fromJson((Reader)buffReader, DeleteDeltaBlockDetails.class);
        }
        catch (IOException e) {
            DeleteDeltaBlockDetails deleteDeltaBlockDetails3;
            try {
                deleteDeltaBlockDetails3 = new DeleteDeltaBlockDetails("");
            }
            catch (Throwable throwable) {
                CarbonUtil.closeStreams(buffReader, inStream, dataInputStream);
                throw throwable;
            }
            CarbonUtil.closeStreams(buffReader, inStream, dataInputStream);
            return deleteDeltaBlockDetails3;
        }
        CarbonUtil.closeStreams(buffReader, inStream, dataInputStream);
        return deleteDeltaBlockDetails;
    }
}

