/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.reader;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.carbondata.common.logging.LogServiceFactory;
import org.apache.carbondata.core.mutate.DeleteDeltaBlockDetails;
import org.apache.carbondata.core.mutate.DeleteDeltaBlockletDetails;
import org.apache.carbondata.core.mutate.DeleteDeltaVo;
import org.apache.carbondata.core.reader.CarbonDeleteDeltaFileReaderImpl;
import org.apache.carbondata.core.util.CarbonProperties;
import org.apache.log4j.Logger;

public class CarbonDeleteFilesDataReader {
    private static final Logger LOGGER = LogServiceFactory.getLogService((String)CarbonDeleteFilesDataReader.class.getName());
    protected int thread_pool_size;

    public CarbonDeleteFilesDataReader() {
        this.initThreadPoolSize();
    }

    public CarbonDeleteFilesDataReader(int thread_pool_size) {
        this.thread_pool_size = thread_pool_size;
    }

    private void initThreadPoolSize() {
        this.thread_pool_size = CarbonProperties.getInstance().getNumberOfLoadingCores();
    }

    public Map<Integer, Integer[]> getDeleteDataFromAllFiles(List<String> deltaFiles, String blockletId) throws Exception {
        ArrayList<Future<DeleteDeltaBlockDetails>> taskSubmitList = new ArrayList<Future<DeleteDeltaBlockDetails>>();
        ExecutorService executorService = Executors.newFixedThreadPool(this.thread_pool_size);
        for (String deltaFile : deltaFiles) {
            taskSubmitList.add(executorService.submit(new DeleteDeltaFileReaderCallable(deltaFile)));
        }
        try {
            executorService.shutdown();
            executorService.awaitTermination(30L, TimeUnit.MINUTES);
        }
        catch (InterruptedException e) {
            LOGGER.error((Object)("Error while reading the delete delta files : " + e.getMessage()), (Throwable)e);
        }
        HashMap<Integer, Integer[]> pageIdDeleteRowsMap = new HashMap<Integer, Integer[]>(16);
        for (int i = 0; i < taskSubmitList.size(); ++i) {
            try {
                List<DeleteDeltaBlockletDetails> blockletDetails = ((DeleteDeltaBlockDetails)((Future)taskSubmitList.get(i)).get()).getBlockletDetails();
                for (DeleteDeltaBlockletDetails eachBlockletDetails : blockletDetails) {
                    Integer pageId = eachBlockletDetails.getPageId();
                    Set<Integer> rows = blockletDetails.get(blockletDetails.indexOf(new DeleteDeltaBlockletDetails(blockletId, pageId))).getDeletedRows();
                    pageIdDeleteRowsMap.put(pageId, rows.toArray(new Integer[rows.size()]));
                }
                continue;
            }
            catch (Throwable e) {
                LOGGER.error((Object)e.getMessage(), e);
                throw new Exception(e);
            }
        }
        return pageIdDeleteRowsMap;
    }

    public Map<String, DeleteDeltaVo> getDeletedRowsDataVo(String[] deltaFiles) {
        ArrayList<Future<DeleteDeltaBlockDetails>> taskSubmitList = new ArrayList<Future<DeleteDeltaBlockDetails>>();
        ExecutorService executorService = Executors.newFixedThreadPool(this.thread_pool_size);
        for (String deltaFile : deltaFiles) {
            taskSubmitList.add(executorService.submit(new DeleteDeltaFileReaderCallable(deltaFile)));
        }
        try {
            executorService.shutdown();
            executorService.awaitTermination(30L, TimeUnit.MINUTES);
        }
        catch (InterruptedException e) {
            LOGGER.error((Object)("Error while reading the delete delta files : " + e.getMessage()), (Throwable)e);
        }
        HashMap<String, DeleteDeltaVo> pageIdToBlockLetVo = new HashMap<String, DeleteDeltaVo>();
        List<DeleteDeltaBlockletDetails> blockletDetails = null;
        for (int i = 0; i < taskSubmitList.size(); ++i) {
            try {
                blockletDetails = ((DeleteDeltaBlockDetails)((Future)taskSubmitList.get(i)).get()).getBlockletDetails();
            }
            catch (InterruptedException | ExecutionException e) {
                throw new RuntimeException(e);
            }
            for (DeleteDeltaBlockletDetails blockletDetail : blockletDetails) {
                DeleteDeltaVo deleteDeltaVo = (DeleteDeltaVo)pageIdToBlockLetVo.get(blockletDetail.getBlockletKey());
                if (null == deleteDeltaVo) {
                    deleteDeltaVo = new DeleteDeltaVo();
                    pageIdToBlockLetVo.put(blockletDetail.getBlockletKey(), deleteDeltaVo);
                }
                deleteDeltaVo.insertData(blockletDetail.getDeletedRows());
            }
        }
        return pageIdToBlockLetVo;
    }

    public DeleteDeltaBlockDetails getCompactedDeleteDeltaFileFromBlock(List<String> deltaFiles, String blockName) throws Exception {
        ArrayList<Future<DeleteDeltaBlockDetails>> taskSubmitList = new ArrayList<Future<DeleteDeltaBlockDetails>>(deltaFiles.size());
        ExecutorService executorService = Executors.newFixedThreadPool(this.thread_pool_size);
        for (String deltaFile : deltaFiles) {
            taskSubmitList.add(executorService.submit(new DeleteDeltaFileReaderCallable(deltaFile)));
        }
        try {
            executorService.shutdown();
            executorService.awaitTermination(30L, TimeUnit.MINUTES);
        }
        catch (InterruptedException e) {
            LOGGER.error((Object)("Error while reading the delete delta files : " + e.getMessage()), (Throwable)e);
        }
        DeleteDeltaBlockDetails deleteDeltaResultSet = new DeleteDeltaBlockDetails(blockName);
        for (int i = 0; i < taskSubmitList.size(); ++i) {
            try {
                List<DeleteDeltaBlockletDetails> blockletDetails = ((DeleteDeltaBlockDetails)((Future)taskSubmitList.get(i)).get()).getBlockletDetails();
                for (DeleteDeltaBlockletDetails blocklet : blockletDetails) {
                    deleteDeltaResultSet.addBlockletDetails(blocklet);
                }
                continue;
            }
            catch (Throwable e) {
                LOGGER.error((Object)e.getMessage(), e);
                throw new Exception(e);
            }
        }
        return deleteDeltaResultSet;
    }

    private static class DeleteDeltaFileReaderCallable
    implements Callable<DeleteDeltaBlockDetails> {
        private String deltaFile;

        DeleteDeltaFileReaderCallable(String deltaFile) {
            this.deltaFile = deltaFile;
        }

        @Override
        public DeleteDeltaBlockDetails call() {
            CarbonDeleteDeltaFileReaderImpl deltaFileReader = new CarbonDeleteDeltaFileReaderImpl(this.deltaFile);
            return deltaFileReader.readJson();
        }
    }
}

