/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.reader;

import java.io.IOException;
import org.apache.carbondata.core.reader.ThriftReader;
import org.apache.carbondata.format.FileFooter;
import org.apache.thrift.TBase;

public class CarbonFooterReader {
    private String filePath;
    private long offset;

    public CarbonFooterReader(String filePath, long offset) {
        this.filePath = filePath;
        this.offset = offset;
    }

    public FileFooter readFooter() throws IOException {
        ThriftReader thriftReader = this.openThriftReader(this.filePath);
        thriftReader.open();
        thriftReader.setReadOffset(this.offset);
        FileFooter footer = (FileFooter)thriftReader.read();
        thriftReader.close();
        return footer;
    }

    private ThriftReader openThriftReader(String filePath) {
        return new ThriftReader(filePath, new ThriftReader.TBaseCreator(){

            @Override
            public TBase create() {
                return new FileFooter();
            }
        });
    }
}

