/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.reader;

import java.io.IOException;
import org.apache.carbondata.core.reader.ThriftReader;
import org.apache.carbondata.format.FileFooter3;
import org.apache.thrift.TBase;

public class CarbonFooterReaderV3 {
    private String filePath;
    private long footerOffset;

    public CarbonFooterReaderV3(String filePath, long offset) {
        this.filePath = filePath;
        this.footerOffset = offset;
    }

    public FileFooter3 readFooterVersion3() throws IOException {
        ThriftReader thriftReader = this.openThriftReader(this.filePath);
        thriftReader.open();
        thriftReader.setReadOffset(this.footerOffset);
        FileFooter3 footer = (FileFooter3)thriftReader.read();
        thriftReader.close();
        return footer;
    }

    private ThriftReader openThriftReader(String filePath) {
        return new ThriftReader(filePath, new ThriftReader.TBaseCreator(){

            @Override
            public TBase create() {
                return new FileFooter3();
            }
        });
    }
}

