/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.reader;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.carbondata.core.datastore.impl.FileFactory;
import org.apache.carbondata.core.reader.ThriftReader;
import org.apache.carbondata.core.util.CarbonUtil;
import org.apache.carbondata.format.ColumnSchema;
import org.apache.carbondata.format.FileHeader;
import org.apache.hadoop.conf.Configuration;
import org.apache.thrift.TBase;

public class CarbonHeaderReader {
    private String filePath;
    private Configuration configuration;

    public CarbonHeaderReader(String filePath) {
        this.filePath = filePath;
    }

    public CarbonHeaderReader(String filePath, Configuration configuration) {
        this.filePath = filePath;
        this.configuration = configuration;
    }

    public FileHeader readHeader() throws IOException {
        ThriftReader thriftReader = this.openThriftReader(this.filePath);
        thriftReader.open();
        FileHeader header = (FileHeader)thriftReader.read();
        thriftReader.close();
        return header;
    }

    private ThriftReader openThriftReader(String filePath) {
        Configuration conf = this.configuration != null ? this.configuration : FileFactory.getConfiguration();
        return new ThriftReader(filePath, new ThriftReader.TBaseCreator(){

            @Override
            public TBase create() {
                return new FileHeader();
            }
        }, conf);
    }

    public List<org.apache.carbondata.core.metadata.schema.table.column.ColumnSchema> readSchema() throws IOException {
        FileHeader fileHeader = this.readHeader();
        ArrayList<org.apache.carbondata.core.metadata.schema.table.column.ColumnSchema> columnSchemaList = new ArrayList<org.apache.carbondata.core.metadata.schema.table.column.ColumnSchema>();
        List table_columns = fileHeader.getColumn_schema();
        for (ColumnSchema table_column : table_columns) {
            org.apache.carbondata.core.metadata.schema.table.column.ColumnSchema col = CarbonUtil.thriftColumnSchemaToWrapperColumnSchema(table_column);
            col.setColumnReferenceId(col.getColumnUniqueId());
            columnSchemaList.add(col);
        }
        return columnSchemaList;
    }
}

