/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.reader;

import java.io.IOException;
import org.apache.carbondata.core.reader.ThriftReader;
import org.apache.carbondata.format.BlockIndex;
import org.apache.carbondata.format.IndexHeader;
import org.apache.hadoop.conf.Configuration;
import org.apache.thrift.TBase;

public class CarbonIndexFileReader {
    private Configuration configuration;
    private ThriftReader thriftReader;

    public CarbonIndexFileReader() {
    }

    public CarbonIndexFileReader(Configuration configuration) {
        this.configuration = configuration;
    }

    public IndexHeader readIndexHeader() throws IOException {
        return (IndexHeader)this.thriftReader.read(new ThriftReader.TBaseCreator(){

            @Override
            public TBase create() {
                return new IndexHeader();
            }
        });
    }

    public void closeThriftReader() {
        this.thriftReader.close();
    }

    public BlockIndex readBlockIndexInfo() throws IOException {
        return (BlockIndex)this.thriftReader.read(new ThriftReader.TBaseCreator(){

            @Override
            public TBase create() {
                return new BlockIndex();
            }
        });
    }

    public void openThriftReader(String filePath) throws IOException {
        this.thriftReader = new ThriftReader(filePath, this.configuration);
        this.thriftReader.open();
    }

    public void openThriftReader(byte[] fileData) {
        this.thriftReader = new ThriftReader(fileData);
    }

    public boolean hasNext() throws IOException {
        return this.thriftReader.hasNext();
    }
}

