/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.reader;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.carbondata.core.datastore.impl.FileFactory;
import org.apache.carbondata.core.util.CarbonUtil;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.thrift.TBase;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.transport.TIOStreamTransport;
import org.apache.thrift.transport.TTransport;

public class ThriftReader {
    private String fileName;
    private TBaseCreator creator;
    private DataInputStream dataInputStream;
    private TProtocol binaryIn;
    private Configuration configuration;

    public ThriftReader(String fileName, TBaseCreator creator) {
        this.fileName = fileName;
        this.creator = creator;
    }

    public ThriftReader(String fileName, TBaseCreator creator, Configuration configuration) {
        this.fileName = fileName;
        this.configuration = configuration;
        this.creator = creator;
    }

    public ThriftReader(String fileName) {
        this.fileName = fileName;
    }

    public ThriftReader(String fileName, Configuration configuration) {
        this.fileName = fileName;
        this.configuration = configuration;
    }

    public ThriftReader(byte[] fileData) {
        this.dataInputStream = new DataInputStream(new ByteArrayInputStream(fileData));
        this.binaryIn = new TCompactProtocol((TTransport)new TIOStreamTransport((InputStream)this.dataInputStream));
    }

    public void open() throws IOException {
        Configuration conf = this.configuration != null ? this.configuration : FileFactory.getConfiguration();
        this.dataInputStream = FileFactory.getDataInputStream(this.fileName, conf);
        this.binaryIn = new TCompactProtocol((TTransport)new TIOStreamTransport((InputStream)this.dataInputStream));
    }

    public void setReadOffset(long bytesToSkip) throws IOException {
        if (this.dataInputStream instanceof FSDataInputStream) {
            ((FSDataInputStream)this.dataInputStream).seek(bytesToSkip);
        } else if (this.dataInputStream.skip(bytesToSkip) != bytesToSkip) {
            throw new IOException("It doesn't set the offset properly");
        }
    }

    public boolean hasNext() throws IOException {
        return this.dataInputStream.available() > 0;
    }

    public TBase read() throws IOException {
        TBase t = this.creator.create();
        try {
            t.read(this.binaryIn);
        }
        catch (TException e) {
            throw new IOException(e);
        }
        return t;
    }

    public TBase read(TBaseCreator creator) throws IOException {
        TBase t = creator.create();
        try {
            t.read(this.binaryIn);
        }
        catch (TException e) {
            throw new IOException(e);
        }
        return t;
    }

    public void close() {
        CarbonUtil.closeStreams(this.dataInputStream);
    }

    public static interface TBaseCreator {
        public TBase create();
    }
}

