/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.scan.collector;

import org.apache.carbondata.common.logging.LogServiceFactory;
import org.apache.carbondata.core.scan.collector.impl.AbstractScannedResultCollector;
import org.apache.carbondata.core.scan.collector.impl.DictionaryBasedResultCollector;
import org.apache.carbondata.core.scan.collector.impl.DictionaryBasedVectorResultCollector;
import org.apache.carbondata.core.scan.collector.impl.RawBasedResultCollector;
import org.apache.carbondata.core.scan.collector.impl.RestructureBasedDictionaryResultCollector;
import org.apache.carbondata.core.scan.collector.impl.RestructureBasedRawResultCollector;
import org.apache.carbondata.core.scan.collector.impl.RestructureBasedVectorResultCollector;
import org.apache.carbondata.core.scan.collector.impl.RowIdBasedResultCollector;
import org.apache.carbondata.core.scan.collector.impl.RowIdRawBasedResultCollector;
import org.apache.carbondata.core.scan.collector.impl.RowIdRestructureBasedRawResultCollector;
import org.apache.carbondata.core.scan.executor.infos.BlockExecutionInfo;
import org.apache.log4j.Logger;

public class ResultCollectorFactory {
    private static final Logger LOGGER = LogServiceFactory.getLogService((String)ResultCollectorFactory.class.getName());

    public static AbstractScannedResultCollector getScannedResultCollector(BlockExecutionInfo blockExecutionInfo) {
        AbstractScannedResultCollector scannerResultAggregator = null;
        if (blockExecutionInfo.isRawRecordDetailQuery()) {
            if (blockExecutionInfo.isRestructuredBlock()) {
                if (blockExecutionInfo.isRequiredRowId()) {
                    LOGGER.info((Object)"RowId Restructure based raw ollector is used to scan and collect the data");
                    scannerResultAggregator = new RowIdRestructureBasedRawResultCollector(blockExecutionInfo);
                } else {
                    LOGGER.info((Object)"Restructure based raw collector is used to scan and collect the data");
                    scannerResultAggregator = new RestructureBasedRawResultCollector(blockExecutionInfo);
                }
            } else if (blockExecutionInfo.isRequiredRowId()) {
                LOGGER.info((Object)"RowId based raw collector is used to scan and collect the data");
                scannerResultAggregator = new RowIdRawBasedResultCollector(blockExecutionInfo);
            } else {
                LOGGER.info((Object)"Row based raw collector is used to scan and collect the data");
                scannerResultAggregator = new RawBasedResultCollector(blockExecutionInfo);
            }
        } else if (blockExecutionInfo.isVectorBatchCollector()) {
            if (blockExecutionInfo.isRestructuredBlock()) {
                LOGGER.info((Object)"Restructure dictionary vector collector is used to scan and collect the data");
                scannerResultAggregator = new RestructureBasedVectorResultCollector(blockExecutionInfo);
            } else {
                LOGGER.info((Object)"Vector based dictionary collector is used to scan and collect the data");
                scannerResultAggregator = new DictionaryBasedVectorResultCollector(blockExecutionInfo);
            }
        } else if (blockExecutionInfo.isRestructuredBlock()) {
            LOGGER.info((Object)"Restructure based dictionary collector is used to scan and collect the data");
            scannerResultAggregator = new RestructureBasedDictionaryResultCollector(blockExecutionInfo);
        } else if (blockExecutionInfo.isRequiredRowId()) {
            LOGGER.info((Object)"RowId based dictionary collector is used to scan and collect the data");
            scannerResultAggregator = new RowIdBasedResultCollector(blockExecutionInfo);
        } else {
            LOGGER.info((Object)"Row based dictionary collector is used to scan and collect the data");
            scannerResultAggregator = new DictionaryBasedResultCollector(blockExecutionInfo);
        }
        return scannerResultAggregator;
    }

    private ResultCollectorFactory() {
    }
}

