/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.scan.collector.impl;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.List;
import org.apache.carbondata.core.datastore.page.ColumnPage;
import org.apache.carbondata.core.metadata.datatype.DataType;
import org.apache.carbondata.core.metadata.datatype.DataTypes;
import org.apache.carbondata.core.metadata.schema.table.column.CarbonMeasure;
import org.apache.carbondata.core.scan.collector.ScannedResultCollector;
import org.apache.carbondata.core.scan.executor.infos.BlockExecutionInfo;
import org.apache.carbondata.core.scan.executor.infos.DimensionInfo;
import org.apache.carbondata.core.scan.executor.infos.MeasureInfo;
import org.apache.carbondata.core.scan.model.ProjectionMeasure;
import org.apache.carbondata.core.scan.result.BlockletScannedResult;
import org.apache.carbondata.core.scan.result.vector.CarbonColumnarBatch;
import org.apache.carbondata.core.stats.QueryStatisticsModel;
import org.apache.carbondata.core.util.DataTypeUtil;

public abstract class AbstractScannedResultCollector
implements ScannedResultCollector {
    BlockExecutionInfo executionInfo;
    MeasureInfo measureInfo;
    DimensionInfo dimensionInfo;
    QueryStatisticsModel queryStatisticsModel;

    AbstractScannedResultCollector(BlockExecutionInfo blockExecutionInfos) {
        this.executionInfo = blockExecutionInfos;
        this.measureInfo = blockExecutionInfos.getMeasureInfo();
        this.dimensionInfo = blockExecutionInfos.getDimensionInfo();
        this.queryStatisticsModel = blockExecutionInfos.getQueryStatisticsModel();
    }

    protected void fillMeasureData(Object[] msrValues, int offset, BlockletScannedResult scannedResult) {
        int measureExistIndex = 0;
        for (int i = 0; i < this.measureInfo.getMeasureDataTypes().length; i = (int)((short)(i + 1))) {
            if (this.measureInfo.getMeasureExists()[i]) {
                ProjectionMeasure queryMeasure = this.executionInfo.getProjectionMeasures()[measureExistIndex];
                msrValues[i + offset] = this.getMeasureData(scannedResult.getMeasureChunk(this.measureInfo.getMeasureOrdinals()[measureExistIndex]), scannedResult.getCurrentRowId(), queryMeasure.getMeasure());
                ++measureExistIndex;
                continue;
            }
            Object defaultValue = this.measureInfo.getDefaultValues()[i];
            if (null != defaultValue && DataTypes.isDecimal(this.measureInfo.getMeasureDataTypes()[i])) {
                defaultValue = DataTypeUtil.getDataTypeConverter().convertFromBigDecimalToDecimal(defaultValue);
            }
            msrValues[i + offset] = defaultValue;
        }
    }

    protected void fillMeasureDataBatch(List<Object[]> rows, int offset, BlockletScannedResult scannedResult) {
        int measureExistIndex = 0;
        for (int i = 0; i < this.measureInfo.getMeasureDataTypes().length; i = (int)((short)(i + 1))) {
            if (this.measureInfo.getMeasureExists()[i]) {
                ProjectionMeasure queryMeasure = this.executionInfo.getProjectionMeasures()[measureExistIndex];
                ColumnPage measureChunk = scannedResult.getMeasureChunk(this.measureInfo.getMeasureOrdinals()[measureExistIndex]);
                for (int j = 0; j < rows.size(); j = (int)((short)(j + 1))) {
                    Object[] rowValues = rows.get(j);
                    rowValues[i + offset] = this.getMeasureData(measureChunk, scannedResult.getValidRowIds().get(j), queryMeasure.getMeasure());
                }
                ++measureExistIndex;
                continue;
            }
            Object defaultValue = this.measureInfo.getDefaultValues()[i];
            if (null != defaultValue && DataTypes.isDecimal(this.measureInfo.getMeasureDataTypes()[i])) {
                defaultValue = DataTypeUtil.getDataTypeConverter().convertFromBigDecimalToDecimal(defaultValue);
            }
            for (int j = 0; j < rows.size(); j = (int)((short)(j + 1))) {
                Object[] rowValues = rows.get(j);
                rowValues[i + offset] = defaultValue;
            }
        }
    }

    Object getMeasureData(ColumnPage dataChunk, int index, CarbonMeasure carbonMeasure) {
        if (!dataChunk.getNullBits().get(index)) {
            DataType dataType = carbonMeasure.getDataType();
            if (dataType == DataTypes.BOOLEAN) {
                return dataChunk.getBoolean(index);
            }
            if (dataType == DataTypes.SHORT) {
                return (short)dataChunk.getLong(index);
            }
            if (dataType == DataTypes.INT) {
                return (int)dataChunk.getLong(index);
            }
            if (dataType == DataTypes.LONG) {
                return dataChunk.getLong(index);
            }
            if (dataType == DataTypes.FLOAT) {
                return Float.valueOf(dataChunk.getFloat(index));
            }
            if (dataType == DataTypes.BYTE) {
                return dataChunk.getByte(index);
            }
            if (DataTypes.isDecimal(dataType)) {
                BigDecimal bigDecimalMsrValue = dataChunk.getDecimal(index);
                if (null != bigDecimalMsrValue && carbonMeasure.getScale() > bigDecimalMsrValue.scale()) {
                    bigDecimalMsrValue = bigDecimalMsrValue.setScale(carbonMeasure.getScale(), RoundingMode.HALF_UP);
                }
                return DataTypeUtil.getDataTypeConverter().convertFromBigDecimalToDecimal(bigDecimalMsrValue);
            }
            return dataChunk.getDouble(index);
        }
        return null;
    }

    @Override
    public void collectResultInColumnarBatch(BlockletScannedResult scannedResult, CarbonColumnarBatch columnarBatch) {
        throw new UnsupportedOperationException("Works only for batch collectors");
    }
}

