/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.scan.collector.impl;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.carbondata.core.keygenerator.directdictionary.DirectDictionaryGenerator;
import org.apache.carbondata.core.keygenerator.directdictionary.DirectDictionaryKeyGeneratorFactory;
import org.apache.carbondata.core.metadata.datatype.DataTypes;
import org.apache.carbondata.core.metadata.schema.table.column.CarbonDimension;
import org.apache.carbondata.core.scan.collector.impl.AbstractScannedResultCollector;
import org.apache.carbondata.core.scan.complextypes.StructQueryType;
import org.apache.carbondata.core.scan.executor.infos.BlockExecutionInfo;
import org.apache.carbondata.core.scan.filter.GenericQueryType;
import org.apache.carbondata.core.scan.model.ProjectionDimension;
import org.apache.carbondata.core.scan.model.ProjectionMeasure;
import org.apache.carbondata.core.scan.result.BlockletScannedResult;
import org.apache.carbondata.core.util.CarbonUtil;
import org.apache.carbondata.core.util.DataTypeUtil;
import org.apache.commons.lang3.ArrayUtils;

public class DictionaryBasedResultCollector
extends AbstractScannedResultCollector {
    protected ProjectionDimension[] queryDimensions;
    protected ProjectionMeasure[] queryMeasures;
    private DirectDictionaryGenerator[] directDictionaryGenerators;
    protected int[] order;
    private int[] actualIndexInSurrogateKey;
    private boolean[] implicitColumnArray;
    private boolean[] complexDataTypeArray;
    int dictionaryColumnIndex;
    int noDictionaryColumnIndex;
    int complexTypeColumnIndex;
    boolean isDimensionExists;
    private int[] surrogateResult;
    private byte[][] noDictionaryKeys;
    private byte[][] complexTypeKeyArray;
    protected Map<Integer, GenericQueryType> comlexDimensionInfoMap;
    private Map<Integer, List<Integer>> parentToChildColumnsMap = new HashMap<Integer, List<Integer>>();
    private List<Integer> queryDimensionToComplexParentOrdinal = new ArrayList<Integer>();
    private Map<Integer, Map<CarbonDimension, ByteBuffer>> mergedComplexDimensionIndex = new HashMap<Integer, Map<CarbonDimension, ByteBuffer>>();
    private boolean readOnlyDelta;

    public DictionaryBasedResultCollector(BlockExecutionInfo blockExecutionInfos) {
        super(blockExecutionInfos);
        this.queryDimensions = this.executionInfo.getProjectionDimensions();
        this.queryMeasures = this.executionInfo.getProjectionMeasures();
        this.initDimensionAndMeasureIndexesForFillingData();
        this.isDimensionExists = this.queryDimensions.length > 0;
        this.comlexDimensionInfoMap = this.executionInfo.getComlexDimensionInfoMap();
        this.readOnlyDelta = this.executionInfo.isReadOnlyDelta();
    }

    @Override
    public List<Object[]> collectResultInRow(BlockletScannedResult scannedResult, int batchSize) {
        ArrayList<Object[]> listBasedResult = new ArrayList<Object[]>(batchSize);
        int rowCounter = 0;
        boolean isStructQueryType = false;
        for (GenericQueryType genericQueryType : scannedResult.complexParentIndexToQueryMap.values()) {
            if (!(genericQueryType instanceof StructQueryType)) continue;
            isStructQueryType = true;
            break;
        }
        boolean[] isComplexChildColumn = null;
        if (isStructQueryType) {
            isComplexChildColumn = new boolean[this.queryDimensions.length + this.queryMeasures.length];
            for (ProjectionDimension dimension : this.queryDimensions) {
                if (null == dimension.getDimension().getComplexParentDimension()) continue;
                isComplexChildColumn[dimension.getOrdinal()] = true;
            }
        }
        while (scannedResult.hasNext() && rowCounter < batchSize) {
            scannedResult.incrementCounter();
            if (this.readOnlyDelta ? !scannedResult.containsDeletedRow(scannedResult.getCurrentRowId()) && scannedResult.getCurrentDeleteDeltaVo() != null : scannedResult.containsDeletedRow(scannedResult.getCurrentRowId())) continue;
            Object[] objectArray = new Object[this.queryDimensions.length + this.queryMeasures.length];
            if (this.isDimensionExists) {
                this.surrogateResult = scannedResult.getDictionaryKeyIntegerArray();
                this.noDictionaryKeys = scannedResult.getNoDictionaryKeyArray();
                this.complexTypeKeyArray = scannedResult.getComplexTypeKeyArray();
                this.dictionaryColumnIndex = 0;
                this.noDictionaryColumnIndex = 0;
                this.complexTypeColumnIndex = 0;
                this.fillComplexColumnDataBufferForThisRow();
                for (int i = 0; i < this.queryDimensions.length; ++i) {
                    this.fillDimensionData(scannedResult, this.surrogateResult, this.noDictionaryKeys, this.complexTypeKeyArray, this.comlexDimensionInfoMap, objectArray, i, this.queryDimensions[i].getDimension().getOrdinal());
                }
            }
            this.fillMeasureData(scannedResult, objectArray);
            if (isStructQueryType) {
                this.shiftNullForStruct(objectArray, isComplexChildColumn);
            }
            listBasedResult.add(objectArray);
            ++rowCounter;
        }
        return listBasedResult;
    }

    private void shiftNullForStruct(Object[] row, boolean[] isComplexChildColumn) {
        int count = 0;
        for (int j = 0; j < row.length; ++j) {
            if (null == row[j] && !isComplexChildColumn[j]) {
                row[count++] = null;
                continue;
            }
            if (null == row[j]) continue;
            row[count++] = row[j];
        }
        while (count < row.length) {
            row[count++] = null;
        }
    }

    private void fillComplexColumnDataBufferForThisRow() {
        this.mergedComplexDimensionIndex.clear();
        int noDictionaryComplexColumnIndex = 0;
        int complexTypeComplexColumnIndex = 0;
        for (int i = 0; i < this.queryDimensions.length; ++i) {
            int complexParentOrdinal = this.queryDimensionToComplexParentOrdinal.get(i);
            if (complexParentOrdinal != -1) {
                ByteBuffer buffer;
                Map<Object, Object> childColumnByteBuffer = this.mergedComplexDimensionIndex.get(complexParentOrdinal) == null ? new HashMap() : this.mergedComplexDimensionIndex.get(complexParentOrdinal);
                if (this.queryDimensions[i].getDimension().getDataType() != DataTypes.DATE) {
                    if (this.implicitColumnArray[i]) {
                        throw new RuntimeException("Not Supported Column Type");
                    }
                    buffer = this.complexDataTypeArray[i] ? ByteBuffer.wrap(this.complexTypeKeyArray[complexTypeComplexColumnIndex++]) : ByteBuffer.wrap(this.noDictionaryKeys[noDictionaryComplexColumnIndex++]);
                } else {
                    if (this.queryDimensions[i].getDimension().getDataType() == DataTypes.DATE) {
                        throw new RuntimeException("Direct Dictionary Column Type Not Supported Yet.");
                    }
                    if (this.complexDataTypeArray[i]) {
                        buffer = ByteBuffer.wrap(this.complexTypeKeyArray[complexTypeComplexColumnIndex++]);
                    } else {
                        throw new RuntimeException("Not Supported Column Type");
                    }
                }
                childColumnByteBuffer.put(this.queryDimensions[i].getDimension(), buffer);
                this.mergedComplexDimensionIndex.put(complexParentOrdinal, childColumnByteBuffer);
                continue;
            }
            if (this.queryDimensions[i].getDimension().isComplex().booleanValue()) continue;
            ++noDictionaryComplexColumnIndex;
        }
    }

    void fillDimensionData(BlockletScannedResult scannedResult, int[] surrogateResult, byte[][] noDictionaryKeys, byte[][] complexTypeKeyArray, Map<Integer, GenericQueryType> complexDimensionInfoMap, Object[] row, int i, int actualOrdinal) {
        if (this.queryDimensions[i].getDimension().getDataType() != DataTypes.DATE) {
            if (this.implicitColumnArray[i]) {
                row[this.order[i]] = "tupleId".equals(this.queryDimensions[i].getColumnName()) ? DataTypeUtil.getDataBasedOnDataType(scannedResult.getBlockletId() + "/" + scannedResult.getCurrentPageCounter() + "/" + scannedResult.getCurrentRowId(), DataTypes.STRING) : DataTypeUtil.getDataBasedOnDataType(scannedResult.getBlockletId(), DataTypes.STRING);
            } else if (this.complexDataTypeArray[i]) {
                if (this.queryDimensionToComplexParentOrdinal.get(i) != -1) {
                    this.fillRow(complexDimensionInfoMap, row, i, ByteBuffer.wrap(complexTypeKeyArray[this.complexTypeColumnIndex++]));
                } else {
                    row[this.order[i]] = complexDimensionInfoMap.get(actualOrdinal).getDataBasedOnDataType(ByteBuffer.wrap(complexTypeKeyArray[this.complexTypeColumnIndex++]));
                }
            } else if (this.queryDimensionToComplexParentOrdinal.get(i) != -1) {
                this.fillRow(complexDimensionInfoMap, row, i, ByteBuffer.wrap(noDictionaryKeys[this.noDictionaryColumnIndex++]));
            } else {
                row[this.order[i]] = DataTypeUtil.getDataBasedOnDataTypeForNoDictionaryColumn(noDictionaryKeys[this.noDictionaryColumnIndex++], this.queryDimensions[i].getDimension().getDataType());
            }
        } else if (this.queryDimensions[i].getDimension().getDataType() == DataTypes.DATE) {
            if (this.directDictionaryGenerators[i] != null) {
                row[this.order[i]] = this.directDictionaryGenerators[i].getValueFromSurrogate(surrogateResult[this.actualIndexInSurrogateKey[this.dictionaryColumnIndex++]]);
            }
        } else if (this.complexDataTypeArray[i]) {
            row[this.order[i]] = complexDimensionInfoMap.get(actualOrdinal).getDataBasedOnDataType(ByteBuffer.wrap(complexTypeKeyArray[this.complexTypeColumnIndex++]));
            ++this.dictionaryColumnIndex;
        } else {
            row[this.order[i]] = surrogateResult[this.actualIndexInSurrogateKey[this.dictionaryColumnIndex++]];
        }
    }

    private void fillRow(Map<Integer, GenericQueryType> complexDimensionInfoMap, Object[] row, int i, ByteBuffer wrap) {
        if (this.parentToChildColumnsMap.get(this.queryDimensionToComplexParentOrdinal.get(i)).size() > 1) {
            this.fillRowForComplexColumn(complexDimensionInfoMap, row, i);
        } else {
            row[this.order[i]] = complexDimensionInfoMap.get(this.queryDimensionToComplexParentOrdinal.get(i)).getDataBasedOnColumn(wrap, this.queryDimensions[i].getDimension().getComplexParentDimension(), this.queryDimensions[i].getDimension());
        }
    }

    private void fillRowForComplexColumn(Map<Integer, GenericQueryType> complexDimensionInfoMap, Object[] row, int i) {
        int complexParentOrdinal = this.queryDimensionToComplexParentOrdinal.get(i);
        List<Integer> childColumns = this.parentToChildColumnsMap.get(complexParentOrdinal);
        row[this.order[i]] = childColumns.get(0).equals(this.queryDimensions[i].getDimension().getOrdinal()) ? complexDimensionInfoMap.get(complexParentOrdinal).getDataBasedOnColumnList(this.mergedComplexDimensionIndex.get(this.queryDimensions[i].getParentDimension().getOrdinal()), this.queryDimensions[i].getParentDimension()) : null;
    }

    void fillMeasureData(BlockletScannedResult scannedResult, Object[] row) {
        if (this.measureInfo.getMeasureDataTypes().length > 0) {
            Object[] msrValues = new Object[this.measureInfo.getMeasureDataTypes().length];
            this.fillMeasureData(msrValues, 0, scannedResult);
            for (int i = 0; i < msrValues.length; ++i) {
                row[this.order[i + this.queryDimensions.length]] = msrValues[i];
            }
        }
    }

    void initDimensionAndMeasureIndexesForFillingData() {
        int i;
        ArrayList<Integer> dictionaryIndexes = new ArrayList<Integer>();
        for (int i2 = 0; i2 < this.queryDimensions.length; ++i2) {
            if (this.queryDimensions[i2].getDimension().getDataType() != DataTypes.DATE) continue;
            dictionaryIndexes.add(this.queryDimensions[i2].getDimension().getOrdinal());
        }
        int[] primitive = ArrayUtils.toPrimitive((Integer[])dictionaryIndexes.toArray(new Integer[dictionaryIndexes.size()]));
        Arrays.sort(primitive);
        this.actualIndexInSurrogateKey = new int[dictionaryIndexes.size()];
        int index = 0;
        this.implicitColumnArray = CarbonUtil.getImplicitColumnArray(this.queryDimensions);
        this.complexDataTypeArray = CarbonUtil.getComplexDataTypeArray(this.queryDimensions);
        this.parentToChildColumnsMap.clear();
        this.queryDimensionToComplexParentOrdinal.clear();
        for (i = 0; i < this.queryDimensions.length; ++i) {
            if (this.queryDimensions[i].getDimension().getDataType() == DataTypes.DATE) {
                this.actualIndexInSurrogateKey[index++] = Arrays.binarySearch(primitive, this.queryDimensions[i].getDimension().getOrdinal());
            }
            if (null != this.queryDimensions[i].getDimension().getComplexParentDimension()) {
                List<Object> childOrdinals;
                int complexParentOrdinal = this.queryDimensions[i].getDimension().getComplexParentDimension().getOrdinal();
                this.queryDimensionToComplexParentOrdinal.add(complexParentOrdinal);
                if (this.parentToChildColumnsMap.get(complexParentOrdinal) == null) {
                    childOrdinals = new ArrayList<Integer>();
                    childOrdinals.add(this.queryDimensions[i].getDimension().getOrdinal());
                    this.parentToChildColumnsMap.put(complexParentOrdinal, childOrdinals);
                    continue;
                }
                childOrdinals = this.parentToChildColumnsMap.get(complexParentOrdinal);
                childOrdinals.add(this.queryDimensions[i].getDimension().getOrdinal());
                this.parentToChildColumnsMap.put(complexParentOrdinal, childOrdinals);
                continue;
            }
            this.queryDimensionToComplexParentOrdinal.add(-1);
        }
        this.order = new int[this.queryDimensions.length + this.queryMeasures.length];
        for (i = 0; i < this.queryDimensions.length; ++i) {
            this.order[i] = this.queryDimensions[i].getOrdinal();
        }
        for (i = 0; i < this.queryMeasures.length; ++i) {
            this.order[i + this.queryDimensions.length] = this.queryMeasures[i].getOrdinal();
        }
        this.directDictionaryGenerators = new DirectDictionaryGenerator[this.queryDimensions.length];
        for (i = 0; i < this.queryDimensions.length; ++i) {
            this.directDictionaryGenerators[i] = DirectDictionaryKeyGeneratorFactory.getDirectDictionaryGenerator(this.queryDimensions[i].getDimension().getDataType());
        }
    }
}

