/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.scan.collector.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.List;
import org.apache.carbondata.common.logging.LogServiceFactory;
import org.apache.carbondata.core.keygenerator.directdictionary.DirectDictionaryKeyGeneratorFactory;
import org.apache.carbondata.core.metadata.datatype.DataTypes;
import org.apache.carbondata.core.metadata.encoder.Encoding;
import org.apache.carbondata.core.mutate.DeleteDeltaVo;
import org.apache.carbondata.core.scan.collector.impl.AbstractScannedResultCollector;
import org.apache.carbondata.core.scan.executor.infos.BlockExecutionInfo;
import org.apache.carbondata.core.scan.model.ProjectionDimension;
import org.apache.carbondata.core.scan.model.ProjectionMeasure;
import org.apache.carbondata.core.scan.result.BlockletScannedResult;
import org.apache.carbondata.core.scan.result.vector.CarbonColumnarBatch;
import org.apache.carbondata.core.scan.result.vector.ColumnVectorInfo;
import org.apache.carbondata.core.scan.result.vector.MeasureDataVectorProcessor;
import org.apache.log4j.Logger;

public class DictionaryBasedVectorResultCollector
extends AbstractScannedResultCollector {
    private static final Logger LOGGER = LogServiceFactory.getLogService((String)DictionaryBasedVectorResultCollector.class.getName());
    protected ProjectionDimension[] queryDimensions;
    protected ProjectionMeasure[] queryMeasures;
    private ColumnVectorInfo[] dictionaryInfo;
    private ColumnVectorInfo[] noDictionaryInfo;
    private ColumnVectorInfo[] complexInfo;
    private ColumnVectorInfo[] measureColumnInfo;
    ColumnVectorInfo[] allColumnInfo;
    private ColumnVectorInfo[] implicitColumnInfo;
    private boolean isDirectVectorFill;

    public DictionaryBasedVectorResultCollector(BlockExecutionInfo blockExecutionInfos) {
        super(blockExecutionInfos);
        this.isDirectVectorFill = blockExecutionInfos.isDirectVectorFill();
        if (this.isDirectVectorFill) {
            LOGGER.info((Object)"Direct pagewise vector fill collector is used to scan and collect the data");
        }
        if (!blockExecutionInfos.isRestructuredBlock()) {
            this.queryDimensions = this.executionInfo.getProjectionDimensions();
            this.queryMeasures = this.executionInfo.getProjectionMeasures();
            this.allColumnInfo = new ColumnVectorInfo[this.queryDimensions.length + this.queryMeasures.length];
            this.prepareDimensionAndMeasureColumnVectors();
        }
    }

    void prepareDimensionAndMeasureColumnVectors() {
        this.measureColumnInfo = new ColumnVectorInfo[this.queryMeasures.length];
        ArrayList<ColumnVectorInfo> dictInfoList = new ArrayList<ColumnVectorInfo>();
        ArrayList<ColumnVectorInfo> noDictInfoList = new ArrayList<ColumnVectorInfo>();
        ArrayList<ColumnVectorInfo> complexList = new ArrayList<ColumnVectorInfo>();
        ArrayList<ColumnVectorInfo> implicitColumnList = new ArrayList<ColumnVectorInfo>();
        for (int i = 0; i < this.queryDimensions.length; ++i) {
            ColumnVectorInfo columnVectorInfo;
            if (!this.dimensionInfo.getDimensionExists()[i]) continue;
            if (this.queryDimensions[i].getDimension().hasEncoding(Encoding.IMPLICIT)) {
                columnVectorInfo = new ColumnVectorInfo();
                implicitColumnList.add(columnVectorInfo);
                columnVectorInfo.dimension = this.queryDimensions[i];
                columnVectorInfo.ordinal = this.queryDimensions[i].getDimension().getOrdinal();
                this.allColumnInfo[this.queryDimensions[i].getOrdinal()] = columnVectorInfo;
                continue;
            }
            if (this.queryDimensions[i].getDimension().getDataType() != DataTypes.DATE) {
                columnVectorInfo = new ColumnVectorInfo();
                noDictInfoList.add(columnVectorInfo);
                columnVectorInfo.dimension = this.queryDimensions[i];
                columnVectorInfo.ordinal = this.queryDimensions[i].getDimension().getOrdinal();
                this.allColumnInfo[this.queryDimensions[i].getOrdinal()] = columnVectorInfo;
                continue;
            }
            if (this.queryDimensions[i].getDimension().getDataType() == DataTypes.DATE) {
                columnVectorInfo = new ColumnVectorInfo();
                dictInfoList.add(columnVectorInfo);
                columnVectorInfo.dimension = this.queryDimensions[i];
                columnVectorInfo.directDictionaryGenerator = DirectDictionaryKeyGeneratorFactory.getDirectDictionaryGenerator(this.queryDimensions[i].getDimension().getDataType());
                columnVectorInfo.ordinal = this.queryDimensions[i].getDimension().getOrdinal();
                this.allColumnInfo[this.queryDimensions[i].getOrdinal()] = columnVectorInfo;
                continue;
            }
            if (this.queryDimensions[i].getDimension().isComplex().booleanValue()) {
                columnVectorInfo = new ColumnVectorInfo();
                complexList.add(columnVectorInfo);
                columnVectorInfo.dimension = this.queryDimensions[i];
                columnVectorInfo.ordinal = this.queryDimensions[i].getDimension().getOrdinal();
                columnVectorInfo.genericQueryType = this.executionInfo.getComlexDimensionInfoMap().get(columnVectorInfo.ordinal);
                this.allColumnInfo[this.queryDimensions[i].getOrdinal()] = columnVectorInfo;
                continue;
            }
            columnVectorInfo = new ColumnVectorInfo();
            dictInfoList.add(columnVectorInfo);
            columnVectorInfo.dimension = this.queryDimensions[i];
            columnVectorInfo.ordinal = this.queryDimensions[i].getDimension().getOrdinal();
            this.allColumnInfo[this.queryDimensions[i].getOrdinal()] = columnVectorInfo;
        }
        int j = 0;
        for (int i = 0; i < this.queryMeasures.length; ++i) {
            if (!this.measureInfo.getMeasureExists()[i]) continue;
            ColumnVectorInfo columnVectorInfo = new ColumnVectorInfo();
            columnVectorInfo.measureVectorFiller = MeasureDataVectorProcessor.MeasureVectorFillerFactory.getMeasureVectorFiller(this.queryMeasures[i].getMeasure().getDataType());
            columnVectorInfo.ordinal = this.queryMeasures[i].getMeasure().getOrdinal();
            columnVectorInfo.measure = this.queryMeasures[i];
            this.measureColumnInfo[j++] = columnVectorInfo;
            this.allColumnInfo[this.queryMeasures[i].getOrdinal()] = columnVectorInfo;
        }
        this.dictionaryInfo = dictInfoList.toArray(new ColumnVectorInfo[dictInfoList.size()]);
        this.noDictionaryInfo = noDictInfoList.toArray(new ColumnVectorInfo[noDictInfoList.size()]);
        this.complexInfo = complexList.toArray(new ColumnVectorInfo[complexList.size()]);
        this.implicitColumnInfo = implicitColumnList.toArray(new ColumnVectorInfo[implicitColumnList.size()]);
        Arrays.sort(this.dictionaryInfo);
        Arrays.sort(this.complexInfo);
    }

    @Override
    public List<Object[]> collectResultInRow(BlockletScannedResult scannedResult, int batchSize) {
        throw new UnsupportedOperationException("collectResultInRow is not supported here");
    }

    @Override
    public void collectResultInColumnarBatch(BlockletScannedResult scannedResult, CarbonColumnarBatch columnarBatch) {
        if (this.isDirectVectorFill) {
            this.collectResultInColumnarBatchDirect(scannedResult, columnarBatch);
        } else {
            int numberOfPages = scannedResult.numberOfpages();
            int filteredRows = 0;
            while (scannedResult.getCurrentPageCounter() < numberOfPages) {
                int currentPageRowCount = scannedResult.getCurrentPageRowCount();
                if (currentPageRowCount == 0) {
                    scannedResult.incrementPageCounter();
                    continue;
                }
                int rowCounter = scannedResult.getRowCounter();
                int availableRows = currentPageRowCount - rowCounter;
                int requiredRows = columnarBatch.getBatchSize() - columnarBatch.getRowCounter();
                if ((requiredRows = Math.min(requiredRows, availableRows)) < 1) {
                    return;
                }
                this.fillColumnVectorDetails(columnarBatch, rowCounter, requiredRows);
                filteredRows = scannedResult.markFilteredRows(columnarBatch, rowCounter, requiredRows, columnarBatch.getRowCounter());
                this.fillResultToColumnarBatch(scannedResult, columnarBatch, rowCounter, availableRows, requiredRows);
                columnarBatch.setActualSize(columnarBatch.getActualSize() + requiredRows - filteredRows);
            }
        }
    }

    void fillResultToColumnarBatch(BlockletScannedResult scannedResult, CarbonColumnarBatch columnarBatch, int rowCounter, int availableRows, int requiredRows) {
        scannedResult.fillColumnarDictionaryBatch(this.dictionaryInfo);
        scannedResult.fillColumnarNoDictionaryBatch(this.noDictionaryInfo);
        scannedResult.fillColumnarMeasureBatch(this.measureColumnInfo, this.measureInfo.getMeasureOrdinals());
        scannedResult.fillColumnarComplexBatch(this.complexInfo);
        scannedResult.fillColumnarImplicitBatch(this.implicitColumnInfo);
        if (availableRows == requiredRows) {
            scannedResult.incrementPageCounter();
        } else {
            scannedResult.setRowCounter(rowCounter + requiredRows);
        }
        columnarBatch.setRowCounter(columnarBatch.getRowCounter() + requiredRows);
    }

    void fillColumnVectorDetails(CarbonColumnarBatch columnarBatch, int rowCount, int requiredRows) {
        for (int i = 0; i < this.allColumnInfo.length; ++i) {
            this.allColumnInfo[i].size = requiredRows;
            this.allColumnInfo[i].offset = rowCount;
            this.allColumnInfo[i].vectorOffset = columnarBatch.getRowCounter();
            this.allColumnInfo[i].vector = columnarBatch.columnVectors[i];
            if (null == this.allColumnInfo[i].dimension) continue;
            this.allColumnInfo[i].vector.setBlockDataType(this.dimensionInfo.dataType[i]);
        }
    }

    private void collectResultInColumnarBatchDirect(BlockletScannedResult scannedResult, CarbonColumnarBatch columnarBatch) {
        int numberOfPages = scannedResult.numberOfpages();
        while (scannedResult.getCurrentPageCounter() < numberOfPages) {
            int currentPageRowCount = scannedResult.getCurrentPageRowCount();
            if (currentPageRowCount == 0) {
                scannedResult.incrementPageCounter(null);
                continue;
            }
            DeleteDeltaVo deltaVo = scannedResult.getCurrentDeleteDeltaVo();
            BitSet bitSet = null;
            int deletedRows = 0;
            if (deltaVo != null) {
                bitSet = deltaVo.getBitSet();
                deletedRows = bitSet.cardinality();
            }
            this.fillColumnVectorDetails(columnarBatch, bitSet);
            this.fillResultToColumnarBatch(scannedResult);
            columnarBatch.setActualSize(currentPageRowCount - deletedRows);
            scannedResult.setRowCounter(currentPageRowCount - deletedRows);
            scannedResult.incrementPageCounter(null);
            return;
        }
    }

    private void fillResultToColumnarBatch(BlockletScannedResult scannedResult) {
        scannedResult.fillDataChunks(this.dictionaryInfo, this.noDictionaryInfo, this.measureColumnInfo, this.measureInfo.getMeasureOrdinals());
    }

    private void fillColumnVectorDetails(CarbonColumnarBatch columnarBatch, BitSet deltaBitSet) {
        for (int i = 0; i < this.allColumnInfo.length; ++i) {
            this.allColumnInfo[i].vectorOffset = columnarBatch.getRowCounter();
            this.allColumnInfo[i].vector = columnarBatch.columnVectors[i];
            this.allColumnInfo[i].deletedRows = deltaBitSet;
            if (null == this.allColumnInfo[i].dimension) continue;
            this.allColumnInfo[i].vector.setBlockDataType(this.dimensionInfo.dataType[i]);
        }
    }
}

