/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.scan.collector.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.carbondata.core.metadata.datatype.DataTypes;
import org.apache.carbondata.core.scan.collector.impl.DictionaryBasedResultCollector;
import org.apache.carbondata.core.scan.executor.infos.BlockExecutionInfo;
import org.apache.carbondata.core.scan.executor.util.RestructureUtil;
import org.apache.carbondata.core.scan.filter.GenericQueryType;
import org.apache.carbondata.core.scan.model.ProjectionMeasure;
import org.apache.carbondata.core.scan.result.BlockletScannedResult;
import org.apache.carbondata.core.util.DataTypeUtil;

public class RestructureBasedDictionaryResultCollector
extends DictionaryBasedResultCollector {
    private Object[] measureDefaultValues = null;

    public RestructureBasedDictionaryResultCollector(BlockExecutionInfo blockExecutionInfos) {
        super(blockExecutionInfos);
        this.queryDimensions = this.executionInfo.getActualQueryDimensions();
        this.queryMeasures = this.executionInfo.getActualQueryMeasures();
        this.measureDefaultValues = new Object[this.queryMeasures.length];
        this.fillMeasureDefaultValues();
        this.initDimensionAndMeasureIndexesForFillingData();
        this.isDimensionExists = this.queryDimensions.length > 0;
    }

    private void fillMeasureDefaultValues() {
        for (int i = 0; i < this.queryMeasures.length; ++i) {
            if (this.measureInfo.getMeasureExists()[i]) continue;
            this.measureDefaultValues[i] = RestructureUtil.getMeasureDefaultValueByType(this.queryMeasures[i].getMeasure().getColumnSchema(), this.queryMeasures[i].getMeasure().getDefaultValue());
        }
    }

    @Override
    public List<Object[]> collectResultInRow(BlockletScannedResult scannedResult, int batchSize) {
        ArrayList<Object[]> listBasedResult = new ArrayList<Object[]>(batchSize);
        int rowCounter = 0;
        Map<Integer, GenericQueryType> comlexDimensionInfoMap = this.executionInfo.getComlexDimensionInfoMap();
        while (scannedResult.hasNext() && rowCounter < batchSize) {
            scannedResult.incrementCounter();
            if (scannedResult.containsDeletedRow(scannedResult.getCurrentRowId())) continue;
            Object[] row = new Object[this.queryDimensions.length + this.queryMeasures.length];
            if (this.isDimensionExists) {
                int[] surrogateResult = scannedResult.getDictionaryKeyIntegerArray();
                byte[][] noDictionaryKeys = scannedResult.getNoDictionaryKeyArray();
                byte[][] complexTypeKeyArray = scannedResult.getComplexTypeKeyArray();
                this.dictionaryColumnIndex = 0;
                this.noDictionaryColumnIndex = 0;
                this.complexTypeColumnIndex = 0;
                int segmentDimensionsIdx = 0;
                for (int i = 0; i < this.queryDimensions.length; ++i) {
                    if (!this.dimensionInfo.getDimensionExists()[i]) {
                        if (this.queryDimensions[i].getDimension().getDataType() == DataTypes.DATE) {
                            row[this.order[i]] = this.dimensionInfo.getDefaultValues()[i];
                            ++this.dictionaryColumnIndex;
                            continue;
                        }
                        if (this.queryDimensions[i].getDimension().getDataType() == DataTypes.STRING) {
                            row[this.order[i]] = DataTypeUtil.getDataTypeConverter().convertFromByteToUTF8String((byte[])this.dimensionInfo.getDefaultValues()[i]);
                            continue;
                        }
                        row[this.order[i]] = this.dimensionInfo.getDefaultValues()[i];
                        continue;
                    }
                    this.fillDimensionData(scannedResult, surrogateResult, noDictionaryKeys, complexTypeKeyArray, comlexDimensionInfoMap, row, i, this.executionInfo.getProjectionDimensions()[segmentDimensionsIdx++].getDimension().getOrdinal());
                }
            }
            this.fillMeasureData(scannedResult, row);
            listBasedResult.add(row);
            ++rowCounter;
        }
        return listBasedResult;
    }

    @Override
    protected void fillMeasureData(Object[] msrValues, int offset, BlockletScannedResult scannedResult) {
        int measureExistIndex = 0;
        for (int i = 0; i < this.measureInfo.getMeasureDataTypes().length; i = (int)((short)(i + 1))) {
            if (this.measureInfo.getMeasureExists()[i]) {
                ProjectionMeasure queryMeasure = this.executionInfo.getProjectionMeasures()[measureExistIndex];
                msrValues[i + offset] = this.getMeasureData(scannedResult.getMeasureChunk(this.measureInfo.getMeasureOrdinals()[measureExistIndex]), scannedResult.getCurrentRowId(), queryMeasure.getMeasure());
                ++measureExistIndex;
                continue;
            }
            msrValues[i + offset] = DataTypes.isDecimal(this.measureInfo.getMeasureDataTypes()[i]) ? DataTypeUtil.getDataTypeConverter().convertFromBigDecimalToDecimal(this.measureDefaultValues[i]) : this.measureDefaultValues[i];
        }
    }
}

