/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.scan.collector.impl;

import java.util.ArrayList;
import java.util.List;
import org.apache.carbondata.core.constants.CarbonCommonConstants;
import org.apache.carbondata.core.metadata.datatype.DataTypes;
import org.apache.carbondata.core.metadata.encoder.Encoding;
import org.apache.carbondata.core.scan.collector.impl.RawBasedResultCollector;
import org.apache.carbondata.core.scan.executor.infos.BlockExecutionInfo;
import org.apache.carbondata.core.scan.model.ProjectionDimension;
import org.apache.carbondata.core.scan.model.ProjectionMeasure;
import org.apache.carbondata.core.scan.result.BlockletScannedResult;
import org.apache.carbondata.core.scan.wrappers.ByteArrayWrapper;
import org.apache.carbondata.core.stats.QueryStatistic;
import org.apache.carbondata.core.util.ByteUtil;
import org.apache.carbondata.core.util.DataTypeUtil;

public class RestructureBasedRawResultCollector
extends RawBasedResultCollector {
    public RestructureBasedRawResultCollector(BlockExecutionInfo blockExecutionInfos) {
        super(blockExecutionInfos);
    }

    @Override
    public List<Object[]> collectResultInRow(BlockletScannedResult scannedResult, int batchSize) {
        long startTime = System.currentTimeMillis();
        ArrayList<Object[]> listBasedResult = new ArrayList<Object[]>(batchSize);
        ProjectionMeasure[] queryMeasures = this.executionInfo.getActualQueryMeasures();
        this.scanAndFillData(scannedResult, batchSize, listBasedResult, queryMeasures);
        if (this.dimensionInfo.isDictionaryColumnAdded()) {
            this.fillDictionaryKeyArrayBatchWithLatestSchema(listBasedResult);
        }
        if (this.dimensionInfo.isNoDictionaryColumnAdded()) {
            this.fillNoDictionaryKeyArrayBatchWithLatestSchema(listBasedResult);
        }
        QueryStatistic resultPrepTime = this.queryStatisticsModel.getStatisticsTypeAndObjMap().get("result preparation time");
        resultPrepTime.addCountStatistic("result preparation time", resultPrepTime.getCount() + (System.currentTimeMillis() - startTime));
        return listBasedResult;
    }

    private void fillDictionaryKeyArrayBatchWithLatestSchema(List<Object[]> rows) {
        for (Object[] row : rows) {
            ByteArrayWrapper byteArrayWrapper = (ByteArrayWrapper)row[0];
            byte[] dictKeyArray = byteArrayWrapper.getDictionaryKey();
            ProjectionDimension[] actualQueryDimensions = this.executionInfo.getActualQueryDimensions();
            int newKeyArrayLength = this.dimensionInfo.getNewDictionaryColumnCount();
            long[] keyArray = null;
            if (this.executionInfo.getDataBlock().getSegmentProperties().getNumberOfDictDimensions() > 0) {
                keyArray = ByteUtil.convertBytesToLongArray(dictKeyArray);
                newKeyArrayLength += keyArray.length;
            }
            long[] keyArrayWithNewAddedColumns = new long[newKeyArrayLength];
            int existingColumnKeyArrayIndex = 0;
            int newKeyArrayIndex = 0;
            for (int i = 0; i < this.dimensionInfo.getDimensionExists().length; ++i) {
                if (actualQueryDimensions[i].getDimension().getDataType() != DataTypes.DATE) continue;
                if (this.dimensionInfo.getDimensionExists()[i] && null != keyArray && 0 != keyArray.length) {
                    keyArrayWithNewAddedColumns[newKeyArrayIndex++] = keyArray[existingColumnKeyArrayIndex++];
                    continue;
                }
                Object defaultValue = this.dimensionInfo.getDefaultValues()[i];
                long defaultValueAsLong = null != defaultValue ? ((Integer)defaultValue).longValue() : 1L;
                keyArrayWithNewAddedColumns[newKeyArrayIndex++] = defaultValueAsLong;
            }
            dictKeyArray = ByteUtil.convertLongArrayToBytes(keyArrayWithNewAddedColumns);
            byteArrayWrapper.setDictionaryKey(dictKeyArray);
        }
    }

    private void fillNoDictionaryKeyArrayBatchWithLatestSchema(List<Object[]> rows) {
        for (Object[] row : rows) {
            ByteArrayWrapper byteArrayWrapper = (ByteArrayWrapper)row[0];
            byte[][] noDictKeyArray = byteArrayWrapper.getNoDictionaryKeys();
            ProjectionDimension[] actualQueryDimensions = this.executionInfo.getActualQueryDimensions();
            byte[][] noDictionaryKeyArrayWithNewlyAddedColumns = new byte[noDictKeyArray.length + this.dimensionInfo.getNewNoDictionaryColumnCount()][];
            int existingColumnValueIndex = 0;
            int newKeyArrayIndex = 0;
            for (int i = 0; i < this.dimensionInfo.getDimensionExists().length; ++i) {
                if (actualQueryDimensions[i].getDimension().getDataType() == DataTypes.DATE || actualQueryDimensions[i].getDimension().hasEncoding(Encoding.IMPLICIT)) continue;
                if (this.dimensionInfo.getDimensionExists()[i]) {
                    noDictionaryKeyArrayWithNewlyAddedColumns[newKeyArrayIndex++] = noDictKeyArray[existingColumnValueIndex++];
                    continue;
                }
                byte[] newColumnDefaultValue = null;
                Object defaultValue = this.dimensionInfo.getDefaultValues()[i];
                newColumnDefaultValue = null != defaultValue ? (byte[])defaultValue : (actualQueryDimensions[i].getDimension().getDataType() == DataTypes.STRING ? DataTypeUtil.getDataTypeConverter().convertFromByteToUTF8Bytes(CarbonCommonConstants.MEMBER_DEFAULT_VAL_ARRAY) : CarbonCommonConstants.EMPTY_BYTE_ARRAY);
                noDictionaryKeyArrayWithNewlyAddedColumns[newKeyArrayIndex++] = newColumnDefaultValue;
            }
            byteArrayWrapper.setNoDictionaryKeys(noDictionaryKeyArrayWithNewlyAddedColumns);
        }
    }
}

