/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.scan.collector.impl;

import java.math.BigDecimal;
import java.util.List;
import org.apache.carbondata.core.keygenerator.directdictionary.DirectDictionaryKeyGeneratorFactory;
import org.apache.carbondata.core.metadata.datatype.DataType;
import org.apache.carbondata.core.metadata.datatype.DataTypes;
import org.apache.carbondata.core.metadata.schema.table.column.CarbonDimension;
import org.apache.carbondata.core.metadata.schema.table.column.CarbonMeasure;
import org.apache.carbondata.core.scan.collector.impl.DictionaryBasedVectorResultCollector;
import org.apache.carbondata.core.scan.executor.infos.BlockExecutionInfo;
import org.apache.carbondata.core.scan.executor.util.RestructureUtil;
import org.apache.carbondata.core.scan.result.BlockletScannedResult;
import org.apache.carbondata.core.scan.result.vector.CarbonColumnVector;
import org.apache.carbondata.core.scan.result.vector.CarbonColumnarBatch;
import org.apache.carbondata.core.scan.result.vector.ColumnVectorInfo;

public class RestructureBasedVectorResultCollector
extends DictionaryBasedVectorResultCollector {
    private Object[] measureDefaultValues = null;

    public RestructureBasedVectorResultCollector(BlockExecutionInfo blockExecutionInfos) {
        super(blockExecutionInfos);
        this.queryDimensions = this.executionInfo.getActualQueryDimensions();
        this.queryMeasures = this.executionInfo.getActualQueryMeasures();
        this.measureDefaultValues = new Object[this.queryMeasures.length];
        this.allColumnInfo = new ColumnVectorInfo[this.queryDimensions.length + this.queryMeasures.length];
        this.createVectorForNewlyAddedDimensions();
        this.createVectorForNewlyAddedMeasures();
        this.prepareDimensionAndMeasureColumnVectors();
    }

    private void createVectorForNewlyAddedDimensions() {
        for (int i = 0; i < this.queryDimensions.length; ++i) {
            if (this.dimensionInfo.getDimensionExists()[i]) continue;
            ColumnVectorInfo columnVectorInfo = new ColumnVectorInfo();
            columnVectorInfo.dimension = this.queryDimensions[i];
            if (this.queryDimensions[i].getDimension().getDataType().equals(DataTypes.TIMESTAMP) || this.queryDimensions[i].getDimension().getDataType().equals(DataTypes.DATE)) {
                columnVectorInfo.directDictionaryGenerator = DirectDictionaryKeyGeneratorFactory.getDirectDictionaryGenerator(this.queryDimensions[i].getDimension().getDataType());
            }
            this.allColumnInfo[this.queryDimensions[i].getOrdinal()] = columnVectorInfo;
        }
    }

    private void createVectorForNewlyAddedMeasures() {
        for (int i = 0; i < this.queryMeasures.length; ++i) {
            ColumnVectorInfo columnVectorInfo;
            if (this.measureInfo.getMeasureExists()[i]) continue;
            this.allColumnInfo[this.queryMeasures[i].getOrdinal()] = columnVectorInfo = new ColumnVectorInfo();
            columnVectorInfo.measure = this.queryMeasures[i];
            this.measureDefaultValues[i] = this.getMeasureDefaultValue(this.queryMeasures[i].getMeasure());
        }
    }

    private Object getMeasureDefaultValue(CarbonMeasure carbonMeasure) {
        return RestructureUtil.getMeasureDefaultValueByType(carbonMeasure.getColumnSchema(), carbonMeasure.getDefaultValue());
    }

    @Override
    public List<Object[]> collectResultInRow(BlockletScannedResult scannedResult, int batchSize) {
        throw new UnsupportedOperationException("collectResultInRow is not supported here");
    }

    @Override
    public void collectResultInColumnarBatch(BlockletScannedResult scannedResult, CarbonColumnarBatch columnarBatch) {
        int numberOfPages = scannedResult.numberOfpages();
        while (scannedResult.getCurrentPageCounter() < numberOfPages) {
            int currentPageRowCount = scannedResult.getCurrentPageRowCount();
            if (currentPageRowCount == 0) {
                scannedResult.incrementPageCounter();
                continue;
            }
            int rowCounter = scannedResult.getRowCounter();
            int availableRows = currentPageRowCount - rowCounter;
            int requiredRows = columnarBatch.getBatchSize() - columnarBatch.getRowCounter();
            if ((requiredRows = Math.min(requiredRows, availableRows)) < 1) {
                return;
            }
            this.fillColumnVectorDetails(columnarBatch, rowCounter, requiredRows);
            int filteredRows = scannedResult.markFilteredRows(columnarBatch, rowCounter, requiredRows, columnarBatch.getRowCounter());
            this.fillDataForNonExistingDimensions();
            this.fillDataForNonExistingMeasures();
            this.fillResultToColumnarBatch(scannedResult, columnarBatch, rowCounter, availableRows, requiredRows);
            columnarBatch.setActualSize(columnarBatch.getActualSize() + requiredRows - filteredRows);
        }
    }

    private void fillDataForNonExistingDimensions() {
        for (int i = 0; i < this.executionInfo.getActualQueryDimensions().length; ++i) {
            if (this.dimensionInfo.getDimensionExists()[i]) continue;
            int queryOrder = this.executionInfo.getActualQueryDimensions()[i].getOrdinal();
            CarbonDimension dimension = this.executionInfo.getActualQueryDimensions()[i].getDimension();
            if (dimension.getDataType() == DataTypes.DATE) {
                this.fillDirectDictionaryData(this.allColumnInfo[queryOrder].vector, this.allColumnInfo[queryOrder], this.dimensionInfo.getDefaultValues()[i]);
                continue;
            }
            this.fillNoDictionaryData(this.allColumnInfo[queryOrder].vector, this.allColumnInfo[queryOrder], this.dimensionInfo.getDefaultValues()[i]);
        }
    }

    private void fillDirectDictionaryData(CarbonColumnVector vector, ColumnVectorInfo columnVectorInfo, Object defaultValue) {
        if (null != defaultValue) {
            if (columnVectorInfo.directDictionaryGenerator.getReturnType().equals(DataTypes.INT)) {
                vector.putInts(columnVectorInfo.vectorOffset, columnVectorInfo.size, (Integer)defaultValue);
            } else {
                vector.putLongs(columnVectorInfo.vectorOffset, columnVectorInfo.size, (Long)defaultValue);
            }
        } else {
            vector.putNulls(columnVectorInfo.vectorOffset, columnVectorInfo.size);
        }
    }

    private void fillNoDictionaryData(CarbonColumnVector vector, ColumnVectorInfo columnVectorInfo, Object defaultValue) {
        if (null != defaultValue) {
            DataType dataType = columnVectorInfo.dimension.getDimension().getDataType();
            if (dataType == DataTypes.INT) {
                vector.putInts(columnVectorInfo.vectorOffset, columnVectorInfo.size, (Integer)defaultValue);
            } else if (dataType == DataTypes.LONG || dataType == DataTypes.TIMESTAMP) {
                vector.putLongs(columnVectorInfo.vectorOffset, columnVectorInfo.size, (Long)defaultValue);
            } else {
                vector.putByteArray(columnVectorInfo.vectorOffset, columnVectorInfo.size, (byte[])defaultValue);
            }
        } else {
            vector.putNulls(columnVectorInfo.vectorOffset, columnVectorInfo.size);
        }
    }

    private void fillDataForNonExistingMeasures() {
        for (int i = 0; i < this.executionInfo.getActualQueryMeasures().length; ++i) {
            if (this.measureInfo.getMeasureExists()[i]) continue;
            int queryOrder = this.executionInfo.getActualQueryMeasures()[i].getOrdinal();
            CarbonMeasure measure = this.executionInfo.getActualQueryMeasures()[i].getMeasure();
            ColumnVectorInfo columnVectorInfo = this.allColumnInfo[queryOrder];
            CarbonColumnVector vector = columnVectorInfo.vector;
            Object defaultValue = this.measureDefaultValues[i];
            if (null == defaultValue) {
                vector.putNulls(columnVectorInfo.vectorOffset, columnVectorInfo.size);
                continue;
            }
            DataType dataType = this.measureInfo.getMeasureDataTypes()[i];
            if (dataType == DataTypes.SHORT) {
                vector.putShorts(columnVectorInfo.vectorOffset, columnVectorInfo.size, (Short)defaultValue);
                continue;
            }
            if (dataType == DataTypes.INT) {
                vector.putInts(columnVectorInfo.vectorOffset, columnVectorInfo.size, (Integer)defaultValue);
                continue;
            }
            if (dataType == DataTypes.LONG) {
                vector.putLongs(columnVectorInfo.vectorOffset, columnVectorInfo.size, (Long)defaultValue);
                continue;
            }
            if (DataTypes.isDecimal(dataType)) {
                vector.putDecimals(columnVectorInfo.vectorOffset, columnVectorInfo.size, (BigDecimal)defaultValue, measure.getPrecision());
                continue;
            }
            if (dataType == DataTypes.BOOLEAN) {
                vector.putBoolean(columnVectorInfo.vectorOffset, (Boolean)defaultValue);
                continue;
            }
            vector.putDoubles(columnVectorInfo.vectorOffset, columnVectorInfo.size, (Double)defaultValue);
        }
    }
}

