/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.scan.collector.impl;

import java.util.ArrayList;
import java.util.List;
import org.apache.carbondata.common.annotations.InterfaceAudience;
import org.apache.carbondata.core.scan.collector.impl.DictionaryBasedResultCollector;
import org.apache.carbondata.core.scan.executor.infos.BlockExecutionInfo;
import org.apache.carbondata.core.scan.result.BlockletScannedResult;

@InterfaceAudience.Internal
public class RowIdBasedResultCollector
extends DictionaryBasedResultCollector {
    public RowIdBasedResultCollector(BlockExecutionInfo blockExecutionInfos) {
        super(blockExecutionInfos);
    }

    @Override
    public List<Object[]> collectResultInRow(BlockletScannedResult scannedResult, int batchSize) {
        ArrayList<Object[]> listBasedResult = new ArrayList<Object[]>(batchSize);
        int rowCounter = 0;
        int columnCount = this.queryDimensions.length + this.queryMeasures.length;
        while (scannedResult.hasNext() && rowCounter < batchSize) {
            scannedResult.incrementCounter();
            if (scannedResult.containsDeletedRow(scannedResult.getCurrentRowId())) continue;
            Object[] row = new Object[columnCount + 3];
            row[columnCount] = scannedResult.getBlockletNumber();
            row[columnCount + 1] = scannedResult.getCurrentPageCounter();
            if (this.isDimensionExists) {
                int[] surrogateResult = scannedResult.getDictionaryKeyIntegerArray();
                byte[][] noDictionaryKeys = scannedResult.getNoDictionaryKeyArray();
                byte[][] complexTypeKeyArray = scannedResult.getComplexTypeKeyArray();
                this.dictionaryColumnIndex = 0;
                this.noDictionaryColumnIndex = 0;
                this.complexTypeColumnIndex = 0;
                for (int i = 0; i < this.queryDimensions.length; ++i) {
                    this.fillDimensionData(scannedResult, surrogateResult, noDictionaryKeys, complexTypeKeyArray, this.comlexDimensionInfoMap, row, i, this.queryDimensions[i].getDimension().getOrdinal());
                }
            }
            row[columnCount + 2] = scannedResult.getCurrentRowId();
            this.fillMeasureData(scannedResult, row);
            listBasedResult.add(row);
            ++rowCounter;
        }
        return listBasedResult;
    }
}

