/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.scan.collector.impl;

import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import org.apache.carbondata.common.annotations.InterfaceAudience;
import org.apache.carbondata.core.scan.collector.impl.AbstractScannedResultCollector;
import org.apache.carbondata.core.scan.executor.infos.BlockExecutionInfo;
import org.apache.carbondata.core.scan.model.ProjectionMeasure;
import org.apache.carbondata.core.scan.result.BlockletScannedResult;
import org.apache.carbondata.core.scan.wrappers.ByteArrayWrapper;
import org.apache.carbondata.core.stats.QueryStatistic;

@InterfaceAudience.Internal
public class RowIdRawBasedResultCollector
extends AbstractScannedResultCollector {
    public RowIdRawBasedResultCollector(BlockExecutionInfo blockExecutionInfos) {
        super(blockExecutionInfos);
    }

    @Override
    public List<Object[]> collectResultInRow(BlockletScannedResult scannedResult, int batchSize) {
        long startTime = System.currentTimeMillis();
        ArrayList<Object[]> listBasedResult = new ArrayList<Object[]>(batchSize);
        ProjectionMeasure[] queryMeasures = this.executionInfo.getProjectionMeasures();
        this.scanAndFillData(scannedResult, batchSize, listBasedResult, queryMeasures);
        QueryStatistic resultPrepTime = this.queryStatisticsModel.getStatisticsTypeAndObjMap().get("result preparation time");
        resultPrepTime.addCountStatistic("result preparation time", resultPrepTime.getCount() + (System.currentTimeMillis() - startTime));
        return listBasedResult;
    }

    protected void scanAndFillData(BlockletScannedResult scannedResult, int batchSize, List<Object[]> listBasedResult, ProjectionMeasure[] queryMeasures) {
        int numberOfPages = scannedResult.numberOfpages();
        while (scannedResult.getCurrentPageCounter() < numberOfPages) {
            int currentPageRowCount = scannedResult.getCurrentPageRowCount();
            if (currentPageRowCount == 0) {
                scannedResult.incrementPageCounter();
                continue;
            }
            int rowCounter = scannedResult.getRowCounter();
            int availableRows = currentPageRowCount - rowCounter;
            int availableBatchRowCount = Math.min(batchSize, availableRows);
            if (availableBatchRowCount < 1) break;
            batchSize = batchSize > availableRows ? (batchSize -= availableRows) : 0;
            ArrayList<Object[]> collectedData = new ArrayList<Object[]>(availableBatchRowCount);
            this.fillDimensionData(scannedResult, collectedData, queryMeasures, availableBatchRowCount);
            this.fillMeasureData(scannedResult, collectedData);
            if (collectedData.size() < availableBatchRowCount) {
                batchSize += availableBatchRowCount - listBasedResult.size();
            }
            listBasedResult.addAll(collectedData);
        }
    }

    private void fillDimensionData(BlockletScannedResult scannedResult, List<Object[]> listBasedResult, ProjectionMeasure[] queryMeasures, int batchSize) {
        long startTime = System.currentTimeMillis();
        List<byte[]> dictionaryKeyArrayBatch = scannedResult.getDictionaryKeyArrayBatch(batchSize);
        List<byte[][]> noDictionaryKeyArrayBatch = scannedResult.getNoDictionaryKeyArrayBatch(batchSize);
        List<byte[][]> complexTypeKeyArrayBatch = scannedResult.getComplexTypeKeyArrayBatch(batchSize);
        byte[] implicitColumnByteArray = scannedResult.getBlockletId().getBytes(Charset.forName("UTF-8"));
        for (int i = 0; i < dictionaryKeyArrayBatch.size(); ++i) {
            Object[] row = new Object[1 + queryMeasures.length + 3];
            scannedResult.incrementCounter();
            row[1 + queryMeasures.length] = scannedResult.getBlockletNumber();
            row[1 + queryMeasures.length + 1] = scannedResult.getCurrentPageCounter();
            ByteArrayWrapper wrapper = new ByteArrayWrapper();
            wrapper.setDictionaryKey(dictionaryKeyArrayBatch.get(i));
            wrapper.setNoDictionaryKeys(noDictionaryKeyArrayBatch.get(i));
            wrapper.setComplexTypesKeys(complexTypeKeyArrayBatch.get(i));
            wrapper.setImplicitColumnByteArray(implicitColumnByteArray);
            row[0] = wrapper;
            row[1 + queryMeasures.length + 2] = scannedResult.getCurrentRowId();
            listBasedResult.add(row);
        }
        QueryStatistic keyColumnFillingTime = this.queryStatisticsModel.getStatisticsTypeAndObjMap().get("key column filling time");
        keyColumnFillingTime.addCountStatistic("key column filling time", keyColumnFillingTime.getCount() + (System.currentTimeMillis() - startTime));
    }

    private void fillMeasureData(BlockletScannedResult scannedResult, List<Object[]> listBasedResult) {
        long startTime = System.currentTimeMillis();
        if (!listBasedResult.isEmpty()) {
            this.fillMeasureDataBatch(listBasedResult, 1, scannedResult);
        }
        QueryStatistic measureFillingTime = this.queryStatisticsModel.getStatisticsTypeAndObjMap().get("measure filling time");
        measureFillingTime.addCountStatistic("measure filling time", measureFillingTime.getCount() + (System.currentTimeMillis() - startTime));
    }

    private void incrementScannedResultRowCounter(BlockletScannedResult scannedResult, int batchSize) {
        scannedResult.incrementCounter(batchSize);
    }
}

